/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCCallExpression {
    public OCCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    protected OCOperatorReference createReference() {
        OCOperatorReference oCOperatorReference = this.createReference(this.getFunctionReferenceExpression(), null);
        if (oCOperatorReference == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCOperatorReference;
    }

    public OCOperatorReference createReference(OCExpression function, @Nullable OCType functionType) {
        List<OCType> types = functionType != null ? Collections.singletonList(functionType) : null;
        ArrayList<OCExpression> exprs = new ArrayList<OCExpression>();
        exprs.add(function);
        exprs.addAll(this.getArguments());
        class OCCallOperatorReference
        extends OCOperatorReference
        implements MultiRangeReference {
            OCCallOperatorReference(OCElement element, List<OCExpression> arguments, List<OCType> paramTypes) {
                super((PsiElement)element, "()", OCOperatorReference.OperatorPlacement.POSTFIX, null, arguments, paramTypes);
            }

            @Override
            public boolean isValid() {
                return super.isValid() && this.myArguments.size() == OCCallExpressionImpl.this.getArguments().size() + 1;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                Iterator<TextRange> ranges = this.getRanges().iterator();
                if (!ranges.hasNext()) {
                    TextRange textRange = super.getRangeInElement();
                    if (textRange == null) {
                        OCCallOperatorReference.$$$reportNull$$$0(0);
                    }
                    return textRange;
                }
                TextRange left = ranges.next();
                if (!ranges.hasNext()) {
                    TextRange textRange = super.getRangeInElement();
                    if (textRange == null) {
                        OCCallOperatorReference.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }
                TextRange textRange = left;
                if (textRange == null) {
                    OCCallOperatorReference.$$$reportNull$$$0(2);
                }
                return textRange;
            }

            @NotNull
            public List<TextRange> getRanges() {
                PsiElement right;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                OCArgumentList argumentList = OCCallExpressionImpl.this.getArgumentList();
                TextRange argListRange = OCElementUtil.getRangeInParent(argumentList);
                PsiElement left = argumentList.getLeftPar();
                if (left != null) {
                    result.add(OCElementUtil.getRangeInParent(left).shiftRight(argListRange.getStartOffset()));
                }
                if ((right = argumentList.getRightPar()) != null) {
                    result.add(OCElementUtil.getRangeInParent(right).shiftRight(argListRange.getStartOffset()));
                }
                ArrayList<TextRange> arrayList = result;
                if (arrayList == null) {
                    OCCallOperatorReference.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl$1OCCallOperatorReference";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRanges";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
        return new OCCallOperatorReference(this, exprs, types);
    }

    @Override
    @NotNull
    public OCExpression getFunctionReferenceExpression() {
        OCExpression oCExpression = (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        if (oCExpression == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(2);
        }
        return oCExpression;
    }

    @Override
    @NotNull
    public OCArgumentList getArgumentList() {
        OCArgumentList oCArgumentList = (OCArgumentList)this.findNotNullChildByType(OCElementTypes.ARGUMENT_LIST);
        if (oCArgumentList == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return oCArgumentList;
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        List<OCExpression> list = this.getArgumentList().getArguments();
        if (list == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(5);
        }
        visitor.visitCallExpression(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType unresolvedType;
        OCType resolvedType;
        if (context == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(6);
        }
        if ((resolvedType = (unresolvedType = this.getType(context)).resolve(context)) instanceof OCStructType) {
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(this.getArguments());
            OCType oCType = OCTypeUtils.deduceClassTemplateArguments((OCStructType)resolvedType, unresolvedType, arguments, true, context, this.getContainingFile().getVirtualFile(), this.getComplexOffset());
            if (oCType == null) {
                OCCallExpressionImpl.$$$reportNull$$$0(7);
            }
            return oCType;
        }
        OCType oCType = resolvedType;
        if (oCType == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType funType;
        OCExpression funRef;
        OCOperatorReference reference;
        if (context == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(9);
        }
        if ((reference = this.createReference(funRef = this.getFunctionReferenceExpression(), funType = this.getCalleeType(context))) != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = ((OCFunctionSymbol)operator).getEffectiveType(this);
                if (oCType == null) {
                    OCCallExpressionImpl.$$$reportNull$$$0(10);
                }
                return oCType;
            }
        }
        OCSymbol callerSymbol = null;
        if (funRef instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)funRef).getReferenceElement();
            callerSymbol = referenceElement != null ? referenceElement.resolveToSymbol(context) : null;
        }
        OCType result = OCCallExpressionImpl.getCallExprType(funType, callerSymbol, context);
        OCType guessedType = this.getGuessedType();
        OCType oCType = guessedType != null ? result.cloneWithGuessedType(guessedType) : result;
        if (oCType == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(11);
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCType getCalleeType(@NotNull OCResolveContext context) {
        OCType funType;
        if (context == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(12);
        }
        if (OCTypeUtils.isUnresolvedLambdaAutoType(funType = this.getFunctionReferenceExpression().getResolvedType(context))) {
            funType = OCTypeUtils.resolveLambdaAutoType(funType, context, OCArgumentsList.getArgumentList(this.getArguments()), false);
        }
        return funType;
    }

    @NotNull
    public static OCType getCallExprType(@Nullable OCType funType, @Nullable OCSymbol callerSymbol, @NotNull OCResolveContext context) {
        if (context == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(13);
        }
        OCType result = OCUnknownType.INSTANCE;
        if (callerSymbol instanceof OCStructSymbol) {
            result = callerSymbol.getType();
        } else if (callerSymbol != null && callerSymbol.getKind() == OCSymbolKind.TYPEDEF && !(funType instanceof OCFunctionType)) {
            result = funType;
        } else if (funType != null) {
            if ((funType = funType.getTerminalType()) instanceof OCStructType) {
                result = funType;
            } else if (funType instanceof OCFunctionType) {
                result = ((OCFunctionType)funType).getReturnType();
            } else if (funType.isMagicInside(context) && !funType.isUnresolved(context)) {
                result = new OCMagicType();
            }
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(callerSymbol != null ? context.getProject() : null);
        }
        OCType oCType = result;
        if (oCType == null) {
            OCCallExpressionImpl.$$$reportNull$$$0(14);
        }
        return oCType;
    }

    @Nullable
    private OCType getGuessedType() {
        VirtualFile containingFile;
        OCSymbol symbol;
        OCExpression function = this.getFunctionReferenceExpression();
        if (function instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)function).resolveToSymbol()) instanceof OCFunctionSymbol && symbol.getName().startsWith("is") && (containingFile = symbol.getContainingFile()) != null && containingFile.getName().equals("ctype.h")) {
            return OCIntType.getAppropriateBool(this);
        }
        return null;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        OCExpression function = this.getFunctionReferenceExpression();
        return function instanceof OCQualifiedExpression ? Collections.singletonList(((OCQualifiedExpression)function).getQualifier()) : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCCallExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionReferenceExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExprType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCallExprType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

