/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceId;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodImpl
extends OCElementWithReferenceId<OCMethodSymbol>
implements OCMethod {
    public OCMethodImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCMethodImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.METHOD;
    }

    @Override
    @NotNull
    public OCClassDeclaration getContainingClass() {
        OCClassDeclaration parent = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCClassDeclaration.class});
        assert (parent != null);
        OCClassDeclaration oCClassDeclaration = parent;
        if (oCClassDeclaration == null) {
            OCMethodImpl.$$$reportNull$$$0(1);
        }
        return oCClassDeclaration;
    }

    @Override
    public boolean isInstanceMethod() {
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.MINUS) {
                return true;
            }
            if (tt != OCTokenTypes.PLUS) continue;
            return false;
        }
        return false;
    }

    @Override
    public void setStatic(boolean isStatic) {
        PsiElement psi = null;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.MINUS) {
                psi = node.getPsi();
                break;
            }
            if (tt != OCTokenTypes.PLUS) continue;
            psi = node.getPsi();
            break;
        }
        if (psi != null && psi.isWritable()) {
            psi.replace(OCElementFactory.binaryOperatorFromText(isStatic ? "+" : "-", psi));
        }
    }

    @Override
    @NotNull
    public String getSelector() {
        StringBuilder buf = new StringBuilder();
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        for (OCMethodSelectorPart selector : selectors) {
            buf.append(selector.getSelectorPart());
        }
        String string = buf.toString();
        if (string == null) {
            OCMethodImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getSelector();
        if (string == null) {
            OCMethodImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement getNameIdentifier() {
        OCMethodSelectorPart selector = (OCMethodSelectorPart)this.findChildByType(OCElementTypes.METHOD_SELECTOR_PART);
        return selector != null ? selector.getSelectorIdentifier() : null;
    }

    @Override
    public int getTextOffset() {
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        if (selectors.isEmpty()) {
            return super.getTextOffset();
        }
        return ((OCMethodSelectorPart)selectors.get(0)).getTextRange().getStartOffset();
    }

    @Override
    public long getComplexOffset() {
        List selectors = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        if (selectors.isEmpty()) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset((PsiElement)selectors.get(0));
    }

    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        PsiElement identifier;
        if (newName == null) {
            OCMethodImpl.$$$reportNull$$$0(4);
        }
        if ((identifier = this.getParameters().get(0).getSelectorIdentifier()) != null) {
            OCElementUtil.replaceWithIdentifier(identifier, newName, this);
        }
        return this;
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCClassDeclaration clazz;
        OCType returnType;
        OCTypeElement typeElement = this.getReturnTypeElement();
        OCType oCType = returnType = typeElement != null ? typeElement.getType() : OCIdType.pointerToID();
        if (returnType instanceof OCReferenceType && returnType.getName().equals("instancetype") && (clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText(clazz.getName()));
            if (oCPointerType == null) {
                OCMethodImpl.$$$reportNull$$$0(5);
            }
            return oCPointerType;
        }
        OCType oCType2 = returnType;
        if (oCType2 == null) {
            OCMethodImpl.$$$reportNull$$$0(6);
        }
        return oCType2;
    }

    @Override
    @NotNull
    public OCType getRawReturnType() {
        OCTypeElement typeElement = this.getReturnTypeElement();
        OCType oCType = typeElement != null ? typeElement.getRawType() : OCIdType.pointerToID();
        if (oCType == null) {
            OCMethodImpl.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.TYPE_ELEMENT, OCElementTypes.CONCEPT_PLACEHOLDER_TYPE_ELEMENT}));
    }

    @Override
    @Nullable
    public OCParameterList getParameterList() {
        return null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return null;
    }

    @Override
    @NotNull
    public List<OCMethodSelectorPart> getParameters() {
        List list = this.findChildrenByType(OCElementTypes.METHOD_SELECTOR_PART);
        if (list == null) {
            OCMethodImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCMethodImpl.$$$reportNull$$$0(9);
        }
        visitor.visitMethod(this);
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCMethodImpl.this.getSelector();
            }

            public String getLocationString() {
                ItemPresentation classPresentation = OCMethodImpl.this.getContainingClass().getPresentation();
                return classPresentation != null ? classPresentation.getPresentableText() : "";
            }

            public Icon getIcon(boolean open) {
                return OCMethodImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public OCMethodSymbol getSymbol() {
        OCClassSymbol clazz = this.getContainingClass().getSymbol();
        if (clazz != null) {
            final boolean isStatic = !this.isInstanceMethod();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol methodSymbol) {
                    return methodSymbol.isStatic() == isStatic;
                }
            };
            clazz.processMembers(this.getSelector(), OCMethodSymbol.class, processor);
            return (OCMethodSymbol)processor.getFoundValue();
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiElement> getSelectors() {
        ArrayList<PsiElement> selectors = new ArrayList<PsiElement>();
        for (OCMethodSelectorPart part : this.getParameters()) {
            if (part.getSelectorIdentifier() == null) continue;
            selectors.add(part.getSelectorIdentifier());
        }
        ArrayList<PsiElement> arrayList = selectors;
        if (arrayList == null) {
            OCMethodImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    public TextRange getHeaderRange() {
        List<PsiElement> selectors = this.getSelectors();
        if (selectors.isEmpty()) {
            return new TextRange(this.getTextRange().getStartOffset(), this.getTextRange().getStartOffset());
        }
        return new TextRange(selectors.get(0).getTextRange().getStartOffset(), selectors.get(selectors.size() - 1).getTextRange().getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCMethodImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCMethodImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawReturnType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

