/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSetSuperclassIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCSymbol mySuperClass;
    private OCVisibility myVisibility;
    @IntentionName
    private final String myText;

    public OCSetSuperclassIntentionAction(@NotNull OCSymbol classSymbol, OCSymbol superClass, @Nullable OCVisibility visibility, @NotNull OCCompilationContext context) {
        if (classSymbol == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(1);
        }
        super(context.getProject(), classSymbol);
        this.mySuperClass = superClass;
        this.myVisibility = visibility;
        this.myText = this.getTextImpl(context);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @IntentionName
    private String getTextImpl(@NotNull OCCompilationContext context) {
        String superTypeName;
        if (context == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.mySymbol instanceof OCInterfaceSymbol && !(superTypeName = ((OCInterfaceSymbol)this.mySymbol).getSuperClassName()).isEmpty() && this.mySuperClass != null) {
            return OCInspectionsBundle.message("intention.name.change.superclass", this.mySymbol.getNameWithKindLowercase(context), superTypeName, this.mySuperClass.getPresentableName());
        }
        assert (this.mySuperClass != null);
        String subject = OCInspectionsBundle.message("intention.name.choice.superclass", this.myVisibility != null ? this.myVisibility.toString() : "", this.myVisibility != null ? 0 : 1, this.mySymbol.getNameWithKindLowercase(context));
        return OCInspectionsBundle.message("intention.name.set.superclass", this.mySuperClass.getPresentableName(), subject);
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.change.superclass", new Object[0]);
        if (string == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return !(!super.isAvailable() || this.mySymbol.isPredeclaration() || !(this.mySymbol instanceof OCInterfaceSymbol) && !(this.mySymbol instanceof OCStructSymbol) || !(this.mySuperClass instanceof OCInterfaceSymbol) && !(this.mySuperClass instanceof OCStructSymbol));
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCSetSuperclassIntentionAction.$$$reportNull$$$0(4);
        }
        OCSymbolDeclarator declaration = (OCSymbolDeclarator)this.mySymbol.locateDefinition(project);
        if (this.mySuperClass instanceof OCInterfaceSymbol) {
            if (declaration != null) {
                new OCElementsMover().setSuperClass((OCClassDeclaration)declaration, this.mySuperClass.getName());
            }
        } else {
            new OCElementsMover().removeBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, false);
            new OCElementsMover().addBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, this.myVisibility, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCSetSuperclassIntentionAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCSetSuperclassIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextImpl";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

