/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionUtil {
    private static final NamingConventionRule EMPTY_RULE = new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.ANY), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.NONE, "");

    public static boolean shouldIgnoreNamingConventionForSymbol(@Nullable OCSymbol symbol) {
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            return functionSymbol.isUDL() || functionSymbol.isCppOperator() || functionSymbol.isMainFunction();
        }
        return false;
    }

    public static String applyNamingConvention(@NlsSafe @NotNull String name, @Nullable OCSymbolKind symbolKind, @NotNull Project project) {
        if (name == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(1);
        }
        return OCNamingConventionUtil.applyNamingConvention(name, symbolKind, null, null, project);
    }

    public static String applyNamingConvention(@NlsSafe @NotNull String name, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        if (name == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(3);
        }
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project).apply(name);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @NotNull Project project) {
        if (names == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(5);
        }
        return OCNamingConventionUtil.applyNamingConvention(names, symbolKind, null, null, project);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<@NlsSafe String> names, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        if (names == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(7);
        }
        NamingConventionRule rule = OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project);
        return ContainerUtil.map(names, name -> rule.apply((String)name));
    }

    public static boolean matchesToNamingConvention(@NlsSafe @NotNull String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project) {
        if (name == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(8);
        }
        if (symbolKind == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(10);
        }
        return OCNamingConventionUtil.matchesToNamingConvention(name, symbolKind, null, null, project);
    }

    public static boolean matchesToNamingConvention(@NlsSafe @NotNull String name, @NotNull OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        if (name == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(11);
        }
        if (symbolKind == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(13);
        }
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project).match(name);
    }

    static NamingConventionRule getNamingConventionRuleForSymbol(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        if (project == null) {
            OCNamingConventionUtil.$$$reportNull$$$0(14);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        for (int i2 = settings.NAMING_CONVENTION_RULES.size() - 1; i2 >= 0; --i2) {
            NamingConventionRule rule = settings.NAMING_CONVENTION_RULES.get(i2);
            if (!rule.canApply(symbolKind, symbol, context, project)) continue;
            return rule;
        }
        return EMPTY_RULE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCNamingConventionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNamingConvention";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesToNamingConvention";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamingConventionRuleForSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

