/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class OCUsageWithContext
extends OCUsageInfo<PsiElement> {
    private static final int historyLength = 5;
    private PsiElement myParent;
    private List<PsiElement> myElements = new ArrayList<PsiElement>(5);

    public OCUsageWithContext(PsiElement element) {
        super(element);
        this.myParent = element.getParent();
        for (int i2 = 0; element != null && i2 < 5; element = element.getPrevSibling(), ++i2) {
            this.myElements.add(element);
        }
    }

    public PsiElement getElement() {
        for (PsiElement element : this.myElements) {
            if (!element.isValid()) continue;
            return element;
        }
        return this.myParent;
    }

    protected void setElement(PsiElement element) {
        this.myElements.clear();
        this.myElements.add(element);
        this.myParent = element.getParent();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    protected PsiElement addElement(PsiElement newElement) {
        for (PsiElement element : this.myElements) {
            if (!element.isValid()) continue;
            newElement = this.myParent.addAfter(newElement, element);
            this.myElements.add(0, newElement);
            return newElement;
        }
        newElement = OCChangeUtil.add(this.myParent, newElement);
        this.myElements.add(0, newElement);
        return newElement;
    }
}

