/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionAncestorsQuery
extends AbstractQuery<OCFunctionSymbol> {
    private final OCFunctionSymbol myFunction;
    private final boolean myProcessSameSymbols;
    private final boolean myGoTransitive;
    private final boolean myProcessConstructors;
    private final Project myProject;

    public OCFunctionAncestorsQuery(OCFunctionSymbol function, boolean goTransitive, boolean processSameSymbols, Project project) {
        this(function, goTransitive, processSameSymbols, false, project);
    }

    public OCFunctionAncestorsQuery(OCFunctionSymbol function, boolean goTransitive, boolean processSameSymbols, boolean processConstructors, Project project) {
        this.myFunction = function;
        this.myGoTransitive = goTransitive;
        this.myProcessSameSymbols = processSameSymbols;
        this.myProcessConstructors = processConstructors;
        this.myProject = project;
    }

    @Nullable
    public static OCFunctionSymbol findFirstVirtual(OCFunctionSymbol function, boolean processSameSymbols, @NotNull Project project) {
        if (project == null) {
            OCFunctionAncestorsQuery.$$$reportNull$$$0(0);
        }
        return (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, processSameSymbols, project), symbol -> symbol.isVirtual() || symbol.isOverride() || symbol.isFinal()).findFirst();
    }

    protected boolean processResults(@NotNull Processor<? super OCFunctionSymbol> consumer) {
        OCSymbol associated;
        OCSymbolWithQualifiedName struct;
        if (consumer == null) {
            OCFunctionAncestorsQuery.$$$reportNull$$$0(1);
        }
        if (!((struct = this.myFunction.getResolvedOwner(OCResolveContext.forSymbol(this.myFunction, this.myProject))) instanceof OCStructSymbol)) {
            return true;
        }
        if (struct.isPredeclaration() && (associated = struct.getDefinitionSymbol(this.myProject)) instanceof OCSymbolWithQualifiedName) {
            struct = (OCSymbolWithQualifiedName)associated;
        }
        HashMap map = new HashMap();
        OCResolveContext context = OCResolveContext.forSymbol(this.myFunction, this.myProject);
        OCType resolvedType = this.myFunction.getResolvedType(context);
        boolean isDestructor = this.myFunction.isCppDestructor();
        boolean isConstructor = this.myFunction.isCppConstructor();
        Condition condition = symbol -> symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriendOrStatic() && new OCTypeEqualityAfterResolvingVisitor(resolvedType, true, context).isFunctionSignatureEqual(symbol.getType().resolve(context));
        OCSymbolWithQualifiedName finalStruct = struct;
        Processor processor = symbol -> {
            if (!(symbol instanceof OCFunctionSymbol)) {
                return false;
            }
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            OCQualifiedName name = functionSymbol.getResolvedQualifiedName(OCResolveContext.forSymbol(symbol, this.myProject));
            if (isDestructor && !functionSymbol.isCppDestructor() || isConstructor && !functionSymbol.isCppConstructor() || !this.myProcessSameSymbols && finalStruct.equals(functionSymbol.getParent())) {
                return true;
            }
            OCFunctionSymbol old = (OCFunctionSymbol)map.get(name);
            if (old == null || !old.isPredeclaration()) {
                map.put(name, functionSymbol);
            }
            return true;
        };
        if (!this.myFunction.isFriendOrStatic()) {
            String name = isDestructor || this.myProcessConstructors && isConstructor ? null : this.myFunction.getName();
            OCStructType.processMembersInBaseTypes((OCStructSymbol)struct, name, false, this.myGoTransitive, (Condition<? super OCSymbol>)condition, (Processor<? super OCSymbol>)processor, context);
        }
        if (this.myProcessSameSymbols) {
            this.myFunction.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(condition, processor), this.myProject);
        }
        for (OCFunctionSymbol symbol2 : map.values()) {
            if (!(this.myProcessSameSymbols ? !symbol2.processSameSymbols(new OCCommonProcessors.TypeFilteredProcessor(consumer, OCFunctionSymbol.class), this.myProject) : !consumer.process((Object)symbol2))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/search/OCFunctionAncestorsQuery";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFirstVirtual";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processResults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

