/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.formatter.OCPredefinedCodeStyleBase;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMicrosoftCodeStyle
extends OCPredefinedCodeStyleBase {
    public OCMicrosoftCodeStyle() {
        super("Microsoft", "microsoft");
    }

    public OCMicrosoftCodeStyle(@NotNull @NlsContexts.ListItem String name, @NotNull String id) {
        if (name == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(0);
        }
        if (id == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(1);
        }
        super(name, id);
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        super.apply(settings);
        OCMicrosoftCodeStyle.applyNewLineAndSpaceOptions(commonSettings, ocSettings);
        OCMicrosoftCodeStyle.applyIndentOptions(indentOptions, ocSettings);
        OCMicrosoftCodeStyle.applyNamingConventionSettings(ocSettings);
    }

    private static void applyIndentOptions(@Nullable CommonCodeStyleSettings.IndentOptions indentOptions, @NotNull OCCodeStyleSettings ocSettings) {
        if (ocSettings == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            return;
        }
        indentOptions.USE_TAB_CHARACTER = true;
        indentOptions.INDENT_SIZE = 4;
        indentOptions.LABEL_INDENT_ABSOLUTE = false;
        indentOptions.LABEL_INDENT_SIZE = -4;
        ocSettings.INDENT_NAMESPACE_MEMBERS = 4;
        ocSettings.INDENT_C_STRUCT_MEMBERS = 4;
        ocSettings.INDENT_CLASS_MEMBERS = 4;
    }

    private static void applyNewLineAndSpaceOptions(@NotNull CommonCodeStyleSettings commonSettings, @NotNull OCCodeStyleSettings ocSettings) {
        if (commonSettings == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(3);
        }
        if (ocSettings == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(4);
        }
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = true;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = true;
        commonSettings.KEEP_FIRST_COLUMN_COMMENT = true;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.WHILE_ON_NEW_LINE = false;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.FINALLY_ON_NEW_LINE = true;
        commonSettings.SPACE_BEFORE_CATCH_KEYWORD = true;
        commonSettings.SPACE_BEFORE_WHILE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = false;
        commonSettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = false;
        commonSettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = false;
        commonSettings.KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE = true;
        ocSettings.KEEP_STRUCTURES_IN_ONE_LINE = false;
        ocSettings.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE = false;
        ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE = false;
        ocSettings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT = false;
        ocSettings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT = false;
        commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS = false;
        ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = false;
        ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE_PARS = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE_PARS = false;
        commonSettings.INDENT_BREAK_FROM_CASE = true;
        commonSettings.CASE_STATEMENT_ON_NEW_LINE = true;
        commonSettings.INDENT_CASE_FROM_SWITCH = false;
        commonSettings.SPACE_AFTER_TYPE_CAST = false;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = true;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CAST_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_BRACKETS = false;
        commonSettings.SPACE_WITHIN_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_BRACES = false;
        ocSettings.SPACE_WITHIN_EMPTY_LAMBDA_CAPTURE_LIST_BRACKET = false;
        ocSettings.SPACE_WITHIN_LAMBDA_CAPTURE_LIST_BRACKET = false;
        ocSettings.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_CALL_PARENTHESES = false;
        ocSettings.SPACE_BEFORE_SUPERCLASS_COLON = true;
        ocSettings.SPACE_AFTER_SUPERCLASS_COLON = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        ocSettings.SPACE_AROUND_PM_OPERATORS = false;
        ocSettings.SPACE_BEFORE_INIT_LIST_COLON = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.SPACE_BEFORE_SEMICOLON = false;
        commonSettings.SPACE_AFTER_SEMICOLON = true;
        commonSettings.BRACE_STYLE = 2;
        commonSettings.CLASS_BRACE_STYLE = 2;
        commonSettings.METHOD_BRACE_STYLE = 2;
        commonSettings.LAMBDA_BRACE_STYLE = 2;
        ocSettings.FUNCTION_BRACE_PLACEMENT = 2;
        ocSettings.NAMESPACE_BRACE_PLACEMENT = 2;
        ocSettings.BLOCK_BRACE_PLACEMENT = 2;
        ocSettings.SPACE_BEFORE_POINTER_IN_DECLARATION = false;
        ocSettings.SPACE_BEFORE_REFERENCE_IN_DECLARATION = false;
        ocSettings.SPACE_AFTER_POINTER_IN_DECLARATION = true;
        ocSettings.SPACE_AFTER_REFERENCE_IN_DECLARATION = true;
    }

    private static void applyNamingConventionSettings(@NotNull OCCodeStyleSettings settings) {
        if (settings == null) {
            OCMicrosoftCodeStyle.$$$reportNull$$$0(5);
        }
        settings.NAMING_CONVENTION_RULES = ContainerUtil.newArrayList((Object[])new NamingConventionRule[]{new NamingConventionRule(NamingConventionRule.EntityKind.MACRO, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.SCREAMING_SNAKE_CASE, ""), new NamingConventionRule(NamingConventionRule.EntityKind.NAMESPACE, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS, NamingConventionRule.EntityKind.ENUM, NamingConventionRule.EntityKind.TYPEDEF, NamingConventionRule.EntityKind.UNION), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS_MEMBER_FUNCTION, NamingConventionRule.EntityKind.STRUCT_MEMBER_FUNCTION), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS_MEMBER_FIELD, NamingConventionRule.EntityKind.STRUCT_MEMBER_FIELD), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(NamingConventionRule.EntityKind.GLOBAL_FUNCTION, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(NamingConventionRule.EntityKind.PARAMETER, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.CAMEL_CASE, ""), new NamingConventionRule(NamingConventionRule.EntityKind.LOCAL_VARIABLE, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.CAMEL_CASE, "")});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/settings/formatter/OCMicrosoftCodeStyle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyIndentOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNewLineAndSpaceOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNamingConventionSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

