/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPointerType
extends OCType
implements ArcAnnotatedType {
    protected OCType myRefType;
    private ARCAttribute myARCAttribute;
    private OCType myClassQualifier;
    @Nullable
    private LengthOrNull myLengthInBrackets = null;
    public static final OCPointerType NULLPTR_T = OCPointerType.to(OCVoidType.instance());

    public OCPointerType() {
    }

    protected OCPointerType(OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile, nullability);
        this.myRefType = ref;
        this.myARCAttribute = attribute;
        this.myClassQualifier = classQualifier;
    }

    public static OCPointerType to(@NotNull OCType ref) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(0);
        }
        return new OCPointerType(ref, null, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(1);
        }
        return new OCPointerType(ref, attribute, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(2);
        }
        return new OCPointerType(ref, attribute, classQualifier, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, boolean isConst, boolean isVolatile) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(3);
        }
        return new OCPointerType(ref, attribute, classQualifier, null, isConst, isVolatile);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(4);
        }
        return new OCPointerType(ref, attribute, classQualifier, nullability, isConst, isVolatile);
    }

    public static OCType to(@NotNull OCType ref, int nTimes) {
        if (ref == null) {
            OCPointerType.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < nTimes; ++i2) {
            ref = OCPointerType.to(ref);
        }
        return ref;
    }

    @Override
    public void compact() {
        super.compact();
        this.myRefType.compact();
        if (this.myClassQualifier != null) {
            this.myClassQualifier.compact();
        }
    }

    public boolean isPointerToConst() {
        return this.myRefType.isConst();
    }

    public boolean isPointerToVolatile() {
        return this.myRefType.isVolatile();
    }

    @NotNull
    public OCType getRefType() {
        OCType oCType = this.myRefType;
        if (oCType == null) {
            OCPointerType.$$$reportNull$$$0(6);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        OCType oCType = this.myRefType.getTerminalType();
        if (oCType == null) {
            OCPointerType.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth() + 1;
    }

    public OCType getClassQualifier() {
        return this.myClassQualifier;
    }

    @Override
    public int hashCode() {
        return (this.baseHashCode() * 31 + this.myRefType.hashCode()) * 31 + (this.myClassQualifier != null ? this.myClassQualifier.hashCode() : 0);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCPointerType.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCPointerType.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCPointerType.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPointerType f = (OCPointerType)first;
        OCPointerType s = (OCPointerType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (!c.equalObjects(f.myRefType, s.myRefType)) {
            return false;
        }
        return c.equalObjects(f.myClassQualifier, s.myClassQualifier);
    }

    @Override
    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    @NotNull
    public OCPointerType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        OCPointerType clone = (OCPointerType)this.getShallowCopy();
        clone.myARCAttribute = arcAttribute;
        OCPointerType oCPointerType = clone;
        if (oCPointerType == null) {
            OCPointerType.$$$reportNull$$$0(12);
        }
        return oCPointerType;
    }

    @Override
    @Nullable
    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitPointerType(this);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(13);
        }
        if (this.equals(type, context)) {
            OCPointerType oCPointerType = this;
            if (oCPointerType == null) {
                OCPointerType.$$$reportNull$$$0(14);
            }
            return oCPointerType;
        }
        if (type instanceof OCMagicType) {
            OCType oCType = type;
            if (oCType == null) {
                OCPointerType.$$$reportNull$$$0(15);
            }
            return oCType;
        }
        if (this.isPointerToObject() && type.isPointerToObject() || type instanceof OCPointerType && this.myRefType.equals(((OCPointerType)type).getRefType(), false, context)) {
            OCPointerType oCPointerType = OCPointerType.to(this.myRefType.getLeastCommonType(((OCPointerType)type).getRefType(), context));
            if (oCPointerType == null) {
                OCPointerType.$$$reportNull$$$0(16);
            }
            return oCPointerType;
        }
        if (type.isNumberCompatible(context)) {
            OCPointerType oCPointerType = this;
            if (oCPointerType == null) {
                OCPointerType.$$$reportNull$$$0(17);
            }
            return oCPointerType;
        }
        if (type.isPointerCompatible(context)) {
            OCPointerType oCPointerType = OCPointerType.to(OCVoidType.instance());
            if (oCPointerType == null) {
                OCPointerType.$$$reportNull$$$0(18);
            }
            return oCPointerType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCPointerType.$$$reportNull$$$0(19);
        }
        return oCUnknownType;
    }

    public OCTypeCheckResult validateConstPointers(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(20);
        }
        OCType lType = this;
        OCType rType = type;
        boolean arrayToPointerCastsAvailable = true;
        boolean leftAlwaysPointsToConst = true;
        boolean hasConstMismatch = false;
        boolean hasVolatileMismatch = false;
        boolean hasLengthMismatch = false;
        boolean incompatibleType = false;
        boolean unassignableArray = false;
        boolean isEquals = true;
        int pointersCnt = 0;
        while (lType instanceof OCPointerType && rType instanceof OCPointerType) {
            ++pointersCnt;
            OCPointerType lPtrType = lType;
            OCPointerType rPtrType = (OCPointerType)rType;
            if (!lPtrType.isPointerToConst() && rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (!lPtrType.isPointerToVolatile() && rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToConst() && !rPtrType.isPointerToConst() && !leftAlwaysPointsToConst) {
                hasConstMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToVolatile() && !rPtrType.isPointerToVolatile() && !leftAlwaysPointsToConst) {
                hasVolatileMismatch = true;
            }
            leftAlwaysPointsToConst &= lPtrType.isPointerToConst();
            if (lPtrType instanceof OCBlockPointerType != rPtrType instanceof OCBlockPointerType) {
                isEquals = false;
            }
            if (lPtrType instanceof OCArrayType) {
                OCArrayType lArrayType = (OCArrayType)lPtrType;
                if (pointersCnt > 1 && rPtrType instanceof OCArrayType) {
                    OCArrayType rArrayType = (OCArrayType)rPtrType;
                    if (lArrayType.getLength(context) != rArrayType.getLength(context)) {
                        hasLengthMismatch = true;
                    }
                } else if (lArrayType.hasLength()) {
                    unassignableArray = true;
                }
            } else if (rPtrType instanceof OCArrayType) {
                if (pointersCnt > 1 || !arrayToPointerCastsAvailable) {
                    incompatibleType = true;
                }
                arrayToPointerCastsAvailable = false;
            }
            lType = lPtrType.myRefType;
            rType = rPtrType.myRefType;
            if (lType instanceof OCCppReferenceType) {
                lType = ((OCCppReferenceType)lType).getRefType();
            }
            if (!(rType instanceof OCCppReferenceType)) continue;
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        isEquals = lType instanceof OCIntType && rType instanceof OCIntType ? (isEquals &= lType.equals(rType, false, context)) : (isEquals &= context != null && lType.equals(rType, false, context));
        boolean isLTypeVoidPtr = lType.isVoid() && pointersCnt == 1;
        OCTypeCheckResult generalErrorResult = new OCTypeCheckResult(OCTypeCheckState.ERROR);
        if (!(isEquals || isLTypeVoidPtr || lType instanceof OCMagicType || rType instanceof OCMagicType)) {
            return generalErrorResult;
        }
        if ((hasConstMismatch || hasVolatileMismatch) && !lType.isUnknown() && !rType.isUnknown()) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        if (hasLengthMismatch || incompatibleType || unassignableArray) {
            return generalErrorResult;
        }
        return OCTypeCheckResult.createOK();
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(21);
        }
        return false;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(22);
        }
        return this.myRefType.isUnresolved(context) || this.myClassQualifier != null && (!this.myClassQualifier.isCppStructType(context) || this.myClassQualifier.isUnresolved(context));
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(23);
        }
        return this.myRefType.isMagicInside(context) || this.myClassQualifier != null && this.myClassQualifier.isMagicInside(context);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(24);
        }
        return this.myRefType.isSubclassOfMagic(context);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        OCPointerType oCPointerType = OCPointerType.to(this.myRefType.getGuessedUnmagicType());
        if (oCPointerType == null) {
            OCPointerType.$$$reportNull$$$0(25);
        }
        return oCPointerType;
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType instanceof OCObjectType;
    }

    @Override
    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCPointerType.$$$reportNull$$$0(26);
        }
        return this.myRefType.isCppStructType(context);
    }

    @Override
    public boolean isPointerToID(boolean withProtocols) {
        return this.myRefType instanceof OCIdType && (!withProtocols || !((OCIdType)this.myRefType).getAugmentedProtocols().isEmpty());
    }

    private boolean isRefTypeIntegral(@NotNull CTypeId id) {
        if (id == null) {
            OCPointerType.$$$reportNull$$$0(27);
        }
        return this.myRefType instanceof OCIntType && ((OCIntType)this.myRefType).getCTypeId() == id;
    }

    @Override
    public boolean isPointerToChar() {
        return this.isRefTypeIntegral(CTypeId.CHAR) || this.isRefTypeIntegral(CTypeId.SIGNED_CHAR) || this.isRefTypeIntegral(CTypeId.WCHAR_T) || this.isRefTypeIntegral(CTypeId.CHAR16_T) || this.isRefTypeIntegral(CTypeId.CHAR32_T);
    }

    @Override
    public boolean isCString() {
        return this.isPointerToChar();
    }

    @Override
    public boolean isPointerToVoid() {
        return this.myRefType.isVoid();
    }

    @Override
    @NonNls
    public String getFormatString() {
        if (this.isClassType()) {
            return "%@";
        }
        if (this.myRefType.isChar()) {
            return "%s";
        }
        if (this.isRefTypeIntegral(CTypeId.WCHAR_T)) {
            return "%ls";
        }
        if (this.isPointerToObject()) {
            return this.getRefType().getFormatString();
        }
        return "%p";
    }

    public boolean isArrayLikeParameter() {
        return this.myLengthInBrackets != null;
    }

    @Nullable
    public OCExpressionSymbol getLengthInBrackets() {
        OCLog.LOG.assertTrue(this.myLengthInBrackets != null, (Object)"Must be called only on array-like parameters");
        return this.myLengthInBrackets.length;
    }

    public void setLengthInBrackets(@Nullable OCExpressionSymbol lengthInBrackets) {
        this.myLengthInBrackets = new LengthOrNull(lengthInBrackets);
    }

    @Nullable
    public LengthOrNull getLengthOrNull() {
        return this.myLengthInBrackets;
    }

    public void setLengthOrNull(LengthOrNull l) {
        this.myLengthInBrackets = l;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCPointerType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCPointerType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithArcAttribute";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuessedUnmagicType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "to";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPointerCompatible";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateConstPointers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCppStructType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMagicInside";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isSubclassOfMagic";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToCppStructType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRefTypeIntegral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LengthOrNull {
        @Nullable
        final OCExpressionSymbol length;

        public LengthOrNull(@Nullable OCExpressionSymbol length) {
            this.length = length;
        }
    }
}

