/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;

public class OCBooleanTypeVisitor
implements OCTypeVisitor<Boolean> {
    @Override
    public Boolean visitFunctionType(OCFunctionType type) {
        if (type.getReturnType().accept(this).booleanValue()) {
            return true;
        }
        for (OCType arg : type.getParameterTypes()) {
            if (!arg.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitArrayType(OCArrayType type) {
        return type.getRefType().accept(this);
    }

    @Override
    public Boolean visitPointerType(OCPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    public Boolean visitBlockPointerType(OCBlockPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    public Boolean visitCppReferenceType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    @Override
    public Boolean visitEllipsisReferenceType(OCEllipsisType type) {
        return false;
    }

    @Override
    public Boolean visitMagicType(OCMagicType type) {
        return false;
    }

    @Override
    public Boolean visitObjectType(OCObjectType type) {
        return false;
    }

    @Override
    public Boolean visitIdType(OCIdType type) {
        return false;
    }

    @Override
    public Boolean visitIntType(OCIntType type) {
        return false;
    }

    @Override
    public Boolean visitRealType(OCRealType type) {
        return false;
    }

    @Override
    public Boolean visitReferenceType(OCReferenceType type) {
        return false;
    }

    @Override
    public Boolean visitStructType(OCStructType type) {
        return false;
    }

    @Override
    public Boolean visitUnknownType(OCUnknownType type) {
        return false;
    }

    @Override
    public Boolean visitVoidType(OCVoidType type) {
        return false;
    }

    @Override
    public Boolean visitTypeParameterType(OCTypeParameterType type) {
        return false;
    }

    @Override
    public Boolean visitAutoType(OCAutoType type) {
        return false;
    }

    @Override
    public Boolean visitVariadicType(OCVariadicType type) {
        return type.getUnderlyingType().accept(this);
    }

    @Override
    public Boolean visitExpansionPackType(OCExpansionPackType type) {
        for (OCTypeArgument argument : type.getExpansions()) {
            if (!(argument instanceof OCType) || !((OCType)argument).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitBracedInitListType(OCBracedInitListType type) {
        return false;
    }

    @Override
    public Boolean visitStructuredBindingType(OCStructuredBindingType type) {
        return false;
    }

    @Override
    public Boolean visitDeferredType(OCDeferredType type) {
        return false;
    }
}

