/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSslConfiguration {
    public static final String ELEMENT_NAME = "ssl-config";
    @NotNull
    public String myCaCertPath;
    @NotNull
    public String myClientCertPath;
    @NotNull
    public String myClientKeyPath;
    public boolean myEnabled;
    @NotNull
    public JdbcSettings.SslMode myMode;
    @NotNull
    public LocalDataSource.Storage myPasswordStorage;

    public DataSourceSslConfiguration(@NotNull String caCertPath, @NotNull String clientCertPath, @NotNull String clientKeyPath, boolean enabled, @NotNull JdbcSettings.SslMode mode) {
        if (caCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(0);
        }
        if (clientCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(1);
        }
        if (clientKeyPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(3);
        }
        this(caCertPath, clientCertPath, clientKeyPath, enabled, mode, LocalDataSource.Storage.PERSIST);
    }

    public DataSourceSslConfiguration(@NotNull String caCertPath, @NotNull String clientCertPath, @NotNull String clientKeyPath, boolean enabled, @NotNull JdbcSettings.SslMode mode, @NotNull LocalDataSource.Storage passwordStorage) {
        if (caCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(4);
        }
        if (clientCertPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(5);
        }
        if (clientKeyPath == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(7);
        }
        if (passwordStorage == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(8);
        }
        this.myCaCertPath = caCertPath;
        this.myClientKeyPath = clientKeyPath;
        this.myClientCertPath = clientCertPath;
        this.myEnabled = enabled;
        this.myMode = mode;
        this.myPasswordStorage = passwordStorage;
    }

    public static boolean equal(@Nullable DataSourceSslConfiguration c1, @Nullable DataSourceSslConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myCaCertPath)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myClientCertPath)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myClientKeyPath);
    }

    public boolean equalConfiguration(@NotNull DataSourceSslConfiguration cfg) {
        if (cfg == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(9);
        }
        if (this.myEnabled != cfg.myEnabled) {
            return false;
        }
        if (this.myMode != cfg.myMode) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCaCertPath), (CharSequence)StringUtil.nullize((String)cfg.myCaCertPath))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientCertPath), (CharSequence)StringUtil.nullize((String)cfg.myClientCertPath))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myClientKeyPath), (CharSequence)StringUtil.nullize((String)cfg.myClientKeyPath))) {
            return false;
        }
        return this.myPasswordStorage == cfg.myPasswordStorage;
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(10);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSource.writeTag(serializer, "ca-cert", this.myCaCertPath);
        LocalDataSource.writeTag(serializer, "client-cert", this.myClientCertPath);
        LocalDataSource.writeTag(serializer, "client-key", this.myClientKeyPath);
        LocalDataSource.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        if (this.myMode != JdbcSettings.SslMode.VERIFY_CA) {
            LocalDataSource.writeTag(serializer, "mode", this.myMode.toString());
        }
        if (this.myPasswordStorage != LocalDataSource.Storage.PERSIST) {
            LocalDataSource.writeTag(serializer, "password-storage", this.myPasswordStorage.toString());
        }
        serializer.endNode();
    }

    @Nullable
    public static DataSourceSslConfiguration deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            DataSourceSslConfiguration.$$$reportNull$$$0(11);
        }
        boolean enabled = false;
        String caCert = "";
        String clientCert = "";
        String clientKey = "";
        JdbcSettings.SslMode mode = JdbcSettings.SslMode.VERIFY_CA;
        LocalDataSource.Storage passwordStorage = LocalDataSource.Storage.PERSIST;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            String value2 = reader.getValue();
            if ("ca-cert".equals(name)) {
                caCert = value2;
            } else if ("client-cert".equals(name)) {
                clientCert = value2;
            } else if ("client-key".equals(name)) {
                clientKey = value2;
            } else if ("enabled".equals(name)) {
                enabled = Boolean.parseBoolean(value2);
            } else if ("mode".equals(name)) {
                mode = JdbcSettings.SslMode.valueOf((String)value2);
            } else if ("password-storage".equals(name)) {
                passwordStorage = LocalDataSource.Storage.valueOf(value2);
            }
            reader.moveUp();
        }
        DataSourceSslConfiguration cfg = new DataSourceSslConfiguration(caCert, clientCert, clientKey, enabled, mode, passwordStorage);
        return cfg.isEmpty() ? null : cfg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientCertPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientKeyPath";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordStorage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSslConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "equalConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

