/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SimpleDatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.UnmarshalException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DatabaseConnectionEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionEstablisher.class);
    private final ProtoConnectionImpl myProto;
    private final RemoteDriver myDriver;
    private final AtomicReference<Boolean> myStopProcessRef;
    private final ConnectionRequestor myRequestor;
    private final boolean mySilent;
    private int myAttemptNo;

    public static AsyncTask<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword) {
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(1);
        }
        if (requestor == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(3);
        }
        return AsyncTask.frame(DatabaseBundle.message("progress.title.establish.database.connection", new Object[0])).withFrameData(connectionPoint).computeAsync(null, () -> {
            JdbcDriverManager jdbcDriverManager = JdbcDriverManager.getDriverManager(project);
            RemoteDriver driver = jdbcDriverManager.getDriver(connectionPoint.getDataSource(), runConfiguration);
            Runnable releaseDriver = () -> jdbcDriverManager.releaseDriver(connectionPoint.getDataSource(), runConfiguration);
            return AsyncTask.frame(DatabaseBundle.message("progress.title.get.database.credentials", new Object[0])).computeAsync(null, () -> DatabaseConnectionEstablisher.processInterceptors(runConfiguration, connectionPoint, !askPassword, true).applyAsync(AsyncTask.NON_EDT, proto -> {
                DatabaseConnectionEstablisher establisher = new DatabaseConnectionEstablisher((ProtoConnectionImpl)proto, driver, releaseDriver, requestor, !askPassword);
                return AsyncTask.frame(DatabaseBundle.message("progress.title.perform.database.connection", new Object[0])).withFrameData(establisher).computeAsync(null, () -> establisher.tryConnect());
            }));
        });
    }

    DatabaseConnectionEstablisher(@NotNull ProtoConnectionImpl proto, @NotNull RemoteDriver driver, final @NotNull Runnable releaseDriver, @NotNull ConnectionRequestor requestor, boolean silent) {
        if (proto == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(4);
        }
        if (driver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(5);
        }
        if (releaseDriver == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(6);
        }
        if (requestor == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(7);
        }
        this.myAttemptNo = 0;
        this.myProto = proto;
        this.myRequestor = requestor;
        this.myStopProcessRef = new AtomicReference<Boolean>(true);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    if (DatabaseConnectionEstablisher.this.myStopProcessRef.get().booleanValue()) {
                        releaseDriver.run();
                    }
                }
            });
        }
        this.myDriver = driver;
        this.mySilent = silent;
    }

    @NotNull
    public AsyncTask<DatabaseConnection> tryConnect() {
        AsyncTask<DatabaseConnection> asyncTask;
        try {
            DatabaseConnection connection2 = this.connect();
            AsyncTask<DatabaseConnection> asyncTask2 = connection2 == null ? this.processNullConnection() : this.processConnected(connection2);
            asyncTask = asyncTask2;
        }
        catch (SQLException e) {
            AsyncTask.currentFrame().attachFrameData(e);
            AsyncTask<DatabaseConnection> asyncTask3 = this.processConnectionFailure(e);
            AsyncTask<DatabaseConnection> asyncTask4 = asyncTask3;
            if (asyncTask4 == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(9);
            }
            return asyncTask4;
        }
        finally {
            this.myStopProcessRef.set(false);
            ProgressManager.checkCanceled();
        }
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(8);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<DatabaseConnection> processConnectionFailure(@NotNull SQLException e) {
        if (e == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(10);
        }
        AsyncTask<DatabaseConnection> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.processing.connection.failure", new Object[0])).computeAsync(null, () -> this.handleConnectionFailure(e, this.myProto.activeInterceptors.iterator())).applyAsync(AsyncUtil.getNonEdtExecutor(), p2 -> this.tryReconnect());
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(11);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<DatabaseConnection> processConnected(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(12);
        }
        AsyncTask<DatabaseConnection> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.processing.connection.success", new Object[0])).computeAsync(null, () -> this.handleConnected(connection2, this.myProto.activeInterceptors.iterator())).handle().apply(null, p2 -> {
            if (p2.second != null) {
                LOG.error((Throwable)p2.second);
            }
            return connection2;
        });
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(13);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<DatabaseConnection> handleConnected(@NotNull DatabaseConnection connection2, @NotNull Iterator<DatabaseConnectionInterceptor> interceptors) {
        if (connection2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(14);
        }
        if (interceptors == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(15);
        }
        while (interceptors.hasNext()) {
            DatabaseConnectionInterceptor interceptor = interceptors.next();
            CompletionStage<?> handler = interceptor.handleConnected(connection2, this.myProto);
            CompletableFuture<?> future = handler == null ? null : handler.toCompletableFuture();
            if (future == null || future.isDone()) continue;
            AsyncTask<DatabaseConnection> asyncTask = AsyncTask.currentFrame().wrap(handler).applyAsync(null, any -> this.handleConnected(connection2, interceptors));
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(16);
            }
            return asyncTask;
        }
        AsyncTask<DatabaseConnection> asyncTask = AsyncTask.completed(connection2);
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(17);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull SQLException e, @NotNull Iterator<DatabaseConnectionInterceptor> interceptors) {
        DatabaseErrorHandler eh;
        if (e == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(18);
        }
        if (interceptors == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(19);
        }
        if ((eh = DatabaseErrorHandler.EP.forDbms(this.getDataSource().getDbms())).isPasswordExpired(e)) {
            return this.handlePasswordExpired(e);
        }
        while (interceptors.hasNext()) {
            DatabaseConnectionInterceptor interceptor = interceptors.next();
            CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handler = interceptor.handleConnectionFailure(this.myProto, e, this.mySilent, this.myAttemptNo);
            CompletableFuture<DatabaseConnectionInterceptor.ProtoConnection> future = handler == null ? null : handler.toCompletableFuture();
            if (future == null || future.isDone() && future.getNow(null) == null) continue;
            AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.currentFrame().wrap(handler).applyAsync(null, proto -> proto == null ? this.handleConnectionFailure(e, interceptors) : AsyncTask.completed(proto));
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(20);
            }
            return asyncTask;
        }
        String title = "Connecting to: " + this.myProto.getUrl();
        Throwable ex = AsyncUtil.unwrap(e);
        String message2 = JdbcUtil.getLongMessage((Throwable)ObjectUtils.notNull((Object)ex, (Object)e));
        LOG.warn(title);
        LOG.warn(message2);
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.exceptional(e);
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(21);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> handlePasswordExpired(@NotNull SQLException e) {
        Properties properties;
        block8: {
            AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask;
            if (e == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(22);
            }
            properties = new Properties();
            properties.putAll(this.myProto.connectionProperties);
            try {
                if (this.myDriver.canChangePassword(this.myProto.url, properties)) break block8;
                asyncTask = AsyncTask.exceptional(e);
            }
            catch (RemoteException re) {
                AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask2 = AsyncTask.exceptional(e);
                if (asyncTask2 == null) {
                    DatabaseConnectionEstablisher.$$$reportNull$$$0(24);
                }
                return asyncTask2;
            }
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(23);
            }
            return asyncTask;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.exceptional(new RuntimeException("Expired password change disabled in unit test", e));
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(25);
            }
            return asyncTask;
        }
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.Frame.create(DatabaseBundle.message("progress.title.change.password", new Object[0])).computeAsync(DatabaseCredentialsUi.EXECUTOR, () -> {
            String newPass = this.askChangePassword();
            return AsyncTask.currentFrame().compute(AsyncUtil.getNonEdtExecutor(), () -> {
                this.myDriver.changeExpiredPassword(this.myProto.url, properties, this.myProto.extraProperties, newPass);
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(this.myProto.connectionPoint.getDataSource().getName(), DatabaseBundle.message("notification.content.password.changed", new Object[0]), NotificationType.INFORMATION).notify(this.getProject());
                DatabaseAuthProvider provider = DatabaseAuthProvider.get(this.myProto.connectionPoint.getDataSource());
                provider.setNewPassword(this.myProto, newPass);
                this.myProto.credentials.setPassword(this.myProto.connectionPoint.getDataSource(), new OneTimeString(newPass));
                return this.myProto;
            });
        });
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(26);
        }
        return asyncTask;
    }

    @NotNull
    private String askChangePassword() {
        final FormBuilder form = FormBuilder.createFormBuilder();
        form.addComponent((JComponent)new JBLabel(DatabaseBundle.message("password.expired.message", new Object[0])));
        form.addVerticalGap(12);
        final JBPasswordField p1 = new JBPasswordField();
        p1.setColumns(15);
        form.addLabeledComponent(DatabaseBundle.message("password.expired.new.password", new Object[0]), (JComponent)p1);
        final JBPasswordField p2 = new JBPasswordField();
        p2.setColumns(15);
        form.addLabeledComponent(DatabaseBundle.message("password.expired.confirm.password", new Object[0]), (JComponent)p2);
        form.addComponentFillVertically((JComponent)new JPanel(), 0);
        boolean res2 = new DialogWrapper(this.getProject()){
            {
                super(arg0);
                this.setTitle(DatabaseBundle.message("password.expired.title", new Object[0]));
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return form.getPanel();
            }

            protected boolean postponeValidation() {
                return false;
            }

            @Nullable
            protected ValidationInfo doValidate() {
                return Arrays.equals(p1.getPassword(), p2.getPassword()) ? super.doValidate() : new ValidationInfo(DatabaseBundle.message("password.expired.do.not.match", new Object[0]), (JComponent)p2);
            }
        }.showAndGet();
        if (!res2) {
            throw new ProcessCanceledException();
        }
        return new String(p1.getPassword());
    }

    @NotNull
    private ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = this.myProto.getRunConfiguration();
        if (consoleRunConfiguration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(27);
        }
        return consoleRunConfiguration;
    }

    @NotNull
    private Project getProject() {
        Project project = this.getConfiguration().getProject();
        if (project == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(28);
        }
        return project;
    }

    @NotNull
    private LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myProto.getConnectionPoint().getDataSource();
        if (localDataSource == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(29);
        }
        return localDataSource;
    }

    @NotNull
    private AsyncTask<DatabaseConnection> processNullConnection() {
        if (this.myAttemptNo == 0 && this.getDataSource().getDbms().isPostgres()) {
            this.myProto.setUrl(this.myProto.getUrl() + "/");
            AsyncTask<DatabaseConnection> asyncTask = this.tryReconnect();
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(30);
            }
            return asyncTask;
        }
        LOG.warn("Null connection returned for: " + this.myProto.getUrl());
        AsyncTask<Object> asyncTask = AsyncTask.completed(null);
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(31);
        }
        return asyncTask;
    }

    @Nullable
    private DatabaseConnection connect() throws SQLException {
        LOG.info("Connecting to: " + this.myProto.getUrl());
        RemoteConnection remoteConnection = null;
        try {
            Properties properties = new Properties();
            for (Map.Entry<String, String> e : this.myProto.getConnectionProperties().entrySet()) {
                if (e.getValue() == null) continue;
                properties.put(e.getKey(), e.getValue());
            }
            remoteConnection = this.myDriver.connect(this.myProto.getUrl(), properties, this.myProto.getExtraProperties());
        }
        catch (UnmarshalException e) {
            LOG.warn(e.getMessage());
        }
        catch (ServerError r) {
            Throwable cause = (Throwable)ObjectUtils.notNull((Object)r.getCause(), (Object)r);
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            ExceptionUtil.rethrow((Throwable)cause);
        }
        catch (RemoteException r) {
            ExceptionUtil.rethrow((Throwable)r);
        }
        if (remoteConnection != null) {
            this.prepareConnection(remoteConnection);
        }
        if (remoteConnection == null) {
            return null;
        }
        SimpleDatabaseConnection databaseConnection = new SimpleDatabaseConnection(this.myProto.getConnectionPoint(), remoteConnection, this.getConfiguration(), this.myRequestor, this.getProject());
        this.maybeRunKeepAliveQuery(databaseConnection);
        return databaseConnection;
    }

    private void maybeRunKeepAliveQuery(@NotNull DatabaseConnection databaseConnection) throws SQLException {
        if (databaseConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(32);
        }
        try {
            RemoteConnection remoteConnection = databaseConnection.getRemoteConnection();
            if (remoteConnection.isLazy()) {
                String query = KeepAliveActionDescriptor.getKeepAliveQuery(this.getProject(), this.getDataSource());
                SmartStatements.poweredBy(databaseConnection).simple().noisy().execute(query, StandardExecutionMode.GENERIC).close();
            }
        }
        catch (RemoteException e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void prepareConnection(@NotNull RemoteConnection remoteConnection) {
        if (remoteConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(33);
        }
        Dbms dbms = this.getDataSource().getDbms();
        if (this.myProto.getConnectionPoint().isReadOnly() && DbImplUtil.supportsReadOnlyChangeOnTheFly(dbms)) {
            DbImplUtil.tryToSetReadOnly(remoteConnection, true, dbms);
        }
        if (DatabaseDriver.OPTION_SEND_APP_INFO.get(this.myProto.getConnectionPoint().getDatabaseDriver()).booleanValue() && StringUtil.isEmpty((String)DatabaseConnectionEstablisher.getClientInfo(remoteConnection))) {
            DatabaseConnectionEstablisher.setClientInfo(remoteConnection, DatabaseConnectionEstablisher.getApplicationName());
        }
    }

    private static void setClientInfo(@NotNull RemoteConnection remoteConnection, String name) {
        if (remoteConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(34);
        }
        try {
            remoteConnection.setClientInfo("ApplicationName", name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    private static String getApplicationName() {
        String name;
        Application app = ApplicationManager.getApplication();
        String string = name = app == null || app.isUnitTestMode() ? null : ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (name == null) {
            name = "DG Tests";
        }
        String string2 = name;
        if (string2 == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @Nullable
    private static String getClientInfo(@NotNull RemoteConnection remoteConnection) {
        if (remoteConnection == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(36);
        }
        try {
            return remoteConnection.getClientInfo("ApplicationName");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private AsyncTask<DatabaseConnection> tryReconnect() {
        ++this.myAttemptNo;
        this.myStopProcessRef.set(false);
        ProgressManager.checkCanceled();
        return this.tryConnect();
    }

    @NotNull
    public static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> processInterceptors(@NotNull ConsoleRunConfiguration configuration, @NotNull DatabaseConnectionPoint connectionPoint, boolean silent, boolean auth) {
        if (configuration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(37);
        }
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(38);
        }
        DatabaseConnectionInterceptor.ProtoConnection proto = DatabaseConnectionEstablisher.createProtoConnection(configuration, connectionPoint);
        List<DatabaseConnectionInterceptor> interceptors = DatabaseConnectionEstablisher.getInterceptors(proto, auth);
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.preprocess.connection", new Object[0])).computeAsync(null, () -> DatabaseConnectionEstablisher.processInterceptor(proto, interceptors.iterator(), silent));
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(39);
        }
        return asyncTask;
    }

    @NotNull
    protected static List<DatabaseConnectionInterceptor> getInterceptors(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean auth) {
        if (proto == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(40);
        }
        List list = ContainerUtil.filter((Collection)DatabaseConnectionInterceptor.EP_NAME.getExtensionList(), e -> !(e instanceof DatabaseAuthProvider) || auth && ((DatabaseAuthProvider)e).getId().equals(proto.getConnectionPoint().getDataSource().getAuthProviderId()));
        if (list == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public static DatabaseConnectionInterceptor.ProtoConnection createProtoConnection(@NotNull ConsoleRunConfiguration configuration, @NotNull DatabaseConnectionPoint connectionPoint) {
        if (configuration == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(42);
        }
        if (connectionPoint == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(43);
        }
        return new ProtoConnectionImpl(configuration, connectionPoint);
    }

    @NotNull
    private static AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> processInterceptor(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull Iterator<DatabaseConnectionInterceptor> interceptors, boolean silent) {
        List<DatabaseConnectionInterceptor> active;
        if (proto == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(44);
        }
        if (interceptors == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(45);
        }
        List<DatabaseConnectionInterceptor> list = active = proto instanceof ProtoConnectionImpl ? ((ProtoConnectionImpl)proto).activeInterceptors : null;
        while (interceptors.hasNext()) {
            DatabaseConnectionInterceptor interceptor = interceptors.next();
            if (interceptor instanceof DatabaseAuthProvider && !((DatabaseAuthProvider)interceptor).isApplicable(proto.getConnectionPoint().getDataSource())) {
                AsyncTask.exceptional(new RuntimeException("Authentication `" + ((DatabaseAuthProvider)interceptor).getDisplayName() + "` is not applicable"));
                continue;
            }
            CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> intercepted = interceptor.intercept(proto, silent);
            if (intercepted == null) continue;
            if (active != null) {
                active.add(interceptor);
            }
            if (intercepted.toCompletableFuture().isDone()) continue;
            AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.Frame.currentOrAnonymous().wrap(intercepted).applyAsync(null, p2 -> DatabaseConnectionEstablisher.processInterceptor(proto, interceptors, silent));
            if (asyncTask == null) {
                DatabaseConnectionEstablisher.$$$reportNull$$$0(46);
            }
            return asyncTask;
        }
        AsyncTask<DatabaseConnectionInterceptor.ProtoConnection> asyncTask = AsyncTask.completed(proto);
        if (asyncTask == null) {
            DatabaseConnectionEstablisher.$$$reportNull$$$0(47);
        }
        return asyncTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDriver";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 10: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 15: 
            case 19: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interceptors";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseConnection";
                break;
            }
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteConnection";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "tryConnect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processConnectionFailure";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processConnected";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "handleConnected";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "handleConnectionFailure";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "handlePasswordExpired";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "processNullConnection";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "processInterceptors";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterceptors";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "processInterceptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "establishConnection";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processConnectionFailure";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConnected";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handlePasswordExpired";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "maybeRunKeepAliveQuery";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setClientInfo";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getClientInfo";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processInterceptors";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getInterceptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createProtoConnection";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processInterceptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ProtoConnectionImpl
    implements DatabaseConnectionInterceptor.ProtoConnection {
        final ConsoleRunConfiguration runConfiguration;
        final DatabaseConnectionPoint connectionPoint;
        final DatabaseCredentials credentials;
        String url;
        final Map<String, String> connectionProperties = new LinkedHashMap<String, String>();
        final Map<String, Serializable> extraProperties = new LinkedHashMap<String, Serializable>();
        final List<DatabaseConnectionInterceptor> activeInterceptors = new ArrayList<DatabaseConnectionInterceptor>(5);

        private ProtoConnectionImpl(ConsoleRunConfiguration runConfiguration, DatabaseConnectionPoint connectionPoint) {
            this.runConfiguration = runConfiguration;
            this.connectionPoint = connectionPoint;
            this.url = StringUtil.notNullize((String)connectionPoint.getUrl());
            for (Map.Entry<Object, Object> entry : connectionPoint.getConnectionProperties().entrySet()) {
                this.connectionProperties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            this.credentials = DatabaseCredentialsUi.newOneTimeInstance(runConfiguration.CREDENTIALS);
        }

        @Override
        @NotNull
        public ConsoleRunConfiguration getRunConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration = this.runConfiguration;
            if (consoleRunConfiguration == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(0);
            }
            return consoleRunConfiguration;
        }

        @Override
        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            DatabaseConnectionPoint databaseConnectionPoint = this.connectionPoint;
            if (databaseConnectionPoint == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(1);
            }
            return databaseConnectionPoint;
        }

        @Override
        @NotNull
        public String getUrl() {
            String string = this.url;
            if (string == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void setUrl(@NotNull String url) {
            if (url == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(3);
            }
            this.url = url;
        }

        @Override
        @NotNull
        public Map<String, String> getConnectionProperties() {
            Map<String, String> map2 = this.connectionProperties;
            if (map2 == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(4);
            }
            return map2;
        }

        @Override
        @NotNull
        public Map<String, Serializable> getExtraProperties() {
            Map<String, Serializable> map2 = this.extraProperties;
            if (map2 == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(5);
            }
            return map2;
        }

        @Override
        @NotNull
        public DatabaseCredentials getCredentials() {
            DatabaseCredentials databaseCredentials = this.credentials;
            if (databaseCredentials == null) {
                ProtoConnectionImpl.$$$reportNull$$$0(6);
            }
            return databaseCredentials;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher$ProtoConnectionImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionPoint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionEstablisher$ProtoConnectionImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionProperties";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraProperties";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCredentials";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

