/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGridSortingModel<Row, Column>
implements GridSortingModel<Row, Column> {
    private final List<String> myHistory;
    private boolean mySortingEnabled;
    protected List<RowSortOrder<ModelIndex<Column>>> myAppliedOrdering = ContainerUtil.emptyList();
    protected List<RowSortOrder<ModelIndex<Column>>> myOrdering = ContainerUtil.emptyList();
    protected final EventDispatcher<GridSortingModel.Listener> myEventDispatcher = EventDispatcher.create(GridSortingModel.Listener.class);

    public AbstractGridSortingModel() {
        this.myHistory = new ArrayList<String>();
    }

    @Override
    public boolean isSortingEnabled() {
        return this.mySortingEnabled;
    }

    @Override
    public void setSortingEnabled(boolean enabled) {
        this.mySortingEnabled = enabled;
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    @Override
    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<Column>>> ordering) {
        if (ordering == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(0);
        }
        this.myOrdering = new ArrayList<RowSortOrder<ModelIndex<Column>>>(ordering);
    }

    @Override
    @NotNull
    public List<RowSortOrder<ModelIndex<Column>>> getAppliedOrdering() {
        return this.isSortingEnabled() ? new ArrayList<RowSortOrder<ModelIndex<Column>>>(this.myAppliedOrdering) : new SmartList();
    }

    @Override
    public void apply() {
        this.myAppliedOrdering = new ArrayList<RowSortOrder<ModelIndex<Column>>>(this.myOrdering);
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    protected void addToHistory(@NotNull String text2) {
        if (text2 == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(1);
        }
        this.myHistory.remove(text2);
        this.myHistory.add(0, text2);
        this.trimHistory();
    }

    @Override
    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(2);
        }
        this.myHistory.clear();
        this.myHistory.addAll(history);
    }

    private void trimHistory() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        int historySize = Math.max(0, settings.getFiltersHistorySize());
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    @Override
    @Nullable
    public Document getDocument() {
        return null;
    }

    @Override
    @NotNull
    public List<String> getHistory() {
        List<String> list = this.myHistory;
        if (list == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void addListener(@NotNull GridSortingModel.Listener l, @NotNull Disposable disposable2) {
        if (l == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(4);
        }
        if (disposable2 == null) {
            AbstractGridSortingModel.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable2);
    }

    void firePSIUpdated() {
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).onPsiUpdated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/AbstractGridSortingModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/AbstractGridSortingModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setOrdering";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHistory";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

