/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BridgeDataBus
implements DataBus.Consuming,
DataBus.Producing {
    private final List<DataConsumer> myConsumers;
    private final List<DataAuditor> myAuditors;
    private final List<DataProducer> myProducers;
    private volatile DataRequest.Owner myBusParent;
    private volatile DataBus.Consuming myDelegate;
    private volatile Disposable myParent;

    public BridgeDataBus(@NotNull DataRequest.Owner parent2, @NotNull DataBus.Consuming delegate) {
        if (parent2 == null) {
            BridgeDataBus.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            BridgeDataBus.$$$reportNull$$$0(1);
        }
        this.myBusParent = parent2;
        this.myConsumers = new ArrayList<DataConsumer>();
        this.myAuditors = new ArrayList<DataAuditor>();
        this.myProducers = new ArrayList<DataProducer>();
        this.myDelegate = delegate;
    }

    @NotNull
    public DataRequest.Owner getOwner() {
        DataRequest.Owner owner = this.myBusParent;
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(2);
        }
        return owner;
    }

    @Override
    public DataBus.Consuming filterFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(3);
        }
        return new BridgeDataBus(this.myBusParent, this.myDelegate.filterFor(owner));
    }

    @Override
    public DataProducer getDataProducer() {
        return this.myDelegate.getDataProducer();
    }

    @Override
    public void addConsumer(@NotNull DataConsumer dataConsumer) {
        if (dataConsumer == null) {
            BridgeDataBus.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.initParent();
        if (dataConsumer instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)dataConsumer), () -> this.myConsumers.remove(dataConsumer));
        }
        this.myConsumers.add(dataConsumer);
        this.myDelegate.addConsumer(new LimitedLifetimeConsumer(dataConsumer, this.myParent));
    }

    @Override
    public void addAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            BridgeDataBus.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.initParent();
        this.myAuditors.add(dataAuditor);
        if (dataAuditor instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)dataAuditor), () -> this.myAuditors.remove(dataAuditor));
        }
        this.myDelegate.addAuditor(new LimitedLifetimeAuditor(dataAuditor, this.myParent));
    }

    public void setDataBus(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(6);
        }
        this.setDataBus(bus, true);
    }

    public void setOwner(@NotNull DataRequest.Owner owner, @NotNull DataBus.Consuming bus) {
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(7);
        }
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(8);
        }
        this.myBusParent = owner;
        this.setDataBus(bus, false);
    }

    public void setDataBus(@NotNull DataBus.Consuming bus, boolean filter2) {
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myParent != null) {
            Disposer.dispose((Disposable)this.myParent);
        }
        this.myParent = null;
        this.initParent();
        this.myDelegate = filter2 ? bus.filterFor(this.myBusParent) : bus;
        for (DataConsumer consumer2 : this.myConsumers) {
            this.myDelegate.addConsumer(new LimitedLifetimeConsumer(consumer2, this.myParent));
        }
        for (DataAuditor auditor : this.myAuditors) {
            this.myDelegate.addAuditor(new LimitedLifetimeAuditor(auditor, this.myParent));
        }
        for (DataProducer producer : this.myProducers) {
            this.producing().addProducer(producer);
        }
    }

    private void initParent() {
        if (this.myParent != null) {
            return;
        }
        this.myParent = Disposer.newDisposable();
        Disposer.register((Disposable)this.myBusParent, (Disposable)this.myParent);
    }

    @Override
    public DataConsumer getDataConsumer() {
        return this.producing().getDataConsumer();
    }

    @Override
    public DataAuditor getDataAuditor() {
        return this.producing().getDataAuditor();
    }

    @Override
    public void addProducer(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myProducers.add(dataProducer);
        this.producing().addProducer(dataProducer);
    }

    @Override
    public void beforeProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(11);
        }
        this.producing().beforeProducerRemove(dataProducer);
    }

    @Override
    public void afterProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(12);
        }
        this.producing().afterProducerRemove(dataProducer);
    }

    @NotNull
    private DataBus.Producing producing() {
        DataBus.Producing producing = DataBus.shortCircuit(this.myDelegate);
        if (producing == null) {
            BridgeDataBus.$$$reportNull$$$0(13);
        }
        return producing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "producing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addConsumer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAuditor";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDataBus";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOwner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProducer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeProducerRemove";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "afterProducerRemove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LimitedLifetimeAuditor
    extends DataAuditor.Wrapper
    implements SimpleRequestBroker.LimitedLifetimeListener<DataAuditor> {
        private final Disposable myParent;

        LimitedLifetimeAuditor(@NotNull DataAuditor delegate, @NotNull Disposable parent2) {
            if (delegate == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myParent = parent2;
        }

        @Override
        @NotNull
        public Disposable getDisposable() {
            Disposable disposable2 = this.myParent;
            if (disposable2 == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(2);
            }
            return disposable2;
        }

        @Override
        @NotNull
        public DataAuditor getDelegate() {
            DataAuditor dataAuditor = this.delegate;
            if (dataAuditor == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(3);
            }
            return dataAuditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeAuditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeAuditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LimitedLifetimeConsumer
    extends DataConsumer.Wrapper
    implements SimpleRequestBroker.LimitedLifetimeListener<DataConsumer> {
        private final Disposable myParent;

        LimitedLifetimeConsumer(@NotNull DataConsumer delegate, @NotNull Disposable parent2) {
            if (delegate == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myParent = parent2;
        }

        @Override
        @NotNull
        public Disposable getDisposable() {
            Disposable disposable2 = this.myParent;
            if (disposable2 == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(2);
            }
            return disposable2;
        }

        @Override
        @NotNull
        public DataConsumer getDelegate() {
            DataConsumer dataConsumer = this.delegate;
            if (dataConsumer == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(3);
            }
            return dataConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeConsumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

