/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.view.editors.DatabaseColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingColumnEditor<T extends ColumnDescriptor>
extends DatabaseColumnEditor {
    private final List<T> myDescriptors;
    private T myDescriptor;
    private TextFieldWithAutoCompletion<T> myField;
    private JBLabel myLabel;
    private JPanel myCustomPanel;

    public MappingColumnEditor(@NotNull ImportEditorState<T> state, @NotNull ColumnEditorModel model, @NotNull DatabaseEditorCapabilities.ColumnEditorCaps caps) {
        if (state == null) {
            MappingColumnEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            MappingColumnEditor.$$$reportNull$$$0(1);
        }
        if (caps == null) {
            MappingColumnEditor.$$$reportNull$$$0(2);
        }
        super(state, model, caps);
        this.myDescriptors = state.getDescriptors();
        this.setCustomComponent(this.myCustomPanel, MappingColumnEditor.createConstraints());
        this.myCustomPanel.add((Component)this.myLabel, "North");
        this.myCustomPanel.add((Component)this.myField, "South");
    }

    @Override
    protected void createUIComponents() {
        super.createUIComponents();
        this.myLabel = new JBLabel(DatabaseBundle.message("label.mapped.to", new Object[0]));
        this.myField = new TextFieldWithAutoCompletion(this.getProject(), new MyCompletionProvider(((ImportEditorState)this.getState()).getDescriptors()), true, null);
        this.myField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MappingColumnEditor.this.myDescriptor = (ColumnDescriptor)ContainerUtil.find(MappingColumnEditor.this.myDescriptors, descriptor2 -> StringUtil.equals((CharSequence)descriptor2.getName(), (CharSequence)MappingColumnEditor.this.myField.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dbimport/ui/MappingColumnEditor$1", "documentChanged"));
            }
        });
        this.myCustomPanel = new JPanel(new BorderLayout());
    }

    @Override
    public ImportEditorState<T> getState() {
        return (ImportEditorState)super.getState();
    }

    @Override
    @NotNull
    protected JComponent[] getEditorFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])super.getEditorFocusableComponents(), (Object[])((JComponent[])ContainerUtil.ar((Object[])new JComponent[]{this.myField.getFocusTarget()})));
        if (jComponentArray == null) {
            MappingColumnEditor.$$$reportNull$$$0(3);
        }
        return jComponentArray;
    }

    public void setDescriptor(@Nullable T descriptor2) {
        this.myDescriptor = descriptor2;
        this.myField.setText(descriptor2 == null ? "" : descriptor2.getName());
    }

    @Nullable
    public T getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    private static GridConstraints createConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setVSizePolicy(2);
        constraints.setHSizePolicy(4);
        constraints.setFill(3);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            MappingColumnEditor.$$$reportNull$$$0(4);
        }
        return gridConstraints;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/MappingColumnEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/MappingColumnEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFocusableComponents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCompletionProvider<T extends ColumnDescriptor>
    extends TextFieldWithAutoCompletionListProvider<T> {
        protected MyCompletionProvider(@Nullable Collection<T> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull T item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            String string = item.getName();
            if (string == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        protected Icon getIcon(@NotNull T item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(2);
            }
            return DatabaseIcons.Col;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ui/MappingColumnEditor$MyCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ui/MappingColumnEditor$MyCompletionProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

