/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.DbDiagramProvider;
import com.intellij.database.diagram.DbEdge;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.utils.UmlUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.Shape;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class DbDiagramDataModel
extends DiagramDataModel<DbElement>
implements DiagramDataModel.AsyncDataLoader {
    private final Object underlyingElementsLock = new Object();
    private final Set<DbElement> myTableSetsAddedByUser = new HashSet<DbElement>();
    private final Map<String, DbTable> myTablesAddedByUser = new HashMap<String, DbTable>();
    private final Set<DbTable> myTablesRemovedByUser = new HashSet<DbTable>();
    private final Object nodesAndEdgesLock = new Object();
    private Collection<DbDiagramNode> myNodes = new HashSet<DbDiagramNode>();
    private Collection<DbEdge> myEdges = new HashSet<DbEdge>();
    private final AtomicReference<ProgressIndicator> modelBuildingProgress = new AtomicReference();

    public DbDiagramDataModel(Project project, final DbElement element2, DiagramProvider<DbElement> provider) {
        super(project, provider);
        this.addElementInner(element2);
        project.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener(){
            @NotNull
            final String currentDataSourceId;
            {
                this.currentDataSourceId = element2.getDataSource().getUniqueId();
            }

            @Override
            public void onChanged(@Nullable DbDataSource dataSource2) {
                if (dataSource2 == null || dataSource2.getUniqueId().equals(this.currentDataSourceId)) {
                    UmlUtils.refreshDataModelInSmartMode((DiagramBuilder)DbDiagramDataModel.this.getBuilder());
                }
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(DatabaseColorManager.COLOR_CHANGE_TOPIC, () -> this.getBuilder().getPresentationModel().update());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DbDiagramNode> getNodes() {
        Object object = this.nodesAndEdgesLock;
        // MONITORENTER : object
        Collection<DbDiagramNode> collection = this.myNodes;
        // MONITOREXIT : object
        if (collection != null) return collection;
        DbDiagramDataModel.$$$reportNull$$$0(0);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<DbEdge> getEdges() {
        Object object = this.nodesAndEdgesLock;
        // MONITORENTER : object
        Collection<DbEdge> collection = this.myEdges;
        // MONITOREXIT : object
        if (collection != null) return collection;
        DbDiagramDataModel.$$$reportNull$$$0(1);
        return collection;
    }

    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<DbElement> node) {
        if (node == null) {
            DbDiagramDataModel.$$$reportNull$$$0(2);
        }
        DbElement element2 = (DbElement)node.getIdentifyingElement();
        String string = String.format("%s %s", element2.getTypeName(), element2.getName());
        if (string == null) {
            DbDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(@NotNull DiagramNode<DbElement> node) {
        if (node == null) {
            DbDiagramDataModel.$$$reportNull$$$0(4);
        }
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            this.removeElement((DbElement)node.getIdentifyingElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramNode<DbElement> addElement(@Nullable DbElement element2) {
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            this.addElementInner(element2);
            if (element2 instanceof DbTable) {
                DbTable table = (DbTable)element2;
                this.myTablesRemovedByUser.remove(table);
                return this.createDbNode(table);
            }
            return null;
        }
    }

    private DbDiagramNode createDbNode(DbTable table) {
        return new DbDiagramNode(table, (DiagramProvider<DbElement>)this.getProvider());
    }

    private void addElementInner(@Nullable DbElement element2) {
        if (element2 instanceof DbTable) {
            this.myTablesAddedByUser.put(element2.getName(), (DbTable)element2);
        } else if (element2 != null) {
            this.myTableSetsAddedByUser.add(element2);
        }
    }

    @NotNull
    private JBIterable<DbDataSource> getDataSources() {
        JBIterable jBIterable = JBIterable.from(this.myTableSetsAddedByUser).append(this.myTablesAddedByUser.values()).map(DbElement::getDataSource).unique();
        if (jBIterable == null) {
            DbDiagramDataModel.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshDataModel() {
        HashMap<DbTable, DbDiagramNode> elementToNodeMap = this.calculateElementToNodeMap();
        Collection<DbEdge> edges = this.calculateEdges(elementToNodeMap);
        Object object = this.nodesAndEdgesLock;
        synchronized (object) {
            this.myNodes = new HashSet(elementToNodeMap.values());
            this.myEdges = edges;
        }
    }

    @NotNull
    public Promise<?> refreshDataModelAsync() {
        final AsyncPromise result2 = new AsyncPromise();
        new Task.Backgroundable(this.getProject(), DatabaseBundle.message("progress.title.building.diagram", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!DbDiagramDataModel.this.modelBuildingProgress.compareAndSet(null, indicator)) {
                    return;
                }
                try {
                    DbDiagramDataModel.this.refreshDataModel();
                    result2.setResult(null);
                }
                catch (ProcessCanceledException e) {
                    result2.setError((Throwable)e);
                }
                finally {
                    DbDiagramDataModel.this.modelBuildingProgress.set(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diagram/DbDiagramDataModel$2", "run"));
            }
        }.queue();
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            DbDiagramDataModel.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(this.getProject());
        if (dbPsiFacade == null) {
            DbDiagramDataModel.$$$reportNull$$$0(7);
        }
        return dbPsiFacade;
    }

    private boolean isAllowedToShow(DbTable tableElement) {
        if (tableElement == null || !tableElement.isValid()) {
            return false;
        }
        return !this.myTablesRemovedByUser.contains(tableElement);
    }

    @NotNull
    private HashMap<DbTable, DbDiagramNode> calculateElementToNodeMap() {
        Set<DbTable> tables = this.getAllTables();
        HashMap<DbTable, DbDiagramNode> result2 = new HashMap<DbTable, DbDiagramNode>();
        for (DbTable tableElement : tables) {
            if (!this.isAllowedToShow(tableElement)) continue;
            DbDiagramNode node = this.createDbNode(tableElement);
            result2.put(tableElement, node);
        }
        HashMap<DbTable, DbDiagramNode> hashMap = result2;
        if (hashMap == null) {
            DbDiagramDataModel.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private Collection<DbEdge> calculateEdges(Map<DbTable, DbDiagramNode> elementToNodeMap) {
        ArrayList<DbEdge> result2 = new ArrayList<DbEdge>();
        boolean virtualFk = Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(DbDiagramProvider.VIRTUAL_FOREIGN_KEYS);
        for (DbDiagramNode node : elementToNodeMap.values()) {
            DbTable table = node.getIdentifyingElement();
            HashSet<String> uniqueLabels = new HashSet<String>();
            Iterator iterator = (virtualFk ? ModelRelationManager.getForeignKeys(this.getProject(), table) : DasUtil.getForeignKeys(table)).iterator();
            while (iterator.hasNext()) {
                String label;
                DasForeignKey key = (DasForeignKey)iterator.next();
                String name = key.getName();
                DbDiagramNode target = elementToNodeMap.get(this.asDbElement(key.getRefTable()));
                if (target == null || !uniqueLabels.add(label = DbDiagramDataModel.getFkRelationshipLabel(key))) continue;
                result2.add(DbDiagramDataModel.createEdge(node, name, target, label));
            }
        }
        return result2;
    }

    @NotNull
    private static DbEdge createEdge(DbDiagramNode from, String name, DbDiagramNode to, String label) {
        DiagramRelationshipInfoAdapter relationship = new DiagramRelationshipInfoAdapter("REFERENCES", DiagramLineType.SOLID, label){

            public Shape getStartArrow() {
                return DELTA;
            }
        };
        return new DbEdge((DiagramNode<DbElement>)from, (DiagramNode<DbElement>)to, StringUtil.notNullize((String)name), (DiagramRelationshipInfo)relationship);
    }

    @NotNull
    private static String getFkRelationshipLabel(DasForeignKey key) {
        String refColumnsLabel;
        String columnsRefLabel = StringUtil.join(key.getColumnsRef().names(), (String)", ");
        Object object = columnsRefLabel.equals(refColumnsLabel = StringUtil.join(key.getRefColumns().names(), (String)", ")) ? columnsRefLabel : columnsRefLabel + ":" + refColumnsLabel;
        if (object == null) {
            DbDiagramDataModel.$$$reportNull$$$0(9);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DbTable> getAllTables() {
        HashSet<DbTable> removedCopy;
        HashSet<DbElement> tableSetsCopy;
        ArrayDeque<DbTable> queue;
        Object object = this.underlyingElementsLock;
        synchronized (object) {
            queue = new ArrayDeque<DbTable>(this.myTablesAddedByUser.values());
            tableSetsCopy = new HashSet<DbElement>(this.myTableSetsAddedByUser);
            removedCopy = new HashSet<DbTable>(this.myTablesRemovedByUser);
        }
        HashSet<DbTable> tables = new HashSet<DbTable>();
        for (DbElement o : tableSetsCopy) {
            if (!o.isValid()) continue;
            for (DbTable object2 : ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects(o.getDataSource()).withRoot((Object)o)).traverse().filter(DbTable.class)) {
                if (!DbDiagramElementManager.isAcceptedAsNodeImpl(object2)) continue;
                this.addTableAndReferences(tables, queue, object2);
            }
        }
        while (!queue.isEmpty()) {
            this.addTableAndReferences(tables, queue, (DbTable)queue.remove());
        }
        tables.remove(null);
        tables.removeAll(removedCopy);
        tables.removeIf(t -> !t.isValid());
        return tables;
    }

    private void addTableAndReferences(Set<DbTable> tables, Queue<DbTable> list, DbTable table) {
        if (!tables.add(table)) {
            return;
        }
        if (!table.isValid()) {
            return;
        }
        for (DasForeignKey info : ModelRelationManager.getForeignKeys(this.getProject(), table)) {
            DbTable targetTable = this.asDbElement(info.getRefTable());
            if (targetTable == null || tables.contains(targetTable)) continue;
            list.add(targetTable);
        }
    }

    @Nullable
    private DbTable asDbElement(@Nullable DasTable obj) {
        if (obj == null) {
            return null;
        }
        DbTable element2 = (DbTable)ObjectUtils.tryCast((Object)obj, DbTable.class);
        if (element2 != null) {
            return element2;
        }
        return (DbTable)this.getDataSources().filterMap(ds -> (DbTable)ObjectUtils.tryCast((Object)DbImplUtilCore.findElement(ds, obj), DbTable.class)).first();
    }

    public void dispose() {
    }

    private void removeElement(DbElement element2) {
        if (element2 instanceof DbTable) {
            this.myTablesRemovedByUser.add((DbTable)element2);
            this.myTablesAddedByUser.remove(element2.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramDataModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateElementToNodeMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFkRelationshipLabel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

