/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseOutdatedCheckBuffer;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.editor.ExecuteRoutineFromFileAction;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelLightCopierUtils;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.actions.DebugRoutineAction;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseEditorHelper
extends DatabaseEditorHelperCore {
    private static final Logger LOG = Logger.getInstance(DatabaseEditorHelper.class);
    @NlsSafe
    private static final String DDL_EDITOR_DISPLAY_NAME = "DDL";
    private static final Key<Object> DB_EDITOR_LISTENER_INSTALLED = Key.create((String)"DB_EDITOR_LISTENER_INSTALLED");
    private static final Key<Boolean> FILE_CONTENT_LOADED = Key.create((String)"DBE_CONTENT_LOADED");

    public static void installEditorFactoryListener(final @NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(0);
        }
        if (project.getUserData(DB_EDITOR_LISTENER_INSTALLED) != null) {
            return;
        }
        project.putUserData(DB_EDITOR_LISTENER_INSTALLED, (Object)Boolean.TRUE);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerListener listener2 = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DbImplUtil.isDatabaseVirtualFile(file)) {
                    DatabaseEditorHelper.configureToolbar(file, source);
                    DatabaseEditorHelper.setDdlEditorsDisplayName(file, source);
                    if (!DatabaseEditorHelper.isDataFile(file)) {
                        DatabaseEditorHelper.scheduleOutdatedCheck(project, file);
                    }
                } else {
                    DatabaseEditorHelper.restoreAttachedConsole(source.getProject(), file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                DatabaseElementVirtualFileImpl vf;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((vf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)event.getNewFile(), DatabaseElementVirtualFileImpl.class))) != null && vf.isSource() && !vf.isModifiedByUser() && DatabaseEditorHelper.needsRefresh(vf, project)) {
                    DatabaseEditorHelper.scheduleReload(project, vf);
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (source.isFileOpen(file)) {
                    return;
                }
                JdbcConsole console = JdbcConsoleProvider.getConsole(source.getProject(), file);
                if (console != null) {
                    console.detached(DatabaseSessionClient.DetachTrigger.FILE_CLOSED);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project.getMessageBus().connect().subscribe(DbPsiFacade.TOPIC, ds -> {
            for (VirtualFile file : fileEditorManager.getSelectedFiles()) {
                DatabaseElementVirtualFileImpl vf = (DatabaseElementVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class)));
                if (vf == null || !vf.isSource() || vf.isModifiedByUser() || !DatabaseEditorHelper.needsRefresh(vf, project)) continue;
                DatabaseEditorHelper.scheduleReload(project, vf);
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                JdbcConsole console;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                JdbcConsole jdbcConsole = console = file == null ? null : JdbcConsoleProvider.getConsole(project, file);
                if (console != null) {
                    console.getProgressHelper().applyState(editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/editor/DatabaseEditorHelper$2", "editorCreated"));
            }
        }, (Disposable)project);
        MessageBusConnection connection2 = project.getMessageBus().connect();
        connection2.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection2.subscribe(DatabaseSessionManager.getTopic(), (Object)new DatabaseSessionManagerListener(){
            private boolean myShowToolbar;
            {
                this.myShowToolbar = DatabaseEditorHelper.showConsoleToolbar(project);
            }

            @Override
            public void sessionOpened(@NotNull DatabaseSession session2) {
                if (session2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.updateConsoleToolbarIfNeeded();
            }

            @Override
            public void sessionClosed(@NotNull DatabaseSession session2) {
                if (session2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.updateConsoleToolbarIfNeeded();
            }

            private void updateConsoleToolbarIfNeeded() {
                boolean newShowToolbar = DatabaseEditorHelper.showConsoleToolbar(project);
                if (this.myShowToolbar == newShowToolbar) {
                    return;
                }
                this.myShowToolbar = newShowToolbar;
                DatabaseEditorHelper.getAllOpenedEditors(project).filter(e -> {
                    VirtualFile file = e.getVirtualFile();
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    return psiFile != null && DbSqlUtil.isSqlFile(psiFile) && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsoleProvider.getValidConsole(project, file) == null;
                }).forEach(e -> {
                    if (this.myShowToolbar) {
                        DatabaseEditorHelper.configureConsoleToolbar(project, null, e.getVirtualFile());
                        return;
                    }
                    DatabaseEditorHelper.removeConsoleToolbar(project, e.getVirtualFile());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "session";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            listener2.fileOpened(fileEditorManager, virtualFile);
        }
        DataBus.addRootAuditor(project, new DataAuditors.Adapter(){
            final ConcurrentMap<DataRequest.Context, String> myReportedQueries = ContainerUtil.createConcurrentWeakMap();

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (producer == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.updateToolbars(request);
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (producer == null) {
                    4.$$$reportNull$$$0(3);
                }
                this.updateToolbars(request);
            }

            void updateToolbars(@NotNull DataRequest request) {
                if (request == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (request.owner instanceof DataGrid || request.owner instanceof AbstractQueryLanguageConsole) {
                    ActivityTracker.getInstance().inc();
                }
            }

            @Override
            public void print(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message2) {
                if (context == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (!this.needLog(context)) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message2)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message2, MessageType.INFO).notify(project);
            }

            @Override
            public void warn(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message2) {
                if (context == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (!this.needLog(context)) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message2)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message2, MessageType.WARNING).notify(project);
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message2, @Nullable Throwable th) {
                Object content;
                if (context == null) {
                    4.$$$reportNull$$$0(7);
                }
                if (!this.needLog(context)) {
                    return;
                }
                String query = StringUtil.nullize((String)StringUtil.trim((String)context.getQuery()));
                if (query != null && Objects.equals(query, this.myReportedQueries.put(context, query))) {
                    query = null;
                }
                if (StringUtil.isEmptyOrSpaces((String)(content = (String)(query == null ? "" : query + "\n") + (message2 == null ? "" : message2) + (th == null ? "" : ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)LOG))))) {
                    content = DatabaseBundle.message("notification.content.missing.error.message", new Object[0]);
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification((String)content, MessageType.ERROR).notify(project);
            }

            private boolean needLog(@NotNull DataRequest.Context context) {
                if (context == null) {
                    4.$$$reportNull$$$0(8);
                }
                DatabaseSession session2 = (DatabaseSession)ObjectUtils.tryCast((Object)context.request.owner, DatabaseSession.class);
                return SessionsUtil.isInternalOwner(context.request.owner) || session2 != null && session2.isInternal();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateToolbars";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warn";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "needLog";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    public static boolean isDataFile(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(1);
        }
        return file instanceof DatabaseElementVirtualFileImpl && !((DatabaseElementVirtualFileImpl)file).isSource();
    }

    public static boolean needsRefresh(DatabaseElementVirtualFileImpl vf, @NotNull Project project) {
        DbElement element2;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(2);
        }
        if ((element2 = vf.findElement(project)) == null) {
            return false;
        }
        return DatabaseEditorHelper.computeObjectHashCode(element2) != vf.getObjectHash();
    }

    private static int computeObjectHashCode(DbElement element2) {
        int h = DatabaseEditorHelper.hashCode(element2);
        for (DbElement child : element2.getDasChildren(null)) {
            if (DbTargetUtil.adjustForNavigation(child) != element2) continue;
            h = Objects.hash(h, DatabaseEditorHelper.hashCode(child));
        }
        return h;
    }

    private static int hashCode(DbElement element2) {
        BasicElement e = DbImplUtilCore.getMaybeBasicElement(element2);
        return e == null ? 0 : ModelLightCopierUtils.hashCode(e);
    }

    public static void scheduleOutdatedCheck(@NotNull Project project, @NotNull VirtualFile file) {
        LocalDataSource ds;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(4);
        }
        DbElement element2 = DbImplUtilCore.findElement(project, file);
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(element2);
        LocalDataSource localDataSource = ds = element2 == null ? null : DbImplUtil.getMaybeLocalDataSource(element2.getDataSource());
        if (ds != null && basic != null) {
            DatabaseOutdatedCheckBuffer.getInstance(project).scheduleOutdatedCheck(ds, basic);
        }
    }

    @NotNull
    public static JBIterable<EditorEx> getAllOpenedEditors(@NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(TextEditor.class).map(TextEditor::getEditor).filter(EditorEx.class).filter(e -> e.getVirtualFile() != null);
        if (jBIterable == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static void restoreAttachedConsole(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(8);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file)) {
            return;
        }
        if (FileIndexFacade.getInstance((Project)project).isUnderIgnored(file)) {
            LOG.warn(file.getPresentableUrl() + " is under ignored root, console not initialized");
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return;
        }
        JdbcConsole existing = JdbcConsoleProvider.getValidConsole(project, file);
        if (existing != null) {
            DatabaseEditorHelper.configureConsoleToolbar(project, existing, file);
            return;
        }
        DatabaseSession attached = JdbcConsoleProvider.findOrCreateSession(project, file);
        if (attached != null) {
            JdbcConsoleProvider.attachConsole(project, attached, file);
            return;
        }
        if (DbSqlUtil.isSqlFile(psiFile)) {
            DatabaseEditorHelper.configureConsoleToolbar(project, null, file);
        }
    }

    private static boolean showConsoleToolbar(@NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(9);
        }
        return PlatformUtils.isDataGrip() || !DatabaseSessionManager.getSessions(project).isEmpty();
    }

    public static void removeConsoleToolbar(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(11);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null) continue;
            if (DatabaseEditorHelper.showConsoleToolbar(project)) {
                JComponent headerComponent = editor.getPermanentHeaderComponent();
                headerComponent.setBackground(null);
                for (Component c3 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c2 -> c2 instanceof ActionToolbar)) {
                    c3.setBackground(null);
                }
            } else {
                editor.setPermanentHeaderComponent(null);
                editor.setHeaderComponent(null);
            }
            editor.setBackgroundColor(null);
            editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, AbstractColorsScheme.INHERITED_COLOR_MARKER);
        }
    }

    public static void configureConsoleToolbar(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(12);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(13);
        }
        if (console == null && !DatabaseEditorHelper.showConsoleToolbar(project)) {
            return;
        }
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null) continue;
            JdbcConsole.buildHeaderComponent((Editor)editor, console);
        }
    }

    @Nullable
    public static DatabaseSessionClientWithFile findClient(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        JdbcConsole console;
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(14);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(15);
        }
        return (console = JdbcConsoleProvider.getValidConsole(source.getProject(), file)) != null ? console : (DatabaseSessionClientWithFile)GridDataHookUpManager.getInstance(source.getProject()).getClient(source.getProject(), file);
    }

    private static void configureToolbar(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(16);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(17);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DatabaseEditorHelper.configureToolbar(source.getProject(), file, editor);
            if (!(file instanceof DatabaseElementVirtualFileImpl)) continue;
            DatabaseEditorHelper.processLoading(source.getProject(), fileEditor, (DatabaseElementVirtualFileImpl)file);
        }
    }

    private static void processLoading(final Project project, FileEditor fileEditor, final DatabaseElementVirtualFileImpl vf) {
        JComponent editorComponent = fileEditor.getComponent();
        if (editorComponent instanceof JBLoadingPanel && vf.isBusy()) {
            ((JBLoadingPanel)editorComponent).startLoading();
        }
        if (DatabaseEditorHelper.needsReload(vf)) {
            new UiNotifyConnector.Once((Component)editorComponent, new Activatable(){

                public void showNotify() {
                    DatabaseEditorHelper.reloadIfNeeded(project, vf);
                }
            });
        }
    }

    @NotNull
    public static Promise<Void> reloadIfNeeded(@NotNull Project project, DatabaseElementVirtualFileImpl vf) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(18);
        }
        if (DatabaseEditorHelper.needsReload(vf)) {
            FILE_CONTENT_LOADED.set((UserDataHolder)vf, (Object)Boolean.TRUE);
            return DatabaseEditorHelper.scheduleReload(project, vf);
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(19);
        }
        return promise;
    }

    public static boolean needsReload(DatabaseElementVirtualFileImpl vf) {
        return !vf.isBusy() && vf.isSource() && !Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)vf));
    }

    private static void setDdlEditorsDisplayName(@NotNull VirtualFile file, @NotNull FileEditorManager fem) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(20);
        }
        if (fem == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (EditorWithProviderComposite composite : ((FileEditorManagerEx)fem).getSplitters().findEditorComposites(file)) {
            for (FileEditor editor : composite.getEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                composite.setDisplayName(editor, DDL_EDITOR_DISPLAY_NAME);
            }
        }
    }

    public static boolean isTableDataAvailable(@Nullable DbElement element2) {
        return element2 != null && DbImplUtilCore.isDataTable(element2.getKind()) && DbImplUtilCore.isInLocalDataSource(element2);
    }

    @NotNull
    public static StringBuilder loadOrGenerateDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb) {
        DdlBuilder builder;
        block7: {
            if (element2 == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(22);
            }
            if (sb == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(23);
            }
            int length = sb.length();
            DatabaseDefinitionHelper.loadDefinition(element2, sb);
            if (length == sb.length()) break block7;
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(24);
            }
            return stringBuilder;
        }
        try {
            builder = new DdlBuilder(sb).configureFor(element2).comment("definition is not available or empty\n");
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            builder = new DdlBuilder(sb).configureFor(element2).comment("Failed to load definition\n").comment(ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"") + "\n\n");
        }
        builder.comment("auto-generated definition\n\n");
        StringBuilder stringBuilder = DatabaseDefinitionHelper.generateDefinition(element2, sb);
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(25);
        }
        return stringBuilder;
    }

    public static void setCurrentSchemaSafe(@NotNull DatabaseDialectEx dialect, @Nullable ObjectPath path, @NotNull DatabaseConnection connection2) {
        SearchPath searchPath;
        String statement;
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(26);
        }
        if (connection2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(27);
        }
        String string = statement = (searchPath = SearchPath.of(path)) == null ? null : dialect.sqlSetSearchPath(searchPath);
        if (statement == null) {
            return;
        }
        try {
            SmartStatements.poweredBy(connection2).simple().barren().execute(statement);
        }
        catch (Exception e) {
            LOG.warn(statement, (Throwable)e);
        }
    }

    @NotNull
    public static Promise<Void> scheduleReload(final @NotNull Project project, final @NotNull DatabaseElementVirtualFileImpl virtualFile) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(28);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(29);
        }
        if (!virtualFile.isSource()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(30);
            }
            return promise;
        }
        Promise<Void> promise = new Computable<Promise<Void>>(){

            public Promise<Void> compute() {
                virtualFile.setBusy(true);
                return AsyncUtil.runAsync(() -> this.onReady(), DataSourceStorage.getProjectStorage(project)::doWhenInitialized);
            }

            public Promise<Void> onReady() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!project.isDisposed()) {
                        DatabaseEditorHelper.setVisualProgress(project, virtualFile, true);
                    }
                });
                return AsyncUtil.runAsync(() -> this.loadContent(), arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0)).thenAsync(ignored -> AsyncUtil.runAsync(() -> this.finish(), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> loadContent() {
                if (project.isDisposed()) {
                    return Promises.cancelledPromise();
                }
                StringBuilder sb = new StringBuilder();
                int objectHash = 0;
                try {
                    DbElement element2 = virtualFile.findElement(project);
                    if (element2 == null) {
                        sb.append("-- invalid target");
                    } else {
                        objectHash = DatabaseEditorHelper.computeObjectHashCode(element2);
                        Dbms dbms = DbImplUtilCore.getDbms(element2);
                        if (!DBIntrospectorFactory.hasNativeIntrospector(dbms) && DatabaseEditorHelperCore.isRawDefinitionAvailable(element2)) {
                            DatabaseEditorHelper.loadOrGenerateDefinition(element2, sb);
                        } else {
                            sb.append("-- auto-generated definition\n");
                            DatabaseDefinitionHelper.generateDefinition(element2, sb);
                        }
                        if (sb.length() == 0) {
                            sb.append("-- definition is not available or empty");
                        }
                    }
                }
                catch (Exception e) {
                    String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)LOG);
                    for (String s2 : trace.split("\n")) {
                        sb.append("-- ").append(s2).append("\n");
                    }
                }
                finally {
                    String content = StringUtil.convertLineSeparators((String)sb.toString());
                    virtualFile.setContent(content, objectHash);
                    virtualFile.setBusy(false);
                }
                return Promises.resolvedPromise();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> finish() {
                if (project.isDisposed() || !virtualFile.isValid()) {
                    return Promises.cancelledPromise();
                }
                DatabaseEditorHelper.setVisualProgress(project, virtualFile, false);
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
                if (document == null) {
                    return Promises.cancelledPromise();
                }
                Runnable docUpdateRunnable = () -> {
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    DbElement element2 = virtualFile.findElement(project);
                    DasNamespace object = element2 == null ? null : DbImplUtilCore.getSearchPathObject(element2);
                    DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ObjectPaths.searchPathOf(object));
                    FileDocumentManager.getInstance().reloadFromDisk(document);
                    boolean reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (file != null && reformatOnPaste) {
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                    }
                };
                boolean writable = virtualFile.isWritable();
                try {
                    virtualFile.setWritableInner(true);
                    document.setReadOnly(false);
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        if (document.getTextLength() == 0) {
                            DocumentReference reference = DocumentReferenceManager.getInstance().create(document);
                            UndoManager.getInstance((Project)project).nonundoableActionPerformed(reference, false);
                        }
                        docUpdateRunnable.run();
                    });
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                }
                catch (Throwable throwable) {
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                    throw throwable;
                }
                return Promises.resolvedPromise();
            }
        }.compute();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(31);
        }
        return promise;
    }

    private static void setVisualProgress(@NotNull Project project, @NotNull VirtualFile file, boolean flag) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(32);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(33);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            JComponent editorComponent;
            if (!(fileEditor instanceof TextEditor) || !((editorComponent = fileEditor.getComponent()) instanceof JBLoadingPanel)) continue;
            JBLoadingPanel component = (JBLoadingPanel)editorComponent;
            if (flag) {
                component.startLoading();
                continue;
            }
            component.stopLoading();
        }
    }

    private static void configureToolbar(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Editor editor) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(34);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(36);
        }
        if (((EditorEx)editor).getPermanentHeaderComponent() != null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        boolean isDbSrc = DbSrcUtilsCore.isDbSrcFile(virtualFile);
        if (isDbSrc) {
            group.add((AnAction)new ExecuteRoutineFromFileAction());
            PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)virtualFile);
            if (psiFile instanceof SqlFile && ((SqlFile)psiFile).getSqlLanguage().getDbms().isOracle()) {
                group.add((AnAction)new DebugRoutineAction());
            }
        }
        DumbAwareAction dataAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                VirtualFile file;
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ObjectKind kind = DbSrcUtilsCore.isDbSrcFile(file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) || file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)file).isSource() ? DbImplUtil.getKind(file) : null;
                boolean enabled = DbImplUtilCore.isDataTable(kind);
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                if ((project = e.getProject()) == null) {
                    return;
                }
                VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                DbElement element2 = DbImplUtilCore.findElement(project, file);
                if (element2 == null || !element2.isValid()) {
                    return;
                }
                DbNavigationUtils.navigateToData(element2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ActionUtil.copyFrom((AnAction)dataAction, (String)"Jdbc.OpenEditor.Data");
        dataAction.registerCustomShortcutSet(editor.getComponent(), null);
        ActionManager actionManager = ActionManager.getInstance();
        if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            group.add(actionManager.getAction("DDL.Editor.Specific.LightFile"));
        } else if (isDbSrc) {
            group.add(actionManager.getAction("DDL.Editor.Specific.StorageFile"));
        }
        group.add((AnAction)dataAction);
        ActionToolbar leftToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)group, true);
        leftToolbar.setTargetComponent(editor.getContentComponent());
        JComponent component = leftToolbar.getComponent();
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        headerComponent.add((Component)component, "West");
        if (isDbSrc) {
            AnAction action2 = actionManager.getAction("Console.Jdbc.ChooseSession");
            ActionToolbar rightToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{action2}), true);
            rightToolbar.setTargetComponent(editor.getContentComponent());
            headerComponent.add((Component)rightToolbar.getComponent(), "East");
        }
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        DatabaseEditorHelper.configureEditorHeader(project, virtualFile, (JComponent)headerComponent);
    }

    public static void openConsoleFile(@Nullable DbElement element2) {
        DatabaseEditorHelper.openConsoleFile(element2, false);
    }

    public static void openConsoleFile(@Nullable DbElement element2, boolean newInstance) {
        LocalDataSource dataSource2;
        LocalDataSource localDataSource = dataSource2 = element2 == null ? null : DbImplUtil.getMaybeLocalDataSource(element2.getDataSource());
        if (dataSource2 == null) {
            return;
        }
        DasNamespace context = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel().getCurrentRootNamespace() : DasUtil.getParentOfClass(element2, DasNamespace.class, false);
        DatabaseEditorHelper.openConsoleFile(element2.getProject(), dataSource2, context, newInstance);
    }

    public static void openConsoleFile(@NotNull Project project, @NotNull DasDataSource dataSource2, @Nullable DasNamespace schema, boolean newInstance) {
        VirtualFile file;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(37);
        }
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(38);
        }
        VirtualFile virtualFile = file = newInstance ? DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource2) : DatabaseEditorHelper.getConsoleVirtualFile(dataSource2);
        if (file != null) {
            DatabaseEditorHelper.openConsoleForFile(project, dataSource2, schema, file);
        }
    }

    public static void openConsoleForFile(@NotNull Project project, @NotNull DasDataSource dataSource2, @Nullable DasNamespace schema, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(39);
        }
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(40);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(41);
        }
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        if (schema == null) {
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dataSource2.getDbms());
        DasNamespace spObject = DbImplUtilCore.getSearchPathObject(dialect, schema);
        List<DasNamespace> namespaces2 = Collections.singletonList(spObject);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(DbImplUtil.getMaybeLocalDataSource(dataSource2), ObjectPaths.of(namespaces2));
        if (searchPath != null) {
            if (console != null) {
                console.switchSchema(searchPath, false);
            } else {
                ChooseSchemaAction.setSelectedSearchPath(project, file, searchPath);
            }
        }
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)PsiManager.getInstance((Project)project).findFile(file), (Object)searchPath);
    }

    @Nullable
    public static VirtualFile getConsoleRootDir(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(42);
        }
        String rootPath = DbConsoleRootType.getInstance().getContentRootPath(dataSource2.getUniqueId());
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(rootPath);
    }

    @Nullable
    public static VirtualFile getConsoleVirtualFile(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(43);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource2.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_if_missing);
    }

    @Nullable
    public static VirtualFile findExistingConsoleVirtualFile(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(44);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource2.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.existing_only);
    }

    @Nullable
    public static VirtualFile createNewConsoleVirtualFile(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(45);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource2.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
    }

    public static void configureEditorHeader(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable JComponent headerComponent) {
        if (headerComponent == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        DatabaseGridDataHookUp hookup = DbVFSUtils.isConsoleFile(virtualFile) ? DataGridUtil.getDatabaseHookUp(dataGrid) : null;
        DasTable table = hookup == null ? null : hookup.getDatabaseTable();
        VirtualFile adjustedFile = table instanceof DbElement ? ((DbElement)((Object)table)).getVirtualFile() : virtualFile;
        DatabaseColorManager.LocalColors state = project == null ? null : (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        Color color = state != null && state.useColors ? DatabaseColorManager.getColor(project, adjustedFile, true) : null;
        Color toolbarColor = state != null && state.useInToolbars ? color : null;
        headerComponent.setBackground(toolbarColor);
        for (Component c3 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c2 -> c2 instanceof ActionToolbar)) {
            c3.setBackground(toolbarColor);
            if (!(c3.getParent() instanceof TwoSideComponent)) continue;
            c3.getParent().setBackground(toolbarColor);
            ((TwoSideComponent)c3.getParent()).setOpaque(toolbarColor != null);
        }
        Color editorColor = state != null && state.useInEditor ? color : null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        if (editor instanceof EditorEx) {
            Language lang;
            Language language = lang = project == null ? null : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)((EditorEx)editor).getVirtualFile());
            if (lang != null && lang.getAssociatedFileType() == SqlFileType.INSTANCE) {
                ((EditorEx)editor).setBackgroundColor(editorColor);
                editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, (Color)ObjectUtils.notNull((Object)editorColor, (Object)AbstractColorsScheme.INHERITED_COLOR_MARKER));
            }
        }
        if (dataGrid != null) {
            dataGrid.getColorsScheme().setDefaultBackground(editorColor);
            dataGrid.getResultView().defaultBackgroundChanged();
        }
    }

    @Nullable
    private static BasicNamedElement getNamed(@Nullable BasicElement element2, @NotNull ObjectKind kind, @NotNull String name) {
        if (kind == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(46);
        }
        if (name == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(47);
        }
        NamingFamily family = element2 == null ? null : (NamingFamily)element2.familyOf(kind);
        return family == null ? null : (BasicNamedElement)family.get(name);
    }

    @Nullable
    public static DasNamespace findNamespace(@NotNull Project project, @NotNull DasDataSource dataSource2, @Nullable ObjectPath objectPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(48);
        }
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(49);
        }
        if (objectPath == null) {
            return null;
        }
        dataSource2 = dataSource2 instanceof DbDataSource ? ((DbDataSource)dataSource2).getDelegate() : dataSource2;
        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
        ObjectKind k = objectPath.kind;
        if (model == null || k != ObjectKind.SCHEMA && k != ObjectKind.DATABASE) {
            return null;
        }
        BasicRoot root2 = model.getRoot();
        if (root2 instanceof BasicModMultiDatabaseRoot) {
            if (k == ObjectKind.DATABASE) {
                return (DasNamespace)((Object)DatabaseEditorHelper.getNamed(root2, ObjectKind.DATABASE, objectPath.getName()));
            }
            ObjectPath parent2 = objectPath.parent;
            if (parent2 != null) {
                return (DasNamespace)((Object)DatabaseEditorHelper.getNamed(DatabaseEditorHelper.getNamed(root2, ObjectKind.DATABASE, parent2.getName()), ObjectKind.SCHEMA, objectPath.getName()));
            }
        }
        if (k != ObjectKind.SCHEMA) {
            return null;
        }
        for (BasicSchema basicSchema : root2.getAllSchemas()) {
            if (!basicSchema.getName().equals(objectPath.getName())) continue;
            return basicSchema;
        }
        return null;
    }

    @Nullable
    public static List<DasNamespace> findNamespaces(@NotNull Project project, @NotNull DasDataSource dataSource2, @Nullable SearchPath searchPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(50);
        }
        if (dataSource2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(51);
        }
        if (searchPath == null) {
            return null;
        }
        List sp = JBIterable.from(searchPath.elements).transform(p2 -> DatabaseEditorHelper.findNamespace(project, dataSource2, p2)).toList();
        return sp.isEmpty() ? null : sp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fem";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOpenedEditors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadIfNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOrGenerateDefinition";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installEditorFactoryListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDataFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleOutdatedCheck";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllOpenedEditors";
                break;
            }
            case 6: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreAttachedConsole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showConsoleToolbar";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeConsoleToolbar";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureConsoleToolbar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findClient";
                break;
            }
            case 16: 
            case 17: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureToolbar";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reloadIfNeeded";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDdlEditorsDisplayName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadOrGenerateDefinition";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentSchemaSafe";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReload";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setVisualProgress";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleFile";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleForFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleRootDir";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleVirtualFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConsoleVirtualFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createNewConsoleVirtualFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNamed";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Regenerate
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                Regenerate.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            DatabaseElementVirtualFileImpl vf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.VIRTUAL_FILE), DatabaseElementVirtualFileImpl.class));
            if (project != null && vf != null) {
                DatabaseEditorHelper.scheduleReload(project, vf);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Regenerate.$$$reportNull$$$0(1);
            }
            DatabaseElementVirtualFileImpl vf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.VIRTUAL_FILE), DatabaseElementVirtualFileImpl.class));
            e.getPresentation().setEnabledAndVisible(vf != null && vf.isSource());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$Regenerate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

