/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.serialization.ModelConverters;
import com.intellij.database.model.serialization.ModelConvertersKt;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.converters.Converter_2_7;
import com.intellij.database.model.serialization.converters.Converter_4_0;
import com.intellij.database.model.serialization.converters.Converter_4_1;
import com.intellij.database.model.serialization.converters.Converter_4_10;
import com.intellij.database.model.serialization.converters.Converter_4_12;
import com.intellij.database.model.serialization.converters.Converter_4_14;
import com.intellij.database.model.serialization.converters.Converter_4_16;
import com.intellij.database.model.serialization.converters.Converter_4_17;
import com.intellij.database.model.serialization.converters.Converter_4_20;
import com.intellij.database.model.serialization.converters.Converter_4_21;
import com.intellij.database.model.serialization.converters.Converter_4_22;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/model/serialization/ModelConverters;", "", "()V", "alignDbmsWithRoot", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertMem", "convertModel", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "since", "Lcom/intellij/database/util/Version;", "intellij.database.core.impl"})
public final class ModelConverters {
    public final void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Version ver = modelMem.getVersion();
        if (ver.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return;
        }
        if (ver.less(2, 7)) {
            new Converter_2_7().convertMem(modelMem);
        }
        if (ver.less(4, 0)) {
            new Converter_4_0().convertMem(modelMem);
        }
        if (ver.less(4, 1)) {
            new Converter_4_1().convertMem(modelMem);
        }
        if (ver.less(4, 12)) {
            new Converter_4_12().convertMem(modelMem);
        }
        if (ver.less(4, 14)) {
            new Converter_4_14().convertMem(modelMem);
        }
        if (ver.less(4, 16)) {
            new Converter_4_16().convertMem(modelMem);
        }
        if (ver.less(4, 17)) {
            new Converter_4_17().convertMem(modelMem);
        }
        if (ver.less(4, 20)) {
            new Converter_4_20().convertMem(modelMem);
        }
        if (ver.less(4, 21)) {
            new Converter_4_21().convertMem(modelMem);
        }
        if (ver.less(4, 22)) {
            new Converter_4_22().convertMem(modelMem);
        }
        this.alignDbmsWithRoot(modelMem);
    }

    private final void alignDbmsWithRoot(ModelMem modelMem) {
        ModelElementMem modelElementMem = ModelConvertersKt.findFirst(modelMem, (Function1<? super ModelElementMem, Boolean>)((Function1)alignDbmsWithRoot.root.1.INSTANCE));
        if (modelElementMem == null) {
            return;
        }
        ModelElementMem root2 = modelElementMem;
        String dbmsName = ModelConvertersKt.getProperty(root2, "Dbms");
        if (Intrinsics.areEqual((Object)dbmsName, (Object)modelMem.getDbms().getName()) ^ true) {
            Dbms dbms;
            Dbms dbms2;
            String string = dbmsName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string2;
                boolean bl3 = false;
                dbms2 = Dbms.byName(it2);
            } else {
                dbms2 = dbms = null;
            }
            if (dbms != null) {
                modelMem.setDbms(dbms);
            }
        }
    }

    public final void convertModel(@NotNull BasicModModel model, @NotNull Version since) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        if (since.isOrGreater(ModelSerializationVersions.CURRENT_VERSION)) {
            return;
        }
        if (since.less(4, 10)) {
            new Converter_4_10().convertModel(model);
        }
    }
}

