/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorHandler {
    private static final Logger LOG = Logger.getInstance(ErrorHandler.class);
    private final Set<String> myMessages = new THashSet();
    private final List<DatabaseErrorHandler.Fix> myFixes = new ArrayList<DatabaseErrorHandler.Fix>();
    @NlsSafe
    private final StringBuilder myErrors = new StringBuilder();
    private boolean myTruncated;
    private int mySkippedErrors;

    public boolean hasErrors() {
        return this.myErrors.length() > 0;
    }

    @NotNull
    public List<DatabaseErrorHandler.Fix> getFixes() {
        List<DatabaseErrorHandler.Fix> list = this.myFixes;
        if (list == null) {
            ErrorHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addFix(@NotNull DatabaseErrorHandler.Fix fix) {
        if (fix == null) {
            ErrorHandler.$$$reportNull$$$0(1);
        }
        this.myFixes.add(fix);
    }

    public boolean addError(@Nls @Nullable String message2, @Nullable Throwable ex) {
        String exMessage;
        if (ex instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)ex;
        }
        if (this.myTruncated) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            String m = JdbcUtil.getLongMessage(ex);
            m = StringUtil.isNotEmpty((String)m) ? m : ex.getClass().getName();
            exMessage = m.equals(message2) ? null : m;
        } else {
            exMessage = null;
        }
        if (message2 != null && !this.myMessages.add(message2) || exMessage != null && !this.myMessages.add(exMessage)) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            LOG.warn(ex);
        }
        if (message2 != null) {
            this.appendMessage(message2);
        }
        if (exMessage != null) {
            Throwable cause = ex.getCause();
            if (cause instanceof UnknownHostException) {
                this.appendMessage(DatabaseBundle.message("host.0.is.unknown", cause.getMessage()));
            }
            this.appendMessage(StringUtil.replace((String)exMessage, (String)"\n\n", (String)".\n"));
        }
        if (this.myErrors.length() > 10240) {
            this.myTruncated = true;
        }
        return true;
    }

    private void appendMessage(@Nls @NotNull String message2) {
        if (message2 == null) {
            ErrorHandler.$$$reportNull$$$0(2);
        }
        String trimmed = message2.trim();
        this.myErrors.append(trimmed);
        this.myErrors.append(trimmed.endsWith(".") ? "\n" : ".\n");
    }

    @Nls
    public String getSummary() {
        if (this.mySkippedErrors > 0) {
            this.myErrors.append(DatabaseBundle.message("and.0.1.choice.0.more.1.duplicate.reports", this.mySkippedErrors, this.myTruncated ? 0 : 1));
            this.mySkippedErrors = 0;
        }
        return this.myErrors.toString();
    }

    @Nls
    public String getSummary(@Nls String alt) {
        return this.hasErrors() ? this.getSummary() : alt;
    }

    public void setCaption(@Nls String message2) {
        this.myErrors.insert(0, message2 + "\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ErrorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

