/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.AuxiliaryFamilyGroup;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseObjectsGroup;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseTreeKeys;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ServerObjectsGroup;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ba\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u001a$\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u001a8\u0010'\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010)\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\"2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u001a\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0012\u0010-\u001a\u0004\u0018\u00010\"2\u0006\u0010.\u001a\u00020/H\u0002\u001a(\u00100\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0010H\u0002\u001a\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:\u001a\u000e\u0010;\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0002\u001a\u000e\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u001f\u001a \u0010=\u001a\u0004\u0018\u00010\"2\u0006\u00107\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u0010\u001a&\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0?2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u00104\u001a\u00020\u0010\u001a\u001e\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0?2\u0006\u0010,\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u0010\u001a\u001e\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0?2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0010\u001a \u0010A\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u00104\u001a\u00020\u0010H\u0002\u001a(\u0010A\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u0002082\u0006\u00104\u001a\u00020\u0010H\u0002\u001a\u0018\u0010B\u001a\u00020C2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0010H\u0002\u001a.\u0010D\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020F2\u0006\u00104\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u001a'\u0010G\u001a\n\u0012\u0004\u0012\u0002HI\u0018\u00010H\"\n\b\u0000\u0010I\u0018\u0001*\u000208*\b\u0012\u0004\u0012\u0002080HH\u0082\b\u001a\u0014\u0010J\u001a\n\u0012\u0004\u0012\u00020K\u0018\u00010H*\u00020LH\u0000\u001a\f\u0010M\u001a\u00020\u0001*\u00020LH\u0000\u001a\f\u0010N\u001a\u0004\u0018\u00010O*\u00020\u0007\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006P"}, d2={"dbCollapsed", "", "Lcom/intellij/database/psi/DbDataSource;", "getDbCollapsed", "(Lcom/intellij/database/psi/DbDataSource;)Z", "dbModel", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/DasDataSource;", "getDbModel", "(Lcom/intellij/database/model/DasDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/psi/DbDataSource;)Lcom/intellij/database/model/basic/BasicModel;", "dbRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getDbRoot", "(Lcom/intellij/database/psi/DbDataSource;)Lcom/intellij/database/model/basic/BasicRoot;", "groupAuxObjects", "Lcom/intellij/database/view/DatabaseViewOptions;", "getGroupAuxObjects", "(Lcom/intellij/database/view/DatabaseViewOptions;)Z", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "getIntrospectionScope", "(Lcom/intellij/database/psi/DbDataSource;)Lcom/intellij/database/util/TreePattern;", "modelElement", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/DasObject;", "getModelElement", "(Lcom/intellij/database/model/DasObject;)Lcom/intellij/database/model/basic/BasicElement;", "addFakeDatabaseLeaf", "", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "result", "", "Lcom/intellij/database/model/basic/BasicNode;", "addFakeSchemaLeaf", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "parentNode", "collectSchemas", "scope", "showAll", "findDatabaseObjectsGroup", "Lcom/intellij/database/view/DatabaseObjectsGroup;", "dbDataSource", "findParentForRegularFamilyGroup", "familyGroup", "Lcom/intellij/database/view/DatabaseStructure$FamilyGroup;", "findParentForSchemaChild", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "element", "viewOptions", "getDbWrapperFor", "Lcom/intellij/database/psi/DbElement;", "node", "", "structure", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "getSimpleDataSourceRoot", "dsNode", "getSimpleParent", "listSimpleDatabaseContent", "Lcom/intellij/util/containers/JBIterable;", "listSimpleRootContent", "obtainDatabaseObjectsGroup", "obtainServerObjectsGroup", "Lcom/intellij/database/view/ServerObjectsGroup;", "processMultiDatabaseTopStuff", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "allAre", "", "T", "getSelectedLocalDataSourcesIfOnly", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/openapi/actionSystem/DataContext;", "isSelectedOneGroup", "unwrap", "Lcom/intellij/database/dataSource/AbstractDataSource;", "intellij.database.impl"})
@JvmName(name="DatabaseViewTreeFun")
public final class DatabaseViewTreeFun {
    @NotNull
    public static final DasObject getSimpleDataSourceRoot(@NotNull DataSourceNode dsNode) {
        Intrinsics.checkNotNullParameter((Object)dsNode, (String)"dsNode");
        BasicRoot basicRoot = dsNode.getModelRoot();
        return basicRoot != null ? (DasObject)basicRoot : (DasObject)dsNode.dbDataSource;
    }

    @NotNull
    public static final DasObject getSimpleDataSourceRoot(@NotNull DbDataSource dbDataSource) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        BasicModel dbModel = DatabaseViewTreeFun.getDbModel(dbDataSource);
        if (dbModel != null) {
            BasicRoot basicRoot = dbModel.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"dbModel.root");
            return basicRoot;
        }
        return dbDataSource;
    }

    @NotNull
    public static final JBIterable<? extends BasicNode> listSimpleRootContent(@NotNull DbDataSource dbDataSource, @NotNull DatabaseViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)viewOptions), (String)"viewOptions");
        DataSourceNode dsn = DataSourceNode.Companion.node(dbDataSource);
        return DatabaseViewTreeFun.listSimpleRootContent(dsn, viewOptions);
    }

    @NotNull
    public static final JBIterable<? extends BasicNode> listSimpleRootContent(@NotNull DataSourceNode dsn, @NotNull DatabaseViewOptions viewOptions) {
        BasicRoot root2;
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        Intrinsics.checkNotNullParameter((Object)((Object)viewOptions), (String)"viewOptions");
        ArrayList result2 = new ArrayList();
        BasicRoot basicRoot = dsn.getModelRoot();
        if (basicRoot == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.empty()");
            return jBIterable;
        }
        BasicRoot basicRoot2 = root2 = basicRoot;
        if (basicRoot2 instanceof BasicMultiDatabaseRoot) {
            DatabaseViewTreeFun.processMultiDatabaseTopStuff(dsn, (BasicMultiDatabaseRoot)root2, viewOptions, result2);
        } else if (basicRoot2 instanceof BasicDatabase) {
            TreePattern scope = DatabaseViewTreeFun.getIntrospectionScope(dsn.dbDataSource);
            boolean showAll = viewOptions.SHOW_ALL_NAMESPACES;
            DatabaseViewTreeFun.collectSchemas((BasicDatabase)((Object)root2), scope, showAll, dsn, result2);
        }
        ServerObjectsGroup serverObjectsGroup = DatabaseViewTreeFun.obtainServerObjectsGroup(dsn, viewOptions);
        if (serverObjectsGroup.getHasInnerGroupsToShow()) {
            if (DatabaseViewTreeFun.getGroupAuxObjects(viewOptions)) {
                Collection collection = result2;
                boolean bl = false;
                collection.add(serverObjectsGroup);
            } else {
                CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)serverObjectsGroup.iterateChildren()));
            }
        }
        JBIterable jBIterable = JBIterable.from((Iterable)result2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(result)");
        return jBIterable;
    }

    private static final void processMultiDatabaseTopStuff(DataSourceNode dsn, BasicMultiDatabaseRoot root2, DatabaseViewOptions viewOptions, Collection<BasicNode> result2) {
        boolean showAll = viewOptions.SHOW_ALL_NAMESPACES;
        DbDataSource dbDataSource = dsn.dbDataSource;
        TreePattern scope = DatabaseViewTreeFun.getIntrospectionScope(dbDataSource);
        NamingFamily<? extends BasicMateDatabase> namingFamily = root2.getDatabases();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"root.databases");
        NamingFamily<? extends BasicMateDatabase> databases = namingFamily;
        List databasesToShow = null;
        databasesToShow = showAll || scope == null ? CollectionsKt.toList((Iterable)databases) : SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)databases), (Function1)((Function1)new Function1<BasicMateDatabase, Boolean>(scope){
            final /* synthetic */ TreePattern $scope;

            public final boolean invoke(BasicMateDatabase it2) {
                return DataSourceSchemaMapping.matches(this.$scope, it2);
            }
            {
                this.$scope = treePattern;
                super(1);
            }
        })));
        if (databasesToShow.isEmpty()) {
            DatabaseViewTreeFun.addFakeDatabaseLeaf(dsn, result2);
            DatabaseTreeKeys.DATABASE_IS_COLLAPSED.set((UserDataHolder)dbDataSource, (Object)false);
        } else if (databasesToShow.size() == 1 && !viewOptions.SHOW_INTERMEDIATE) {
            Object object = CollectionsKt.first((List)databasesToShow);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"databasesToShow.first()");
            BasicDatabase db1 = (BasicDatabase)object;
            DatabaseViewTreeFun.collectSchemas(db1, scope, showAll, dsn, result2);
            DatabaseObjectsGroup dbObjectsGroup = DatabaseViewTreeFun.obtainDatabaseObjectsGroup(dbDataSource, db1, dsn, viewOptions);
            if (dbObjectsGroup.getHasInnerGroupsToShow()) {
                Collection<BasicNode> collection = result2;
                boolean bl = false;
                collection.add(dbObjectsGroup);
            }
            DatabaseTreeKeys.DATABASE_IS_COLLAPSED.set((UserDataHolder)dbDataSource, (Object)true);
            DatabaseTreeKeys.FAKE_DATABASE_LEAF.set((UserDataHolder)dbDataSource, null);
        } else {
            for (BasicMateDatabase db : databasesToShow) {
                Collection<BasicNode> collection = result2;
                boolean bl = false;
                collection.add(db);
            }
            DatabaseTreeKeys.DATABASE_IS_COLLAPSED.set((UserDataHolder)dbDataSource, (Object)false);
            DatabaseTreeKeys.FAKE_DATABASE_LEAF.set((UserDataHolder)dbDataSource, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ServerObjectsGroup obtainServerObjectsGroup(DataSourceNode dsn, DatabaseViewOptions viewOptions) {
        boolean bl = dsn.getModelRoot() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Key<ServerObjectsGroup> key = DatabaseTreeKeys.SERVER_OBJECTS_GROUP;
        Intrinsics.checkNotNullExpressionValue(key, (String)"SERVER_OBJECTS_GROUP");
        Key<ServerObjectsGroup> key2 = key;
        bl2 = false;
        bl3 = false;
        synchronized (key2) {
            boolean bl5 = false;
            ServerObjectsGroup serverObjectsGroup = (ServerObjectsGroup)DatabaseTreeKeys.SERVER_OBJECTS_GROUP.get((UserDataHolder)dsn.dbDataSource);
            if (serverObjectsGroup == null) {
                serverObjectsGroup = new ServerObjectsGroup(dsn, viewOptions);
                DatabaseTreeKeys.SERVER_OBJECTS_GROUP.set((UserDataHolder)dsn.dbDataSource, (Object)serverObjectsGroup);
            }
            ServerObjectsGroup serverObjectsGroup2 = serverObjectsGroup;
            return serverObjectsGroup2;
        }
    }

    private static final DatabaseObjectsGroup obtainDatabaseObjectsGroup(DbDataSource dbDataSource, BasicDatabase database, DatabaseViewOptions viewOptions) {
        if (database instanceof BasicRoot) {
            return DatabaseViewTreeFun.obtainDatabaseObjectsGroup(dbDataSource, database, dbDataSource, viewOptions);
        }
        DbElement dbElement = DbImplUtilCore.findElement(dbDataSource, database);
        if (dbElement == null) {
            dbElement = dbDataSource;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"DbImplUtilCore.findEleme\u2026database) ?: dbDataSource");
        DbElement dbDatabase = dbElement;
        return DatabaseViewTreeFun.obtainDatabaseObjectsGroup(dbDataSource, database, dbDatabase, viewOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DatabaseObjectsGroup obtainDatabaseObjectsGroup(DbDataSource dbDataSource, BasicDatabase database, Object parentNode, DatabaseViewOptions viewOptions) {
        Key<Map<String, DatabaseObjectsGroup>> key = DatabaseTreeKeys.DATABASE_OBJECTS_GROUPS;
        Intrinsics.checkNotNullExpressionValue(key, (String)"DATABASE_OBJECTS_GROUPS");
        Key<Map<String, DatabaseObjectsGroup>> key2 = key;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (key2) {
            DatabaseObjectsGroup dbObjectsGroup;
            boolean bl3 = false;
            Map map2 = (Map)DatabaseTreeKeys.DATABASE_OBJECTS_GROUPS.get((UserDataHolder)dbDataSource);
            if (map2 == null) {
                map2 = new HashMap();
                DatabaseTreeKeys.DATABASE_OBJECTS_GROUPS.set((UserDataHolder)dbDataSource, (Object)map2);
            }
            if ((dbObjectsGroup = (DatabaseObjectsGroup)map2.get(database.getName())) != null && dbObjectsGroup.getParentNode() != parentNode) {
                dbObjectsGroup = null;
            }
            if (dbObjectsGroup == null) {
                dbObjectsGroup = new DatabaseObjectsGroup(database, dbDataSource, viewOptions);
                String string = database.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"database.name");
                map2.put(string, dbObjectsGroup);
            }
            DatabaseObjectsGroup databaseObjectsGroup = dbObjectsGroup;
            return databaseObjectsGroup;
        }
    }

    private static final DatabaseObjectsGroup findDatabaseObjectsGroup(DbDataSource dbDataSource, BasicDatabase database) {
        Map map2 = (Map)DatabaseTreeKeys.DATABASE_OBJECTS_GROUPS.get((UserDataHolder)dbDataSource);
        if (map2 == null) {
            return null;
        }
        Map map3 = map2;
        String string = database.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"database.name");
        String name = string;
        return (DatabaseObjectsGroup)map3.get(name);
    }

    @NotNull
    public static final JBIterable<? extends BasicNode> listSimpleDatabaseContent(@NotNull DbDataSource dbDataSource, @NotNull BasicDatabase database, @NotNull DatabaseViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)((Object)viewOptions), (String)"viewOptions");
        ArrayList result2 = new ArrayList();
        TreePattern scope = DatabaseViewTreeFun.getIntrospectionScope(dbDataSource);
        boolean showAll = viewOptions.SHOW_ALL_NAMESPACES;
        DbElement dbElement = DbImplUtilCore.findElement(dbDataSource, database);
        if (dbElement == null) {
            dbElement = dbDataSource;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"DbImplUtilCore.findEleme\u2026database) ?: dbDataSource");
        DbElement dbDatabase = dbElement;
        DatabaseViewTreeFun.collectSchemas(database, scope, showAll, database, result2);
        DatabaseObjectsGroup dbObjectsGroup = DatabaseViewTreeFun.obtainDatabaseObjectsGroup(dbDataSource, database, dbDatabase, viewOptions);
        if (dbObjectsGroup.getHasInnerGroupsToShow()) {
            if (DatabaseViewTreeFun.getGroupAuxObjects(viewOptions)) {
                Collection collection = result2;
                boolean bl = false;
                collection.add(dbObjectsGroup);
            } else {
                CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)dbObjectsGroup.iterateChildren()));
            }
        }
        JBIterable jBIterable = JBIterable.from((Iterable)result2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(result)");
        return jBIterable;
    }

    public static final void collectSchemas(@NotNull BasicDatabase database, @Nullable TreePattern scope, boolean showAll, @NotNull BasicNode parentNode, @NotNull Collection<BasicNode> result2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NamingFamily<? extends BasicSchema> namingFamily = database.getSchemas();
        Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"database.schemas");
        NamingFamily<? extends BasicSchema> schemas = namingFamily;
        if (showAll || scope == null) {
            CollectionsKt.addAll(result2, (Iterable)schemas);
        } else {
            SequencesKt.toCollection((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)schemas), (Function1)((Function1)new Function1<BasicSchema, Boolean>(scope){
                final /* synthetic */ TreePattern $scope;

                public final boolean invoke(BasicSchema it2) {
                    return DataSourceSchemaMapping.matches(this.$scope, it2);
                }
                {
                    this.$scope = treePattern;
                    super(1);
                }
            })), result2);
        }
        if (result2.isEmpty()) {
            DatabaseViewTreeFun.addFakeSchemaLeaf(database, parentNode, result2);
        }
    }

    public static final void addFakeSchemaLeaf(@NotNull BasicDatabase database, @NotNull BasicNode parentNode, @NotNull Collection<BasicNode> result2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        DatabaseStructure.EmptyScopeLeaf leaf = new DatabaseStructure.EmptyScopeLeaf(database, ObjectKind.SCHEMA, parentNode);
        result2.add(leaf);
    }

    public static final boolean getGroupAuxObjects(@NotNull DatabaseViewOptions $this$groupAuxObjects) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$groupAuxObjects), (String)"$this$groupAuxObjects");
        return $this$groupAuxObjects.GROUP_AUX_OBJECTS && !$this$groupAuxObjects.GROUP_NAMESPACES;
    }

    @Nullable
    public static final BasicNode getSimpleParent(@NotNull BasicNode node, @NotNull DbDataSource dbDataSource, @NotNull DatabaseViewOptions viewOptions) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)viewOptions), (String)"viewOptions");
        DataSourceNode dsn = DataSourceNode.Companion.node(dbDataSource);
        BasicNode basicNode2 = node;
        if (basicNode2 instanceof BasicDatabase) {
            basicNode = DatabaseViewTreeFun.getDbCollapsed(dbDataSource) ? DatabaseViewTreeFun.getSimpleParent(dsn, dbDataSource, viewOptions) : (BasicNode)dsn;
        } else if (basicNode2 instanceof BasicSchema) {
            BasicElement databaseParent;
            BasicDatabase database = ((BasicSchema)node).getDatabase();
            if (database instanceof BasicRoot) {
                return dsn;
            }
            if (viewOptions.SHOW_INTERMEDIATE) {
                return database;
            }
            Boolean collapsed = (Boolean)DatabaseTreeKeys.DATABASE_IS_COLLAPSED.get((UserDataHolder)dbDataSource);
            BasicDatabase basicDatabase = database;
            BasicElement basicElement = databaseParent = basicDatabase != null ? basicDatabase.getParent() : null;
            if (collapsed == null && databaseParent instanceof BasicMultiDatabaseRoot) {
                boolean bl = false;
                DatabaseViewTreeFun.processMultiDatabaseTopStuff(dsn, (BasicMultiDatabaseRoot)databaseParent, viewOptions, new ArrayList());
                collapsed = (Boolean)DatabaseTreeKeys.DATABASE_IS_COLLAPSED.get((UserDataHolder)dbDataSource);
            }
            basicNode = Intrinsics.areEqual((Object)collapsed, (Object)true) ? (BasicNode)dsn : (BasicNode)database;
        } else if (basicNode2 instanceof BasicElement) {
            BasicElement parent2 = ((BasicElement)node).getParent();
            if (parent2 == null) {
                basicNode = null;
            } else if (parent2 instanceof BasicRoot) {
                ServerObjectsGroup serverObjectsGroup = DatabaseViewTreeFun.obtainServerObjectsGroup(dsn, viewOptions);
                ObjectKind objectKind = ((BasicElement)node).getKind();
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"node.kind");
                basicNode = serverObjectsGroup.getInnerGroup(objectKind);
            } else if (parent2 instanceof BasicDatabase) {
                DatabaseObjectsGroup databaseObjectsGroup = DatabaseViewTreeFun.obtainDatabaseObjectsGroup(dbDataSource, (BasicDatabase)parent2, viewOptions);
                ObjectKind objectKind = ((BasicElement)node).getKind();
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"node.kind");
                basicNode = databaseObjectsGroup.getInnerGroup(objectKind);
            } else {
                basicNode = parent2 instanceof BasicSchema ? DatabaseViewTreeFun.findParentForSchemaChild(dbDataSource, (BasicSchema)parent2, (BasicElement)node, viewOptions) : null;
            }
        } else {
            basicNode = basicNode2 instanceof AuxiliaryFamilyGroup ? ((AuxiliaryFamilyGroup)node).getParentNode() : (basicNode2 instanceof DatabaseObjectsGroup ? (DatabaseViewTreeFun.getDbCollapsed(dbDataSource) ? (BasicNode)dsn : (BasicNode)((DatabaseObjectsGroup)node).host) : (basicNode2 instanceof ServerObjectsGroup ? (BasicNode)dsn : (basicNode2 instanceof DatabaseStructure.FamilyGroup ? DatabaseViewTreeFun.findParentForRegularFamilyGroup((DatabaseStructure.FamilyGroup)node) : null)));
        }
        BasicNode parent3 = basicNode;
        return parent3;
    }

    private static final BasicNode findParentForSchemaChild(DbDataSource dbDataSource, BasicSchema schema, BasicElement element2, DatabaseViewOptions viewOptions) {
        BasicNode result2 = null;
        if (viewOptions.GROUP_SCHEMA) {
            DatabaseStructure.FamilyGroup familyGroup;
            DatabaseStructure.FamilyGroup familyGroup2 = familyGroup = DatabaseStructure.obtainFamilyGroup(dbDataSource, element2, element2.getKind(), schema, viewOptions);
            result2 = familyGroup2 != null ? (BasicNode)familyGroup2 : (BasicNode)schema;
        } else {
            result2 = schema;
        }
        return result2;
    }

    private static final BasicNode findParentForRegularFamilyGroup(DatabaseStructure.FamilyGroup familyGroup) {
        DasObject dasParent = familyGroup.dasParent;
        if (dasParent instanceof BasicSchema) {
            return (BasicNode)((Object)dasParent);
        }
        return null;
    }

    private static final void addFakeDatabaseLeaf(DataSourceNode dsn, Collection<BasicNode> result2) {
        DbDataSource dbDataSource = dsn.dbDataSource;
        DatabaseStructure.EmptyScopeLeaf leaf = (DatabaseStructure.EmptyScopeLeaf)DatabaseTreeKeys.FAKE_DATABASE_LEAF.get((UserDataHolder)dbDataSource);
        if (leaf == null) {
            BasicModel basicModel = dsn.getModel();
            if (basicModel == null) {
                return;
            }
            BasicModel model = basicModel;
            leaf = new DatabaseStructure.EmptyScopeLeaf(model.getRoot(), ObjectKind.DATABASE, dsn);
            DatabaseTreeKeys.FAKE_DATABASE_LEAF.set((UserDataHolder)dbDataSource, (Object)leaf);
        }
        result2.add(leaf);
    }

    private static final boolean getDbCollapsed(DbDataSource $this$dbCollapsed) {
        Object object = DatabaseTreeKeys.DATABASE_IS_COLLAPSED.get((UserDataHolder)$this$dbCollapsed, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DATABASE_IS_COLLAPSED[this, false]");
        return (Boolean)object;
    }

    @Nullable
    public static final TreePattern getIntrospectionScope(@NotNull DbDataSource $this$introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)$this$introspectionScope, (String)"$this$introspectionScope");
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource($this$introspectionScope);
        return localDataSource != null ? localDataSource.getIntrospectionScope() : null;
    }

    @Nullable
    public static final BasicModel getDbModel(@NotNull DbDataSource $this$dbModel) {
        Intrinsics.checkNotNullParameter((Object)$this$dbModel, (String)"$this$dbModel");
        DatabaseSystem databaseSystem = $this$dbModel.getDelegate();
        Intrinsics.checkNotNullExpressionValue((Object)databaseSystem, (String)"this.delegate");
        return DatabaseViewTreeFun.getDbModel(databaseSystem);
    }

    @Nullable
    public static final BasicModel getDbModel(@NotNull DasDataSource $this$dbModel) {
        Intrinsics.checkNotNullParameter((Object)$this$dbModel, (String)"$this$dbModel");
        DasModel dasModel = $this$dbModel.getModel();
        if (!(dasModel instanceof BasicModel)) {
            dasModel = null;
        }
        return (BasicModel)dasModel;
    }

    @Nullable
    public static final BasicRoot getDbRoot(@NotNull DbDataSource $this$dbRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$dbRoot, (String)"$this$dbRoot");
        BasicModel basicModel = DatabaseViewTreeFun.getDbModel($this$dbRoot);
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public static final BasicElement getModelElement(@NotNull DasObject $this$modelElement) {
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)$this$modelElement, (String)"$this$modelElement");
        DasObject dasObject = $this$modelElement;
        if (dasObject instanceof BasicElement) {
            basicElement = (BasicElement)$this$modelElement;
        } else if (dasObject instanceof DbDataSource) {
            BasicModel basicModel = DatabaseViewTreeFun.getDbModel((DbDataSource)$this$modelElement);
            basicElement = basicModel != null ? basicModel.getRoot() : null;
        } else if (dasObject instanceof DbElement) {
            Object object = ((DbElement)$this$modelElement).getDelegate();
            if (!(object instanceof BasicElement)) {
                object = null;
            }
            basicElement = (BasicElement)object;
        } else {
            basicElement = null;
        }
        return basicElement;
    }

    @Nullable
    public static final DbElement getDbWrapperFor(@NotNull Object node, @NotNull DvTreeStructureService structure) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Object object = node;
        return object instanceof BasicElement ? (node instanceof BasicRoot ? (DbElement)structure.findDbDataSource((DasObject)node) : structure.findDbElement((DasObject)node)) : (object instanceof DataSourceNode ? (DbElement)((DataSourceNode)node).dbDataSource : (object instanceof DbElement ? (DbElement)node : (object instanceof AbstractDataSource ? (DbElement)DbImplUtil.getDbDataSource(structure.getContext().project, (DasDataSource)node) : null)));
    }

    @Nullable
    public static final Collection<LocalDataSource> getSelectedLocalDataSourcesIfOnly(@NotNull DataContext $this$getSelectedLocalDataSourcesIfOnly) {
        Collection collection;
        Object[] selectedNodes;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedLocalDataSourcesIfOnly, (String)"$this$getSelectedLocalDataSourcesIfOnly");
        Object[] objectArray = selectedNodes = DatabaseContextFun.getSelectedNodesArray($this$getSelectedLocalDataSourcesIfOnly);
        boolean bl = false;
        if (objectArray.length == 0) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Object node : selectedNodes) {
            if (!(node instanceof DataSourceNode)) {
                return null;
            }
            AbstractDataSource ds = ((DataSourceNode)node).realDataSource;
            if (!(ds instanceof LocalDataSource)) {
                return null;
            }
            Collection collection2 = list;
            boolean bl2 = false;
            collection2.add(ds);
        }
        Collection collection3 = list;
        int n = 0;
        if (collection3.isEmpty()) {
            boolean bl3 = false;
            collection = null;
        } else {
            collection = collection3;
        }
        return collection;
    }

    public static final boolean isSelectedOneGroup(@NotNull DataContext $this$isSelectedOneGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$isSelectedOneGroup, (String)"$this$isSelectedOneGroup");
        Object[] selectedNodes = DatabaseContextFun.getSelectedNodesArray($this$isSelectedOneGroup);
        if (selectedNodes.length != 1) {
            return false;
        }
        Object selectedNode = selectedNodes[0];
        return selectedNode instanceof DatabaseStructure.DbGroup;
    }

    @Nullable
    public static final AbstractDataSource unwrap(@NotNull DasDataSource $this$unwrap) {
        AbstractDataSource abstractDataSource;
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"$this$unwrap");
        DasDataSource dasDataSource = $this$unwrap;
        if (dasDataSource instanceof AbstractDataSource) {
            abstractDataSource = (AbstractDataSource)$this$unwrap;
        } else if (dasDataSource instanceof DbDataSource) {
            DatabaseSystem databaseSystem = ((DbDataSource)$this$unwrap).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)databaseSystem, (String)"delegate");
            abstractDataSource = DatabaseViewTreeFun.unwrap(databaseSystem);
        } else {
            abstractDataSource = null;
        }
        return abstractDataSource;
    }

    private static final /* synthetic */ <T> Collection<T> allAre(Collection<? extends Object> $this$allAre) {
        int $i$f$allAre = 0;
        int n = $this$allAre.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                Object x = CollectionsKt.first((Iterable)$this$allAre);
                Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                return x instanceof Object ? (Collection)Collections.singleton(x) : null;
            }
        }
        ArrayList result2 = new ArrayList(n);
        for (Object object : $this$allAre) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (object instanceof Object) {
                Collection collection = result2;
                boolean bl = false;
                collection.add(object);
                continue;
            }
            return null;
        }
        return result2;
    }
}

