/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNavigationUtils {
    public static boolean isLegacyNavigateToCodeFromTree() {
        return Registry.is((String)"database.legacy.navigate.to.code.from.tree", (boolean)false);
    }

    public static boolean canNavigateToData(DbElement element2) {
        DbElement adjusted = DbNavigationUtils.adjustForDataNavigation(element2);
        return DatabaseEditorHelper.isTableDataAvailable(adjusted);
    }

    public static void navigateToData(DbElement element2, boolean requestFocus) {
        DbNavigationUtils.navigateToData(element2, requestFocus, null, null);
    }

    public static void navigateToData(DbElement element2, boolean requestFocus, String @Nullable [] columnNames, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> whereCondition) {
        VirtualFile virtualFile;
        DbElement adjusted;
        if (columnNames == null && element2.getKind() == ObjectKind.COLUMN) {
            columnNames = new String[]{element2.getName()};
        }
        if (DatabaseEditorHelper.isTableDataAvailable(adjusted = DbNavigationUtils.adjustForDataNavigation(element2)) && (virtualFile = DbImplUtil.findDataVirtualFile(adjusted, false)) != null) {
            new OpenDataFileDescriptor(element2.getProject(), virtualFile, columnNames, null, null, whereCondition).navigate(requestFocus);
        }
    }

    @NotNull
    public static DbElement adjustForDataNavigation(DbElement element2) {
        DbElement adjusted = DbTargetUtil.adjustForNavigation(element2);
        if (adjusted instanceof DbSynonymImpl) {
            adjusted = (DbElement)ObjectUtils.notNull((Object)((DbSynonymImpl)adjusted).resolveTarget(), (Object)adjusted);
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(0);
        }
        return dbElement;
    }

    @NotNull
    public static NavigationItem createToDatabaseViewNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(1);
        }
        return new MyNavigationWrapper(element2){

            public void navigate(boolean requestFocus) {
                DbNavigationUtils.navigateToDatabaseView(this.myElement, requestFocus);
            }
        };
    }

    @NotNull
    public static NavigationItem createToDataOrSourceNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(2);
        }
        if (DbNavigationUtils.canNavigateToData(element2)) {
            return DbNavigationUtils.createToDataNavigatable(element2);
        }
        return DbNavigationUtils.createToSourceNavigatable(element2);
    }

    @NotNull
    public static MyNavigationWrapper createToDataNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(3);
        }
        return new DbToDataNavWrapper(element2);
    }

    @NotNull
    public static NavigationItem createToDataSourceFileNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(4);
        }
        return new DbToDsFileNavWrapper(element2);
    }

    @NotNull
    public static NavigationItem createToSourceNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(5);
        }
        if (!DbNavigationUtils.canNavigateToData(element2)) {
            DbElement dbElement = element2;
            if (dbElement == null) {
                DbNavigationUtils.$$$reportNull$$$0(6);
            }
            return dbElement;
        }
        return new DbToSrcNavWrapper(element2);
    }

    @NotNull
    public static NavigationItem createFromTreeNavigatable(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(7);
        }
        if (DbNavigationUtils.isLegacyNavigateToCodeFromTree()) {
            if (DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
                return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
            }
            return DbNavigationUtils.createToSourceNavigatable(element2);
        }
        if (DbNavigationUtils.canNavigateToData(element2)) {
            return DbNavigationUtils.createToDataNavigatable(element2);
        }
        if (DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
            return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
        }
        return DbNavigationUtils.createToSourceNavigatable(element2);
    }

    public static PsiElement unwrapNavWrapper(@Nullable Navigatable element2) {
        return element2 instanceof PsiElementNavigationItem ? ((PsiElementNavigationItem)element2).getTargetElement() : (PsiElement)ObjectUtils.tryCast((Object)element2, PsiElement.class);
    }

    @Contract(value="null->null")
    public static DbElement extractDbElement(@Nullable Navigatable navigatable) {
        return (DbElement)ObjectUtils.tryCast((Object)DbNavigationUtils.unwrapNavWrapper(navigatable), DbElement.class);
    }

    public static boolean isToSourceNavigatable(@Nullable Navigatable navigatable) {
        return navigatable instanceof DbToSrcNavWrapper;
    }

    public static void navigateToDatabaseView(@NotNull DbElement element2, boolean requestFocus) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(8);
        }
        DatabaseView.select(element2.getProject(), Collections.singleton(element2), requestFocus, true);
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(9);
        }
        if (DbNavigationUtils.navigateToSqlElement(dbElement, requestFocus)) {
            return;
        }
        VirtualFile file = DbTargetUtil.getContainingFile(dbElement, true);
        if (file != null) {
            Project project = dbElement.getProject();
            Runnable runnable = () -> {
                int offset = DbTargetUtil.calcTargetOffset(project, file, dbElement);
                PsiNavigationSupport.getInstance().createNavigatable(project, file, offset).navigate(requestFocus);
            };
            DatabaseElementVirtualFileImpl vf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class));
            if (vf != null && DatabaseEditorHelper.needsReload(vf)) {
                DatabaseEditorHelper.reloadIfNeeded(project, (DatabaseElementVirtualFileImpl)file).onSuccess(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
                PsiNavigationSupport.getInstance().createNavigatable(project, file, 0).navigate(requestFocus);
            } else {
                runnable.run();
            }
        } else {
            DbNavigationUtils.navigateToDatabaseView(dbElement, requestFocus);
        }
    }

    public static boolean canNavigateToDataSourceFile(@NotNull DbElement element2) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(10);
        }
        return element2 instanceof DbDataSource || element2 instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource(element2.getDataSource()) != null;
    }

    public static void navigateToDataSourceFile(@NotNull DbElement element2, boolean requestFocus) {
        if (element2 == null) {
            DbNavigationUtils.$$$reportNull$$$0(11);
        }
        if (element2 instanceof DbDataSource) {
            VirtualFile virtualFile;
            DatabaseSystem delegate = ((DbDataSource)element2).getDelegate();
            if (delegate instanceof SqlDataSource) {
                virtualFile = (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getRoots());
            } else {
                virtualFile = DatabaseEditorHelper.findExistingConsoleVirtualFile(delegate);
                if (virtualFile == null) {
                    virtualFile = DatabaseEditorHelper.getConsoleVirtualFile(delegate);
                }
            }
            if (virtualFile != null) {
                PsiNavigationSupport.getInstance().createNavigatable(element2.getProject(), virtualFile, -1).navigate(requestFocus);
            } else {
                String message2 = delegate instanceof SqlDataSource ? DatabaseBundle.message("dialog.message.no.source.for.ddl.data.source", new Object[0]) : DatabaseBundle.message("dialog.message.no.console.for.data.source", new Object[0]);
                CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), null, (String)message2, (String)DatabaseBundle.message("dialog.title.unable.to.navigate", new Object[0]), null);
            }
        } else if (element2 instanceof DasNamespace && DbImplUtil.getMaybeLocalDataSource(element2.getDataSource()) != null) {
            DbDataSource dataSource2 = element2.getDataSource();
            VirtualFile virtualFile = DatabaseEditorHelper.getConsoleVirtualFile(dataSource2.getDelegate());
            if (virtualFile != null) {
                DatabaseEditorHelper.openConsoleForFile(element2.getProject(), dataSource2, (DasNamespace)element2.getDelegate(), virtualFile);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), null, (String)DatabaseBundle.message("dialog.message.no.console.for.data.source", new Object[0]), (String)DatabaseBundle.message("dialog.title.unable.to.navigate", new Object[0]), null);
            }
        }
    }

    private static boolean navigateToSqlElement(@NotNull DbElement dbElement, boolean requestFocus) {
        Navigatable descriptor2;
        if (dbElement == null) {
            DbNavigationUtils.$$$reportNull$$$0(12);
        }
        if (!DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        DasObject source = DbSqlUtil.getSqlSourceElement(dbElement);
        PsiElement psi = source instanceof PsiElement ? (PsiElement)source : (source instanceof DasSymbol ? ((DasSymbol)((Object)source)).getNavigationElement() : null);
        Navigatable navigatable = descriptor2 = psi == null ? null : PsiNavigationSupport.getInstance().getDescriptor(psi);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)dbElement.getProject(), null, (String)DatabaseBundle.message("dialog.message.no.code.for.item", new Object[0]), (String)DatabaseBundle.message("dialog.title.unable.to.navigate", new Object[0]), null);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForDataNavigation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNavigationUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToSourceNavigatable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToDatabaseViewNavigatable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToDataOrSourceNavigatable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToDataNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToDataSourceFileNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToSourceNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFromTreeNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDatabaseView";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateToDataSourceFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSourceFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSqlElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DbToSrcNavWrapper
    extends MyNavigationWrapper {
        DbToSrcNavWrapper(@NotNull DbElement element2) {
            if (element2 == null) {
                DbToSrcNavWrapper.$$$reportNull$$$0(0);
            }
            super(element2);
        }

        public void navigate(boolean requestFocus) {
            this.myElement.navigate(requestFocus);
        }

        @Override
        public String getPresentableText() {
            return super.getPresentableText() + (DbNavigationUtils.canNavigateToData(this.myElement) ? " (DDL)" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToSrcNavWrapper", "<init>"));
        }
    }

    private static class DbToDsFileNavWrapper
    extends MyNavigationWrapper {
        DbToDsFileNavWrapper(@NotNull DbElement element2) {
            if (element2 == null) {
                DbToDsFileNavWrapper.$$$reportNull$$$0(0);
            }
            super(element2);
        }

        public void navigate(boolean requestFocus) {
            DbNavigationUtils.navigateToDataSourceFile(this.myElement, requestFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToDsFileNavWrapper", "<init>"));
        }
    }

    private static class DbToDataNavWrapper
    extends MyNavigationWrapper {
        DbToDataNavWrapper(@NotNull DbElement element2) {
            if (element2 == null) {
                DbToDataNavWrapper.$$$reportNull$$$0(0);
            }
            super(element2);
        }

        public void navigate(boolean requestFocus) {
            DbNavigationUtils.navigateToData(this.myElement, requestFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$DbToDataNavWrapper", "<init>"));
        }
    }

    protected static abstract class MyNavigationWrapper
    implements PsiElementNavigationItem,
    ItemPresentation {
        @NotNull
        protected final DbElementImpl<?, ?> myElement;

        public MyNavigationWrapper(@NotNull DbElement element2) {
            if (element2 == null) {
                MyNavigationWrapper.$$$reportNull$$$0(0);
            }
            this.myElement = (DbElementImpl)element2;
        }

        @Nullable
        public PsiElement getTargetElement() {
            return this.myElement;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public String getName() {
            return this.myElement.getName();
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass() && this.myElement.isEquivalentTo(((MyNavigationWrapper)obj).myElement);
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.myElement.getIcon(open);
        }

        public String getPresentableText() {
            return this.myElement.getPresentableText();
        }

        @NlsSafe
        @Nullable
        public String getLocationString() {
            return this.myElement.getLocationString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNavigationUtils$MyNavigationWrapper", "<init>"));
        }
    }
}

