/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DatabaseEditorBaseEx
extends DatabaseEditorBase {
    private final EventDispatcher<EditorModelBase.Listener> myDispatcher;
    protected final Alarm myAlarm;
    private static final Set<Alarm> ALARMS = new HashSet<Alarm>();

    public DatabaseEditorBaseEx(@NotNull DatabaseEditorState state) {
        if (state == null) {
            DatabaseEditorBaseEx.$$$reportNull$$$0(0);
        }
        super(state);
        this.myDispatcher = EventDispatcher.create(EditorModelBase.Listener.class);
        this.myAlarm = new Alarm((Disposable)this);
        ALARMS.add(this.myAlarm);
    }

    @Override
    public void dispose() {
        super.dispose();
        ALARMS.remove(this.myAlarm);
    }

    protected void runLater(@NotNull Runnable r) {
        if (r == null) {
            DatabaseEditorBaseEx.$$$reportNull$$$0(1);
        }
        ModalityState state = ModalityState.defaultModalityState();
        Runnable newRunnable = r;
        if (state == ModalityState.NON_MODAL) {
            newRunnable = () -> ApplicationManager.getApplication().invokeLater(r);
            state = ModalityState.any();
        }
        this.myAlarm.addRequest(newRunnable, 1, state);
    }

    protected void fromModelToUi() {
        this.markInvalid();
        this.runLater(() -> {
            try {
                this.updateFromModel();
            }
            finally {
                this.markValid();
            }
            ((EditorModelBase.Listener)this.myDispatcher.getMulticaster()).changed();
        });
    }

    public void addListener(@NotNull EditorModelBase.Listener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            DatabaseEditorBaseEx.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            DatabaseEditorBaseEx.$$$reportNull$$$0(3);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent2);
    }

    @TestOnly
    public static void flushDelayed() {
        HashSet<Alarm> visited = new HashSet<Alarm>();
        while (true) {
            Alarm item = null;
            for (Alarm alarm2 : ALARMS) {
                if (visited.contains(alarm2)) continue;
                item = alarm2;
                visited.add(item);
                break;
            }
            if (item == null) break;
            item.drainRequestsInTest();
        }
    }

    @Nullable
    public DeObject getKeyObject() {
        EditorModelBase model = this.getModel();
        return model instanceof ObjectEditorModel ? (DeObject)((ObjectEditorModel)model).getObject() : null;
    }

    public static boolean isGood(@Nullable DeColumn object) {
        return !EditorModelUtil.isStub(object) && object.isInTable();
    }

    public abstract DatabaseEditorCapabilities.ObjectEditorCaps getCaps();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorBaseEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runLater";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

