/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseScriptDialog
extends DialogWrapper {
    protected final Project myProject;
    protected final DbDataSource mySource;
    protected final SearchPath mySearchPath;
    protected final SqlPreviewComponent myPreviewPanel;
    protected final ScriptOptionsPanel myOptionsPanel;
    protected final JBLoadingPanel loadingPanel;

    public DatabaseScriptDialog(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull @NlsContexts.DialogTitle String title) {
        if (project == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource2;
        this.mySearchPath = searchPath;
        this.myPreviewPanel = new SqlPreviewComponent(this.myProject, this.mySource, this.mySearchPath, "", false, () -> this.close(1)){

            @Override
            @NotNull
            public List<AnAction> createActions(@NotNull DbDataSource delegate) {
                if (delegate == null) {
                    1.$$$reportNull$$$0(0);
                }
                List list = ContainerUtil.concat(DatabaseScriptDialog.this.createPreviewActions(), super.createActions(delegate));
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createActions";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable(), 100);
        this.loadingPanel.add((Component)this.myPreviewPanel.getEditor());
        this.myOptionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            this.applyOptions();
            return Unit.INSTANCE;
        }));
        this.setTitle(title);
    }

    @NotNull
    protected List<AnAction> createPreviewActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected void init() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ScriptingTask task2 = this.getTask();
            this.myOptionsPanel.adjustOptionsUI(task2, task2.getOptions());
        }, ModalityState.any());
        super.init();
    }

    protected void applyOptions() {
        this.settingsChanged(this.appendCodeStyle(this.myOptionsPanel.gatherOptions()));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected abstract ScriptingTask getTask();

    public static JBPopup showSettingsPopup(ScriptingTask task2, Consumer<ScriptingOptions> callback) {
        Ref panel2 = Ref.create();
        panel2.set((Object)new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> {
            callback.accept(((ScriptOptionsPanel)panel2.get()).gatherOptions());
            return Unit.INSTANCE;
        })));
        ((ScriptOptionsPanel)panel2.get()).adjustOptionsUI(task2, task2.getOptions());
        JComponent component = ((ScriptOptionsPanel)panel2.get()).getComponent();
        UIUtil.addInsets((JComponent)component, (Insets)UIUtil.PANEL_REGULAR_INSETS);
        return JBPopupFactory.getInstance().createComponentPopupBuilder(component, component).setRequestFocus(true).createPopup();
    }

    public static AnAction createSettingsPopupAction(final Supplier<? extends ScriptingTask> task2, final Consumer<ScriptingOptions> callback) {
        return new ActionGroup(DatabaseBundle.messagePointer("action.DatabaseScriptDialog.settings.text", new Object[0]), Presentation.NULL_STRING, AllIcons.General.GearPlain){
            {
                super(arg0, arg1, arg2);
                this.setPopup(true);
            }

            public boolean isDumbAware() {
                return true;
            }

            public boolean canBePerformed(@NotNull DataContext context) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean disableIfNoVisibleChildren() {
                return false;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                JBPopup popup2 = DatabaseScriptDialog.showSettingsPopup((ScriptingTask)task2.get(), callback);
                DbUIUtil.showPopup(popup2, null, e);
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (AnAction.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canBePerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected ScriptingOptions appendCodeStyle(ScriptingOptions op) {
        SqlCodeStyleSettings style = ScriptingTaskBuilderKt.getSqlCodeStyle(this.mySource);
        DelegateScriptingOptions res2 = new DelegateScriptingOptions(op);
        res2.getOptions().put(ScriptingOptionStatic.CODE_STYLE, style);
        return res2;
    }

    protected abstract void settingsChanged(ScriptingOptions var1);

    @Nullable
    protected JComponent createCenterPanel() {
        ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message("separator.preview", new Object[0]), this.createTopComponent(), (JComponent)this.loadingPanel, this.getDimensionServiceKey());
        splitter.setTrailWidget(this.myPreviewPanel.createToolbar());
        return splitter;
    }

    @NotNull
    protected JComponent createTopComponent() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myOptionsPanel.getComponent(), (boolean)true);
        pane.setMinimumSize((Dimension)JBUI.size((int)100, (int)100));
        JScrollPane jScrollPane = pane;
        if (jScrollPane == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(5);
        }
        return jScrollPane;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    protected void doOKAction() {
        this.perform();
        super.doOKAction();
    }

    private void perform() {
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(this.mySource);
        if (lds != null) {
            this.runScript(lds);
            return;
        }
        SqlDataSource sqlDs2 = (SqlDataSource)ObjectUtils.tryCast((Object)this.mySource.getDelegate(), SqlDataSource.class);
        if (sqlDs2 != null) {
            this.updateSqlDataSource(sqlDs2);
        }
    }

    protected void updateSqlDataSource(SqlDataSource ds) {
        ScriptingSingleModelTaskBuilder builder = this.prepareCreationTask();
        Set<File> files2 = DumpToDdlDataSourceActionKt.dump(this.myProject, ds, builder.getModel(), null, builder.getElements(), false);
        DumpToDdlDataSourceActionKt.selectFile(this.myProject, files2);
    }

    @NotNull
    private ScriptingSingleModelTaskBuilder prepareCreationTask() {
        ScriptingSingleModelTaskBuilder builder;
        ScriptingTask task2 = this.getTask();
        if (task2 instanceof ScriptingSingleModelTask) {
            ScriptingSingleModelTask t = (ScriptingSingleModelTask)task2;
            builder = new ScriptingSingleModelTaskBuilder(t.getModel(), ScriptCategory.CREATE_COMPLETE);
            builder.setElements(t.getElements());
        } else {
            ScriptingAlterTask t = (ScriptingAlterTask)task2;
            builder = new ScriptingSingleModelTaskBuilder(t.getTargetModel(), ScriptCategory.CREATE_COMPLETE);
            JBIterable.from(t.getCorrespondence()).filterMap(ElementDelta::getTargetElement).addAllTo(builder.getElements());
        }
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = builder;
        if (scriptingSingleModelTaskBuilder == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(6);
        }
        return scriptingSingleModelTaskBuilder;
    }

    @NotNull
    public AsyncTask<?> runScript(@NotNull LocalDataSource localDataSource) {
        if (localDataSource == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(7);
        }
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.myProject, localDataSource, this.mySearchPath).setStatement(this.getStatement());
        this.fillContext(handler);
        AsyncTask<Boolean> asyncTask = handler.runStatements(false);
        if (asyncTask == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(8);
        }
        return asyncTask;
    }

    protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
        if (handler == null) {
            DatabaseScriptDialog.$$$reportNull$$$0(9);
        }
    }

    protected void updateText(ScriptingResult script) {
        this.updateText(script.getScriptText());
    }

    protected void updateText(String script) {
        this.myPreviewPanel.setQuery(script);
    }

    public void initAndShow() {
        this.init();
        this.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseScriptDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCreationTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runScript";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

