/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.builder.actions.layout.ApplyCurrentLayoutAction;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    @Override
    protected boolean isSelected(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> builder;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            AbstractLayoutAction.$$$reportNull$$$0(2);
        }
        if ((builder = this.getBuilder(event)) == null) {
            return false;
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter() == this.getLayouter(project, builder);
    }

    @Override
    protected void setSelected(@NotNull Graph2D graph, boolean state, @NotNull Project project, @NotNull AnActionEvent e) {
        GraphBuilder<?, ?> builder;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            AbstractLayoutAction.$$$reportNull$$$0(5);
        }
        if ((builder = this.getBuilder(e)) == null) {
            return;
        }
        Layouter layouter = this.getLayouter(project, builder);
        builder.getGraphPresentationModel().getSettings().setCurrentLayouter(layouter);
        this.beforeLayoutPerformed(layouter, builder);
        GraphLayoutService.getInstance().doPerformAnimatedLayout(builder, layouter);
        this.afterLayoutPerformed(layouter, builder);
    }

    @Override
    @Nullable
    @NlsActions.ActionText
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(6);
        }
        return this.getLayoutName();
    }

    @Override
    protected boolean isEnabled(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> builder;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(8);
        }
        if (event == null) {
            AbstractLayoutAction.$$$reportNull$$$0(9);
        }
        return (builder = this.getBuilder(event)) != null && !ApplyCurrentLayoutAction.areNodesMovingByUserNow(builder) && graph.nodeCount() > 0 && this.getLayouter(project, builder).canLayout(graph);
    }

    protected abstract Layouter getLayouter(Project var1, @NotNull GraphBuilder<?, ?> var2);

    @NlsActions.ActionText
    protected abstract String getLayoutName();

    protected boolean areBridgesPreferred() {
        return true;
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            AbstractLayoutAction.$$$reportNull$$$0(11);
        }
        GraphLayoutService.getInstance().beforeLayoutPerformed(builder, layouter);
        builder.getGraphPresentationModel().getSettings().setShowBridges(this.areBridgesPreferred());
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            AbstractLayoutAction.$$$reportNull$$$0(13);
        }
        GraphLayoutService.getInstance().afterLayoutPerformed(builder, layouter, true);
        builder.getEditMode().setOrthogonalEdgeRouting(GraphLayoutService.getInstance().doesImplyOrthogonalEdgeRouting(layouter));
        builder.updateView();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeLayoutPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "afterLayoutPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

