/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.ide.IconProvider;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NodeModulesDirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            NodeModulesDirectoryIconProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            Project project = psiDirectory.getProject();
            VirtualFile dir = psiDirectory.getVirtualFile();
            boolean excluded = ProjectFileIndex.getInstance((Project)project).isExcluded(dir);
            if (excluded && dir.isDirectory() && NodeModulesDirectoryIconProvider.shouldShowNotExcludedIcon(project, dir)) {
                return PlatformIcons.FOLDER_ICON;
            }
        }
        return null;
    }

    private static boolean shouldShowNotExcludedIcon(@NotNull Project project, @NotNull VirtualFile dir) {
        PackageJsonData data;
        VirtualFile packageJson;
        VirtualFile nodeModulesDir;
        if (project == null) {
            NodeModulesDirectoryIconProvider.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            NodeModulesDirectoryIconProvider.$$$reportNull$$$0(2);
        }
        if (NodeModulesDirectoryIconProvider.isNodeModulesDirWithMappings(project, dir)) {
            return true;
        }
        return NodeModuleSearchUtil.isScopeDir(dir) && NodeModulesDirectoryIconProvider.isNodeModulesDirWithMappings(project, nodeModulesDir = dir.getParent()) && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir)) != null && (data = PackageJsonData.getOrCreate(packageJson)).containsDependencyWithScope(dir.getName());
    }

    private static boolean isNodeModulesDirWithMappings(@NotNull Project project, @NotNull VirtualFile nodeModulesDir) {
        if (project == null) {
            NodeModulesDirectoryIconProvider.$$$reportNull$$$0(3);
        }
        if (nodeModulesDir == null) {
            NodeModulesDirectoryIconProvider.$$$reportNull$$$0(4);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(nodeModulesDir)) {
            return NodeModulesDirectoryManager.getInstance(project).isNodeModulesLibraryDirWithMappings(nodeModulesDir);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesDirectoryIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowNotExcludedIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeModulesDirWithMappings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

