/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspaceList;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    private static final Logger LOG = Logger.getInstance(YarnPnpSyntheticLibraryProvider.class);
    private final RecursionGuard<YarnPnpSyntheticLibraryProvider> myRecursionGuard = RecursionManager.createGuard((String)((Object)((Object)this)).getClass().getName());

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        List<YarnPnpFile> pnpFiles;
        List<YarnPnpSyntheticLibrary> libraries;
        if (project == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(0);
        }
        if ((libraries = YarnPnpSyntheticLibraryProvider.collectLibraries(pnpFiles = YarnPnpManager.getInstance(project).getPnpFiles())).isEmpty()) {
            List<SyntheticLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List list3 = ContainerUtil.notNullize((List)((List)this.computeFileIndexExtensionPreventingRecursion(() -> {
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            return ContainerUtil.mapNotNull((Collection)libraries, library -> !mappings.getMappingsByLibraryName(library.getLibraryName()).isEmpty() ? library : null);
        })));
        if (list3 == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    static List<YarnPnpSyntheticLibrary> collectLibraries(@NotNull List<YarnPnpFile> pnpFiles) {
        if (pnpFiles == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(3);
        }
        if (pnpFiles.isEmpty()) {
            List<YarnPnpSyntheticLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<YarnPnpSyntheticLibrary> result2 = new ArrayList<YarnPnpSyntheticLibrary>(pnpFiles.size());
        for (YarnPnpFile pnpFile : pnpFiles) {
            YarnPnpWorkspaceList workspaceList = pnpFile.getWorkspaceList();
            if (workspaceList == null) continue;
            for (YarnPnpWorkspace workspace : workspaceList.getWorkspaces()) {
                ContainerUtil.addIfNotNull(result2, (Object)((Object)workspace.createLibrary(pnpFile)));
            }
        }
        ArrayList<YarnPnpSyntheticLibrary> arrayList = result2;
        if (arrayList == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private <T> T computeFileIndexExtensionPreventingRecursion(@NotNull Computable<T> computation) {
        Object result2;
        if (computation == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(6);
        }
        if ((result2 = this.myRecursionGuard.doPreventingRecursion((Object)this, false, computation)) == null) {
            LOG.error(new Throwable("Recursion prevented when computing FileIndex extension"));
        }
        return (T)result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpSyntheticLibraryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpSyntheticLibraryProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectLibraries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIndexExtensionPreventingRecursion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

