/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpSyntheticLibrary;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        YarnPnpSyntheticLibrary syntheticLibrary;
        if (parent == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (parent instanceof SyntheticLibraryElementNode && (syntheticLibrary = (YarnPnpSyntheticLibrary)((Object)ObjectUtils.tryCast((Object)parent.getValue(), YarnPnpSyntheticLibrary.class))) != null) {
            return YarnPnpTreeStructureProvider.findChildren(syntheticLibrary, children);
        }
        Collection<AbstractTreeNode<?>> collection = children;
        if (collection == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> findChildren(@NotNull YarnPnpSyntheticLibrary library, @NotNull Collection<AbstractTreeNode<?>> children) {
        if (library == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if (children == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.map(children, child -> (AbstractTreeNode)ObjectUtils.notNull((Object)((Object)YarnPnpTreeStructureProvider.createDependencyNode(library, (PsiDirectoryNode)ObjectUtils.tryCast((Object)child, PsiDirectoryNode.class))), (Object)child));
        if (list2 == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private static YarnDependencyNode createDependencyNode(@NotNull YarnPnpSyntheticLibrary library, @Nullable PsiDirectoryNode node) {
        PsiDirectory directory;
        if (library == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (node instanceof YarnDependencyNode) {
            return (YarnDependencyNode)node;
        }
        PsiDirectory psiDirectory = directory = node != null ? (PsiDirectory)node.getValue() : null;
        if (directory != null) {
            return new YarnDependencyNode(library, node, directory);
        }
        return null;
    }

    @NotNull
    private static String calcDependencyName(@NotNull PsiDirectory dependencyRoot) {
        PsiDirectory parentDirectory;
        String parentDirectoryName;
        if (dependencyRoot == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(7);
        }
        String string = parentDirectoryName = (parentDirectory = dependencyRoot.getParent()) != null ? parentDirectory.getName() : null;
        if (parentDirectoryName != null && NodeModuleSearchUtil.isScopeDirName(parentDirectoryName)) {
            String string2 = parentDirectoryName + "/" + dependencyRoot.getName();
            if (string2 == null) {
                YarnPnpTreeStructureProvider.$$$reportNull$$$0(8);
            }
            return string2;
        }
        String string3 = dependencyRoot.getName();
        if (string3 == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(9);
        }
        return string3;
    }

    @Nullable
    private static SemVer parseVersion(@NotNull PsiDirectory dependencyRoot) {
        VirtualFile packageJson;
        if (dependencyRoot == null) {
            YarnPnpTreeStructureProvider.$$$reportNull$$$0(10);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(dependencyRoot.getVirtualFile())) == null) {
            return null;
        }
        return PackageJsonData.getOrCreate(packageJson).getVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpTreeStructureProvider";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpTreeStructureProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildren";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDependencyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDependencyNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcDependencyName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class YarnDependencyNode
    extends PsiDirectoryNode {
        private final String myDependencyName;
        private final boolean myInsideArchive;
        private final SemVer myVersion;
        private final YarnPnpSyntheticLibrary myLibrary;

        private YarnDependencyNode(@NotNull YarnPnpSyntheticLibrary library, @NotNull PsiDirectoryNode original, @NotNull PsiDirectory dependencyRoot) {
            if (library == null) {
                YarnDependencyNode.$$$reportNull$$$0(0);
            }
            if (original == null) {
                YarnDependencyNode.$$$reportNull$$$0(1);
            }
            if (dependencyRoot == null) {
                YarnDependencyNode.$$$reportNull$$$0(2);
            }
            super(original.getProject(), dependencyRoot, original.getSettings());
            this.myLibrary = library;
            this.myDependencyName = YarnPnpTreeStructureProvider.calcDependencyName(dependencyRoot);
            this.myInsideArchive = JarFileSystem.getInstance().getRootByEntry(dependencyRoot.getVirtualFile()) != null;
            this.myVersion = YarnPnpTreeStructureProvider.parseVersion(dependencyRoot);
        }

        protected void updateImpl(@NotNull PresentationData data) {
            if (data == null) {
                YarnDependencyNode.$$$reportNull$$$0(3);
            }
            data.setPresentableText(this.myDependencyName);
            data.setLocationString(this.myVersion != null ? this.myVersion.getRawVersion() : null);
            if (this.myInsideArchive) {
                data.setIcon(AllIcons.Nodes.JarDirectory);
            } else {
                this.setupIcon(data, Objects.requireNonNull((PsiDirectory)this.getValue()));
            }
        }

        @NotNull
        public String toTestString(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Queryable.PrintInfo printInfo) {
            String version = this.myVersion != null ? this.myVersion.getRawVersion() : null;
            String string = this.myDependencyName + (String)(version != null ? " " + version : "");
            if (string == null) {
                YarnDependencyNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void navigate(boolean requestFocus) {
            JsonProperty dependency = this.findDeclaredDependency();
            if (dependency != null) {
                new OpenFileDescriptor(dependency.getProject(), Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)dependency)), dependency.getTextOffset() + 1).navigate(requestFocus);
            }
        }

        @Nullable
        private JsonProperty findDeclaredDependency() {
            Project project;
            PsiFile file2;
            VirtualFile packageJson = this.myLibrary.getWorkspace().findPackageJson();
            if (packageJson != null && (file2 = PsiManager.getInstance((Project)(project = this.myLibrary.getPnpFile().getProject())).findFile(packageJson)) instanceof JsonFile) {
                return PackageJsonUtil.findDependencyByName((JsonFile)file2, this.myDependencyName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyRoot";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpTreeStructureProvider$YarnDependencyNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpTreeStructureProvider$YarnDependencyNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toTestString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateImpl";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

