/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class JestTestNamePatternUtil {
    private static final List<String> JEST_NAME_PARAMETERS = Arrays.asList("%p", "%s", "%d", "%i", "%f", "%j", "%o", "%#", "%%");
    private static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\$\\S+");

    @NotNull
    public static JSTestNamePattern parseTableEachPattern(@NotNull String name) {
        if (name == null) {
            JestTestNamePatternUtil.$$$reportNull$$$0(0);
        }
        ArrayList<JSTestNamePattern.Range> ranges = new ArrayList<JSTestNamePattern.Range>();
        int ind = 0;
        while (ind < name.length()) {
            String closestParam = null;
            int closestParamInd = -1;
            for (String param : JEST_NAME_PARAMETERS) {
                int paramInd = name.indexOf(param, ind);
                if (paramInd == -1 || closestParam != null && paramInd >= closestParamInd) continue;
                closestParam = param;
                closestParamInd = paramInd;
            }
            if (closestParam == null) {
                ranges.add(new JSTestNamePattern.Literal(name.substring(ind)));
                ind = name.length();
                continue;
            }
            if (ind < closestParamInd) {
                ranges.add(new JSTestNamePattern.Literal(name.substring(ind, closestParamInd)));
            }
            ranges.add(new JSTestNamePattern.AnyText(closestParam));
            ind = closestParamInd + closestParam.length();
        }
        return new JSTestNamePattern(ranges);
    }

    @NotNull
    public static JSTestNamePattern parseTemplateEachPattern(String name) {
        ArrayList<JSTestNamePattern.Range> ranges = new ArrayList<JSTestNamePattern.Range>();
        Matcher matcher = TEMPLATE_PARAM_PATTERN.matcher(name);
        int ind = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (ind < start) {
                ranges.add(new JSTestNamePattern.Literal(name.substring(ind, start)));
            }
            ranges.add(new JSTestNamePattern.AnyText(matcher.group()));
            ind = matcher.end();
        }
        if (ind < name.length()) {
            ranges.add(new JSTestNamePattern.Literal(name.substring(ind)));
        }
        return new JSTestNamePattern(ranges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/jasmine/JestTestNamePatternUtil", "parseTableEachPattern"));
    }
}

