/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportSpecifierImpl
extends ES6ImportExportSpecifierBase<ES6ImportSpecifierStub>
implements ES6ImportSpecifier,
BindablePsiReference,
HighlightSeverityHolder {
    public ES6ImportSpecifierImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportSpecifierImpl(ES6ImportSpecifierStub stub) {
        super(stub, ES6ElementTypes.IMPORT_SPECIFIER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitImportSpecifier(this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(3);
        }
        ES6ImportSpecifierAlias alias = this.getAlias();
        if (place == this) {
            return true;
        }
        return alias != null ? alias.processDeclarations(processor, state2, lastParent, place) : processor.execute((PsiElement)this, state2);
    }

    @Override
    @Nullable
    public ES6ImportSpecifierAlias getAlias() {
        return (ES6ImportSpecifierAlias)this.getStubOrPsiChild(ES6ElementTypes.IMPORT_SPECIFIER_ALIAS);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (specifier, incompleteCode1) -> ES6ImportSpecifierImpl.resolveImportSpecifier(specifier), true, incompleteCode);
        if (resolveResultArray == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Override
    public String getName() {
        return this.getAlias() != null ? null : this.getDeclaredName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameIdentifier;
        if (name == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(5);
        }
        if ((nameIdentifier = this.getReferenceElement()) != null) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)this);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createNameIdentifier(this.getProject(), name, dialect));
        }
        return this;
    }

    private static ResolveResult @NotNull [] resolveImportSpecifier(@NotNull ES6ImportSpecifier specifier) {
        String name;
        if (specifier == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(6);
        }
        if ((name = specifier.getReferenceName()) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6ImportSpecifierImpl.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = ES6PsiUtil.resolveSymbolForSpecifier(specifier, false);
        if (resolveResultArray == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    @Override
    @Nullable
    public ES6ImportDeclaration getDeclaration() {
        return (ES6ImportDeclaration)super.getDeclaration();
    }

    public void delete() throws IncorrectOperationException {
        ES6ImportDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            super.delete();
            return;
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        if (specifiers.length == 1) {
            if (bindings.length == 0) {
                declaration.delete();
            } else {
                ASTNode namedImports = declaration.getNode().findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
                assert (namedImports != null);
                ES6ImportSpecifierImpl.deleteSpecifierAndKeepBinding(declaration.getNode(), namedImports);
            }
        } else {
            assert (specifiers.length > 1);
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)this, (PsiElement[])specifiers);
        }
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.IMPORT_ICON;
    }

    public static void deleteSpecifierAndKeepBinding(@NotNull ASTNode holder, ASTNode toDelete) {
        ASTNode startRange;
        if (holder == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(9);
        }
        holder.removeRange((startRange = holder.findChildByType(JSTokenTypes.COMMA)) == null ? toDelete : startRange, toDelete.getTreeNext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportSpecifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportSpecifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteSpecifierAndKeepBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

