/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderMethodInfo
extends JSDocBuilderSymbolInfo {
    public static final int OVERLOADS_LIMIT = 5;
    final Map<JSParameterItem, JSDocBuilderParameterInfo> parameterInfoMap;
    final JSDocBuilderSimpleInfo returnInfo;
    final Set<JSDocBuilderSimpleInfo> throwsInfos;
    final List<JSDocBuilderSimpleInfo> firesInfos;
    @NotNull
    private final JSFunctionItem myFunctionItem;
    String methodType;
    int parameterCount;

    JSDocBuilderMethodInfo(@NotNull JSFunctionItem functionItem, PsiElement element, PsiElement _contextElement) {
        if (functionItem == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(0);
        }
        super(element, _contextElement, false);
        this.parameterInfoMap = new LinkedHashMap<JSParameterItem, JSDocBuilderParameterInfo>();
        this.returnInfo = new JSDocBuilderSimpleInfo();
        this.throwsInfos = new LinkedHashSet<JSDocBuilderSimpleInfo>();
        this.firesInfos = new SmartList();
        this.parameterCount = 0;
        this.myFunctionItem = functionItem;
        for (JSParameterItem parameter : functionItem.getParameters()) {
            JSDocBuilderParameterInfo paramInfo = new JSDocBuilderParameterInfo(parameter);
            paramInfo.context = functionItem;
            this.parameterInfoMap.put(parameter, paramInfo);
            JSExpression initializer = parameter instanceof JSInitializerOwner ? ((JSInitializerOwner)((Object)parameter)).getInitializer() : null;
            paramInfo.initialValue = initializer != null ? initializer.getText() : null;
        }
        this.returnInfo.type = JSFunctionImpl.getReturnTypeInContext(functionItem, null);
    }

    void mergeSignatureWith(@NotNull JSDocBuilderMethodInfo superMethodInfo) {
        if (superMethodInfo == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(1);
        }
        int index = 0;
        JSDocBuilderParameterInfo[] parameterInfosArray = superMethodInfo.parameterInfoMap.values().toArray(new JSDocBuilderParameterInfo[0]);
        for (Map.Entry<JSParameterItem, JSDocBuilderParameterInfo> entry : this.parameterInfoMap.entrySet()) {
            if (!entry.getValue().hasDescription()) {
                JSDocBuilderParameterInfo parameterInfo;
                JSDocBuilderParameterInfo info = superMethodInfo.parameterInfoMap.get(entry.getKey());
                if (info != null) {
                    parameterInfo = entry.getValue();
                    parameterInfo.mergeRawDescriptionAndPlaceHolders(info);
                } else if (index < parameterInfosArray.length) {
                    parameterInfo = entry.getValue();
                    JSDocBuilderParameterInfo fromParameter = parameterInfosArray[index];
                    parameterInfo.mergeRawDescriptionAndPlaceHolders(fromParameter);
                }
            }
            ++index;
        }
        if (!this.returnInfo.hasDescription()) {
            this.returnInfo.mergeRawDescriptionAndPlaceHolders(superMethodInfo.returnInfo);
        }
    }

    @Nullable
    JSDocBuilderParameterInfo getInfoForParameterName(@Nullable String name, @NotNull JSFunctionItem function2) {
        if (function2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(2);
        }
        JSParameterItem parameter = null;
        for (JSParameterItem item : function2.getParameterVariables()) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)item.getName())) continue;
            parameter = item;
        }
        JSDocBuilderParameterInfo parameterInfo = this.parameterInfoMap.get(parameter);
        if (parameterInfo != null) {
            return parameterInfo;
        }
        for (JSDocBuilderParameterInfo info : this.parameterInfoMap.values()) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)info.docName)) continue;
            return info;
        }
        return null;
    }

    @Override
    public void appendDoc(@NotNull StringBuilder builder, @NotNull JSDocumentationProvider provider) {
        if (builder == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(4);
        }
        super.appendDoc(builder, provider);
        if (!DialectDetector.isTypeScript((PsiElement)this.myFunctionItem)) {
            return;
        }
        Collection<? extends JSFunctionItem> signatures = provider.getOverloads(this.myFunctionItem);
        if (signatures.size() > 1) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            results.add((PsiElement)this.myFunctionItem);
            for (JSFunctionItem jSFunctionItem : signatures) {
                if (jSFunctionItem == this.myFunctionItem) continue;
                results.add((PsiElement)jSFunctionItem);
                if (results.size() <= 5) continue;
                break;
            }
            JSDocumentationProvider jSDocumentationProvider = provider;
            Objects.requireNonNull(jSDocumentationProvider);
            JSDocumentationProvider.LinkedDocCollector collector = new JSDocumentationProvider.LinkedDocCollector(jSDocumentationProvider, this.contextElement, (Pair<PsiElement, String>)new Pair((Object)this.myFunctionItem, (Object)""), results);
            builder.append("<div class='content'>");
            builder.append("<p>");
            builder.append(collector.getLinks());
            if (results.size() != signatures.size()) {
                int n = signatures.size() - results.size();
                String overloadsText = JavaScriptBundle.message(n == 1 ? "js.documentation.more.overload" : "js.documentation.more.overloads", n);
                builder.append(", <br> ").append(overloadsText);
            }
            builder.append("</div>");
        }
    }

    @Override
    protected void appendDefinitionDoc(@NotNull StringBuilder builder, @NotNull JSDocumentationProvider provider) {
        if (builder == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(6);
        }
        builder.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocBuilderMethodInfo.addJSDocVisibilityAndAccess(this, options);
        if (options.length() > 0) {
            builder.append((CharSequence)options).append("<br>");
        }
        JSQuickNavigateBuilder quickNavigateBuilder = provider.getQuickNavigateBuilder();
        builder.append(quickNavigateBuilder.getFunctionDefinitionWithHighlighting(this.myFunctionItem, this.parameterInfoMap.values(), this.returnInfo, (PsiElement)ObjectUtils.coalesce((Object)this.contextElement, (Object)this.myElement), true));
        builder.append("</pre></div>");
    }

    @Override
    protected void appendBodyDoc(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(7);
        }
        this.appendParameters(result2, hasDefinition);
        this.appendReturns(result2, hasDefinition);
        JSDocBuilderMethodInfo.appendNamedSectionAndElements(this.throwsInfos, CodeInsightBundle.message((String)"javadoc.throws", (Object[])new Object[0]), result2);
        JSDocBuilderMethodInfo.appendNamedSectionAndElements(this.firesInfos, JavaScriptBundle.message("js.documentation.fires", new Object[0]), result2);
    }

    public void appendReturns(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(8);
        }
        boolean hasJSDocReturnType = this.hasJSDocReturnType();
        if (this.returnInfo.hasDescription() || !hasDefinition && hasJSDocReturnType) {
            JSDocBuilderMethodInfo.startNamedSection(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]), result2);
            result2.append("<td valign='top'>");
            Object description2 = this.returnInfo.getFinalDescription();
            if (!hasDefinition && hasJSDocReturnType) {
                CharSequence returnTypeText = this.returnInfo.getTypeString(this.myElement);
                description2 = returnTypeText + (String)(((String)description2).length() != 0 ? " - " + (String)description2 : "");
            }
            JSDocBuilderMethodInfo.addDescription((String)description2, result2);
            result2.append("</td>");
        }
    }

    private boolean hasJSDocReturnType() {
        if (!this.returnInfo.hasType()) {
            return false;
        }
        if (!(this.myFunctionItem instanceof JSFunction)) {
            return true;
        }
        JSFunction item = (JSFunction)this.myFunctionItem;
        return item.hasExplicitlyDeclaredReturnType() && item.getReturnTypeElement() == null;
    }

    public void appendParameters(@NotNull StringBuilder result2, boolean hasDefinition) {
        if (result2 == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(9);
        }
        if (this.parameterInfoMap.size() > 0) {
            boolean hasParamDoc = false;
            StringBuilder parametersBuilder = new StringBuilder();
            JSDocBuilderMethodInfo.startNamedSection(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), parametersBuilder);
            parametersBuilder.append("<td valign='top'>");
            for (Map.Entry<JSParameterItem, JSDocBuilderParameterInfo> parameterInfoEntry : this.parameterInfoMap.entrySet()) {
                boolean hasJSDocType;
                JSDocBuilderParameterInfo parameterInfo = parameterInfoEntry.getValue();
                JSParameterItem item = parameterInfoEntry.getKey();
                Object description2 = parameterInfo.getDescriptionMergedWithConfigOptions();
                if (parameterInfo.defaultValue != null) {
                    description2 = (String)description2 + JSDocBuilderMethodInfo.buildCurrentOrDefaultValue(parameterInfo.defaultValue, false, true, null, false);
                }
                boolean bl = hasJSDocType = parameterInfo.hasType() && !parameterInfo.hasTypeElement();
                if (((String)description2).length() <= 0 && (hasDefinition || !hasJSDocType)) continue;
                hasParamDoc = true;
                parametersBuilder.append("<p>");
                Object name = item.getName();
                if (!hasDefinition && hasJSDocType) {
                    name = (String)name + ": " + parameterInfo.getTypeString(this.myElement);
                }
                JSDocBuilderMethodInfo.appendSingleNamedDescriptionSection((CharSequence)name, (CharSequence)description2, parametersBuilder);
            }
            parametersBuilder.append("</td>");
            if (hasParamDoc) {
                result2.append((CharSequence)parametersBuilder);
            }
        }
    }

    public static void appendNamedSectionAndElements(@NotNull Collection<? extends JSDocBuilderSimpleInfo> infos, @NotNull String sectionName, @NotNull StringBuilder builder) {
        if (infos == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(10);
        }
        if (sectionName == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            JSDocBuilderMethodInfo.$$$reportNull$$$0(12);
        }
        if (!infos.isEmpty()) {
            JSDocBuilderMethodInfo.startNamedSection(sectionName, builder);
            builder.append("<td valign='top'>");
            for (JSDocBuilderSimpleInfo jSDocBuilderSimpleInfo : infos) {
                builder.append("<p>");
                if (jSDocBuilderSimpleInfo.hasType()) {
                    JSDocBuilderMethodInfo.appendSingleNamedDescriptionSection(jSDocBuilderSimpleInfo.getTypeString(null), jSDocBuilderSimpleInfo.getFinalDescription(), builder);
                    continue;
                }
                builder.append(jSDocBuilderSimpleInfo.getFinalDescription());
            }
            builder.append("</td>");
        }
    }

    public void setReturnType(@Nullable JSType type) {
        if (this.myFunctionItem.isSetProperty()) {
            return;
        }
        this.returnInfo.type = type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderMethodInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeSignatureWith";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfoForParameterName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDoc";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendDefinitionDoc";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBodyDoc";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "appendReturns";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendNamedSectionAndElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

