/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.findUsages.JSQualifiedNameProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.xml.breadcrumbs.XmlLanguageBreadcrumbsInfoProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBreadcrumbsProvider
implements BreadcrumbsProvider {
    public Language[] getLanguages() {
        return new Language[]{JavascriptLanguage.INSTANCE, JavaScriptSupportLoader.TYPESCRIPT};
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof JSXmlLiteralExpression) {
            return true;
        }
        if (element instanceof JSSwitchStatement) {
            return true;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        if (element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getExpression() instanceof JSIndexedPropertyAccessExpression) {
            return false;
        }
        return !(element instanceof JSExpression) || (assignedTo = JSPsiImplUtils.getInitializedElement((JSExpression)element)) == null;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        JSExpression expression;
        JSExpression methodExpression;
        PsiElement callExpr;
        PsiElement parent;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof JSXmlLiteralExpression) {
            String string = XmlLanguageBreadcrumbsInfoProvider.getInfo((PsiElement)element);
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (element instanceof JSSwitchStatement) {
            JSExpression expression2 = ((JSSwitchStatement)element).getSwitchExpression();
            String expr = expression2 != null ? StringUtil.trimLog((String)expression2.getText(), (int)20) : "...";
            String string = "switch (" + expr + ")";
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && (parent = element.getParent()) instanceof JSArgumentList && (callExpr = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression) {
            String referenceText = StringUtil.trimMiddle((String)StringUtil.collapseWhiteSpace((CharSequence)methodExpression.getText()), (int)50);
            String string = JavaScriptBundle.message("js.breadcrumbs.callback.for", referenceText);
            if (string == null) {
                JSBreadcrumbsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        String name = null;
        if (!(!(element instanceof JSDefinitionExpression) || (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSThisExpression)) {
            name = ((JSDefinitionExpression)element).getQualifiedName();
        }
        if (name == null && element instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)element).getName();
        }
        if (name != null && (name.startsWith("[Symbol.") || name.indexOf(46) == -1)) {
            name = JSSymbolUtil.handleSpecialPropertyNames(name, '\"');
        }
        if (name == null) {
            name = JSFormatUtil.getAnonymousElementPresentation();
        }
        builder.append(name);
        if (element instanceof JSFunction || element instanceof JSInitializerOwner && ((JSInitializerOwner)element).getInitializer() instanceof JSFunction) {
            builder.append("()");
        }
        String string = builder.toString();
        if (string == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        return element instanceof JSXmlLiteralExpression ? XmlLanguageBreadcrumbsInfoProvider.getTooltip((XmlTag)((XmlTag)element)) : null;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element) {
        JSQualifiedNamedElement initializedElement;
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(7);
        }
        if (element instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)element)) instanceof JSDefinitionExpression) {
            return initializedElement;
        }
        return element.getParent();
    }

    @NotNull
    public List<? extends Action> getContextActions(final @NotNull PsiElement element) {
        if (element == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(8);
        }
        List<1> list2 = Collections.singletonList(new AbstractAction(JavaScriptBundle.message("js.copy.qualified.to.clipboard", new Object[0])){

            @NotNull
            private PsiElement evaluateElement(@NotNull PsiElement element2) {
                PsiElement resolved;
                PsiReference reference;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof JSXmlLiteralExpression && (reference = element2.getReference()) != null && (resolved = reference.resolve()) != null) {
                    PsiElement psiElement = resolved;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            @Override
            public boolean isEnabled() {
                return !DumbService.isDumb((Project)element.getProject()) && new JSQualifiedNameProvider().getQualifiedName(this.evaluateElement(element)) != null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String qualifiedName = new JSQualifiedNameProvider().getQualifiedName(this.evaluateElement(element));
                if (qualifiedName != null) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(qualifiedName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "evaluateElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "evaluateElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (list2 == null) {
            JSBreadcrumbsProvider.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editor/JSBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

