/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.flags;

import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class IntFlagsSerializer {
    public static IntFlagsSerializer INSTANCE = new IntFlagsSerializer();

    private IntFlagsSerializer() {
    }

    @Contract(pure=true)
    public <T> int writeValue(@NotNull FlagsStructure structure, @NotNull FlagsStructureElement<T> structureElement, T value, int flags) {
        if (structure == null) {
            IntFlagsSerializer.$$$reportNull$$$0(0);
        }
        if (structureElement == null) {
            IntFlagsSerializer.$$$reportNull$$$0(1);
        }
        int offset = 0;
        for (FlagsStructureElement element : structure.getElements()) {
            if (element == structureElement) {
                int intValue = structureElement.getValue(value);
                int mask = (1 << structureElement.size()) - 1 << offset;
                return flags & ~mask | (intValue <<= offset);
            }
            offset += element.size();
        }
        throw new IllegalArgumentException("structureElement was not found in its container");
    }

    @Contract(pure=true)
    public <T> T readValue(@NotNull FlagsStructure structure, @NotNull FlagsStructureElement<T> structureElement, int flags) {
        if (structure == null) {
            IntFlagsSerializer.$$$reportNull$$$0(2);
        }
        if (structureElement == null) {
            IntFlagsSerializer.$$$reportNull$$$0(3);
        }
        int offset = 0;
        for (FlagsStructureElement element : structure.getElements()) {
            if (element == structureElement) {
                int intValue = flags >> offset & (1 << structureElement.size()) - 1;
                return structureElement.getObject(intValue);
            }
            offset += element.size();
        }
        throw new IllegalArgumentException("structureElement was not found in its container");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/index/flags/IntFlagsSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

