/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSMissingSwitchBranchesInspection;
import com.intellij.lang.javascript.intentions.JSSwitchBranchesProcessor;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMissingSwitchDefaultInspection
extends JSInspection {
    public boolean ignoreDynamicTypes = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaScriptBundle.message("js.unreachable.switch.branches.ignore.with.dynamic", new Object[0]), (InspectionProfileEntry)this, "ignoreDynamicTypes");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMissingSwitchDefaultInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSMissingSwitchDefaultInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(JSSwitchStatement switchStatement) {
                List<Pair<Integer, String>> missingVariants;
                if (JSMissingSwitchBranchesInspection.hasDefault(switchStatement)) {
                    return;
                }
                JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases(switchStatement);
                if (typeForCases != null && !(typeForCases instanceof JSAnyType) ? (missingVariants = JSSwitchBranchesProcessor.getAllCaseVariants(switchStatement)).stream().noneMatch(v -> (Integer)v.first == -1) : JSMissingSwitchDefaultInspection.this.ignoreDynamicTypes) {
                    return;
                }
                String message = JavaScriptBundle.message("js.switch.no.default", new Object[0]);
                JSCreateDefaultBranchFix fix = new JSCreateDefaultBranchFix();
                JSMissingSwitchBranchesInspection.registerOnSwitchStatement(switchStatement, message, fix, holder, JSMissingSwitchDefaultInspection.this.myOnTheFly);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSCreateDefaultBranchFix
    implements LocalQuickFix {
        private JSCreateDefaultBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.switch.no.default.add", new Object[0]);
            if (string == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                JSCreateDefaultBranchFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor2.getPsiElement();
            JSSwitchStatement statement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSwitchStatement.class, (boolean)false);
            assert (statement != null);
            JSCaseClause clause = JSMissingSwitchBranchesInspection.createCaseClause(null, (PsiElement)statement);
            JSCaseClause[] clauses = statement.getCaseClauses();
            if (clauses.length > 0) {
                JSCaseClause lastClause = clauses[clauses.length - 1];
                JSSourceElement[] statements = lastClause.getStatementListItems();
                if (statements.length == 0) {
                    lastClause.addBefore(JSCreateDefaultBranchFix.createBreak(statement), null);
                } else {
                    JSSourceElement lastStatement = statements[statements.length - 1];
                    if (!(lastStatement instanceof JSBreakStatement) && !(lastStatement instanceof JSReturnStatement)) {
                        lastClause.addAfter(JSCreateDefaultBranchFix.createBreak(statement), (PsiElement)lastStatement);
                    }
                }
            }
            statement.addAfter(clause, clauses.length > 0 ? clauses[clauses.length - 1] : JSMissingSwitchBranchesInspection.findLBrace(statement));
        }

        private static PsiElement createBreak(JSSwitchStatement statement) {
            return JSPsiElementFactory.createJSStatement("break;", (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection$JSCreateDefaultBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMissingSwitchDefaultInspection$JSCreateDefaultBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

