/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSQuoteUnquotePropertiesIntentionBase
extends JavaScriptIntention {
    protected abstract String getActionName();

    protected abstract boolean canPerformAction(Collection<JSProperty> var1, Project var2);

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        Collection<JSProperty> properties2 = JSQuoteUnquotePropertiesIntentionBase.collectProperties(element, editor);
        if (properties2.size() == 1) {
            this.setText(JavaScriptBundle.message("js.quote.unquote.intention.singular", this.getActionName()));
        } else {
            this.setText(JavaScriptBundle.message("js.quote.unquote.intention.plural", this.getActionName()));
        }
        return this.canPerformAction(properties2, project);
    }

    @NotNull
    protected static Collection<JSProperty> collectProperties(PsiElement element, Editor editor) {
        if (!editor.getSelectionModel().hasSelection()) {
            JSObjectLiteralExpression literalExpression;
            JSObjectLiteralExpression literalExpression2;
            PsiElement elementParent = element.getParent();
            JSProperty property = (JSProperty)ObjectUtils.tryCast((Object)elementParent, JSProperty.class);
            if (property != null) {
                List<JSProperty> list2 = Collections.singletonList(property);
                if (list2 == null) {
                    JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(2);
                }
                return list2;
            }
            if ((element instanceof PsiWhiteSpace || element instanceof PsiComment) && (element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element)) == null) {
                List list3 = ContainerUtil.emptyList();
                if (list3 == null) {
                    JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(3);
                }
                return list3;
            }
            IElementType type = PsiUtilCore.getElementType((PsiElement)element);
            if ((type == JSTokenTypes.LBRACE || type == JSTokenTypes.RBRACE || type == JSTokenTypes.COMMA) && (literalExpression2 = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)elementParent, JSObjectLiteralExpression.class)) != null) {
                return JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(literalExpression2);
            }
            PsiElement sibling = element.getPrevSibling();
            if (sibling != null && (literalExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)sibling.getLastChild(), JSObjectLiteralExpression.class)) != null) {
                return JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(literalExpression);
            }
        } else {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            TextRange selectionRange = new TextRange(start, end);
            ArrayList<JSProperty> allProps = new ArrayList<JSProperty>();
            SyntaxTraverser.psiTraverser((PsiElement)element.getContainingFile()).onRange(JSQuoteUnquotePropertiesIntentionBase.fixRange(start, end, element.getContainingFile())).filter(JSObjectLiteralExpression.class).forEach(e -> JSQuoteUnquotePropertiesIntentionBase.collectPassingProperties(e, selectionRange, allProps));
            ArrayList<JSProperty> arrayList = allProps;
            if (arrayList == null) {
                JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(5);
        }
        return list4;
    }

    @NotNull
    private static TextRange fixRange(int start, int end, PsiFile file2) {
        JSObjectLiteralExpression literal;
        PsiElement endElement;
        JSObjectLiteralExpression literal2;
        PsiElement startElement = file2.findElementAt(start);
        if (startElement != null && (literal2 = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, JSObjectLiteralExpression.class)) != null) {
            int offset = literal2.getTextOffset();
            int n = start = offset == 0 ? 0 : offset - 1;
        }
        if ((endElement = file2.findElementAt(start)) != null && (literal = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)endElement, JSObjectLiteralExpression.class)) != null) {
            end = literal.getTextRange().getEndOffset() + 1;
        }
        return new TextRange(start, end);
    }

    private static void collectPassingProperties(JSObjectLiteralExpression startLiteral, TextRange selectionRange, List<JSProperty> allProps) {
        for (JSProperty property : JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(startLiteral)) {
            TextRange propertyRange = property.getTextRange();
            if (!selectionRange.intersects(propertyRange) || propertyRange.contains(selectionRange) && !propertyRange.equals((Object)selectionRange)) continue;
            allProps.add(property);
        }
    }

    @NotNull
    protected static Collection<JSProperty> collectLiteralProperties(JSObjectLiteralExpression element) {
        ArrayList allProps = ContainerUtil.newArrayList((Object[])element.getProperties());
        SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSObjectLiteralExpression.class).forEach(l -> ContainerUtil.addAll((Collection)allProps, (Object[])l.getProperties()));
        ArrayList arrayList = allProps;
        if (arrayList == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSQuoteUnquotePropertiesIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSQuoteUnquotePropertiesIntentionBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLiteralProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

