/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSLinterEditorNotifications
implements Disposable {
    private final ConcurrentHashMap<Class, JSLinterEditorNotificationPanel> myPanels;
    private final Map<VirtualFile, Map<Class, JSLinterFileLevelAnnotation>> myFileNotifications;
    @NotNull
    private final Project myProject;

    public JSLinterEditorNotifications(@NotNull Project project) {
        if (project == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(0);
        }
        this.myPanels = new ConcurrentHashMap();
        this.myFileNotifications = new HashMap<VirtualFile, Map<Class, JSLinterFileLevelAnnotation>>();
        this.myProject = project;
    }

    @NotNull
    public static JSLinterEditorNotifications getInstance(Project project) {
        JSLinterEditorNotifications jSLinterEditorNotifications = (JSLinterEditorNotifications)project.getService(JSLinterEditorNotifications.class);
        if (jSLinterEditorNotifications == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(1);
        }
        return jSLinterEditorNotifications;
    }

    public static void setNotification(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2, @NotNull JSLinterFileLevelAnnotation annotation) {
        if (project == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(2);
        }
        if (linterInspection == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(4);
        }
        if (annotation == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(5);
        }
        if (project.isDisposed()) {
            return;
        }
        JSLinterEditorNotifications.getInstance(project).setNotification(linterInspection, file2, annotation);
    }

    public static void clearNotification(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2) {
        if (project == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(6);
        }
        if (linterInspection == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(8);
        }
        if (project.isDisposed()) {
            return;
        }
        JSLinterEditorNotifications.getInstance(project).clearNotification(linterInspection, file2);
    }

    public synchronized void setNotification(@NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2, @NotNull JSLinterFileLevelAnnotation annotation) {
        if (linterInspection == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(10);
        }
        if (annotation == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(11);
        }
        this.ensureNotificationPanel(linterInspection);
        Map forFile = this.myFileNotifications.computeIfAbsent(file2, __ -> new HashMap());
        JSLinterFileLevelAnnotation previous = forFile.put(linterInspection, annotation);
        if (!Comparing.equal((Object)previous, (Object)annotation)) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        }
    }

    public synchronized void clearNotification(@NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2) {
        Map<Class, JSLinterFileLevelAnnotation> forFile;
        if (linterInspection == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(13);
        }
        if ((forFile = this.myFileNotifications.get(file2)) != null) {
            boolean isChanged;
            boolean bl = isChanged = forFile.remove(linterInspection) != null;
            if (forFile.isEmpty()) {
                this.myFileNotifications.remove(file2);
            }
            if (isChanged) {
                EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
            }
        }
    }

    @TestOnly
    @Nullable
    public synchronized String getNotificationText(@NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2) {
        JSLinterFileLevelAnnotation annotation;
        if (linterInspection == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(15);
        }
        return (annotation = (JSLinterFileLevelAnnotation)this.myFileNotifications.getOrDefault(file2, Collections.emptyMap()).get(linterInspection)) != null ? annotation.getMessage() : null;
    }

    @Nullable
    private synchronized JPanel renderNotifications(@NotNull VirtualFile file2) {
        Map forFile;
        if (file2 == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(16);
        }
        if ((forFile = this.myFileNotifications.getOrDefault(file2, Collections.emptyMap())).isEmpty()) {
            return null;
        }
        ArrayList<EditorNotificationPanel> components = new ArrayList<EditorNotificationPanel>();
        for (Map.Entry entry : forFile.entrySet()) {
            EditorNotificationPanel editorNotificationPanel = this.myPanels.get(entry.getKey()).createNotificationPanel((JSLinterFileLevelAnnotation)entry.getValue());
            if (editorNotificationPanel == null) continue;
            components.add(editorNotificationPanel);
        }
        if (components.isEmpty()) {
            return null;
        }
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        for (JPanel jPanel : components) {
            panel3.add(jPanel);
        }
        return panel3;
    }

    public synchronized void dispose() {
        this.myPanels.clear();
        this.myFileNotifications.clear();
    }

    private void ensureNotificationPanel(@NotNull Class<? extends JSLinterInspection> inspectionClass) {
        if (inspectionClass == null) {
            JSLinterEditorNotifications.$$$reportNull$$$0(17);
        }
        this.myPanels.computeIfAbsent(inspectionClass, aClass -> new JSLinterEditorNotificationPanel(this.myProject, inspectionClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterEditorNotifications";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterInspection";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterEditorNotifications";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setNotification";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearNotification";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderNotifications";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NotificationProvider
    extends EditorNotifications.Provider<JPanel> {
        private static final Key<JPanel> KEY = Key.create((String)"JS_LINTER_NOTIFICATIONS");

        @NotNull
        public Key<JPanel> getKey() {
            Key<JPanel> key = KEY;
            if (key == null) {
                NotificationProvider.$$$reportNull$$$0(0);
            }
            return key;
        }

        @Nullable
        public JPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
            if (file2 == null) {
                NotificationProvider.$$$reportNull$$$0(1);
            }
            if (fileEditor == null) {
                NotificationProvider.$$$reportNull$$$0(2);
            }
            if (project == null) {
                NotificationProvider.$$$reportNull$$$0(3);
            }
            return JSLinterEditorNotifications.getInstance(project).renderNotifications(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterEditorNotifications$NotificationProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterEditorNotifications$NotificationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotificationPanel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

