/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.node;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSPlaceTail;
import com.intellij.lang.javascript.modules.imports.JSAddRequireExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.validation.fixes.JSRequireFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportNodeJsModuleFix
extends ImportCommonJSModuleFix
implements JSRequireFix {
    private final @NotNull NotNullLazyValue<@IntentionName String> myText;

    public ImportNodeJsModuleFix(@NotNull PsiElement node, @NotNull JSImportCandidate descriptor2, @Nullable JSPlaceTail tail) {
        if (node == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(1);
        }
        super(node, descriptor2, tail);
        this.myText = NotNullLazyValue.createValue(() -> {
            PsiElement element = this.getStartElement();
            if (element == null || !element.isValid()) {
                return "";
            }
            String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.getQuote());
            String statement = wholeImportWrapQuote + this.getStatementRequireCallText() + wholeImportWrapQuote;
            return IdeBundle.message((String)"quickfix.text.insert.0", (Object[])new Object[]{statement});
        });
    }

    @Override
    protected void executeImpl(@NotNull PsiElement element, @Nullable Editor editor, @NotNull PsiElement scope) {
        if (element == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(3);
        }
        new JSAddRequireExecutor(editor, scope).createImports(this.myCandidate);
        this.replaceReferences(element, editor);
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = (String)this.myText.getValue();
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("node.js.modules.dependencies.missing.family.name", new Object[0]);
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String getStatementRequireCallText() {
        PsiElement element = this.getStartElement();
        JSImportDescriptor descriptor2 = this.myCandidate.getSingleDescriptorOrNull();
        if (descriptor2 == null) {
            return "";
        }
        String string = JSAddRequireExecutor.getRequireCallText(element, descriptor2);
        if (string == null) {
            ImportNodeJsModuleFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/node/ImportNodeJsModuleFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementRequireCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

