/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceExpressionPattern
extends PsiElementPattern<JSReferenceExpression, JSReferenceExpressionPattern> {
    protected JSReferenceExpressionPattern() {
        super(JSReferenceExpression.class);
    }

    public JSReferenceExpressionPattern withQualifiedName(String components) {
        final String[] parts = ArrayUtil.toStringArray((Collection)StringUtil.split((String)components, (String)"."));
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>("qualifiedName"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, parts);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$1", "accepts"));
            }
        });
    }

    public JSReferenceExpressionPattern withReferenceName(final String name) {
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>("referenceName"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$2", "accepts"));
            }
        });
    }

    @NotNull
    public JSReferenceExpressionPattern withReferenceNames(final String ... acceptableReferenceNames) {
        if (acceptableReferenceNames == null) {
            JSReferenceExpressionPattern.$$$reportNull$$$0(0);
        }
        JSReferenceExpressionPattern jSReferenceExpressionPattern = (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>("referenceNames"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context) {
                if (referenceExpression == null) {
                    3.$$$reportNull$$$0(0);
                }
                return ArrayUtil.contains((String)referenceExpression.getReferenceName(), (String[])acceptableReferenceNames);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$3", "accepts"));
            }
        });
        if (jSReferenceExpressionPattern == null) {
            JSReferenceExpressionPattern.$$$reportNull$$$0(1);
        }
        return jSReferenceExpressionPattern;
    }

    public JSReferenceExpressionPattern withNameStartingWith(String ... components) {
        final List<String> list2 = Arrays.asList(components);
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>("nameStartingWith"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context) {
                List<String> referenceComponents;
                if (referenceExpression == null) {
                    4.$$$reportNull$$$0(0);
                }
                return (referenceComponents = JSSymbolUtil.getReferenceParts(referenceExpression)) != null && ContainerUtil.startsWith(referenceComponents, (List)list2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$4", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableReferenceNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withReferenceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withReferenceNames";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

