/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Override
    public JSType calculateDeclarationTypeStubSafe() {
        JSType result2 = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (result2 != null) {
            return result2;
        }
        PsiElement parent = this.getContext();
        if (JSDestructuringUtil.isDestructuring(parent)) {
            return JSWidenType.createWidening(new JSDestructuringTypeImpl(this), this);
        }
        return null;
    }

    @Override
    @Nullable
    public final JSType calculateType() {
        JSType type = this.calculateDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            JSExpression initializer = this.getInitializer();
            if (initializer == null) {
                return null;
            }
            type = JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper().getTypeForIndexing(initializer, this);
            return JSWidenType.createWidening(type, this);
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null || this.hasBlockScope() && PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class}) != null;
    }

    @Override
    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    @Nullable
    protected String doGetName() {
        boolean computed;
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        if (name != null) {
            return name;
        }
        ASTNode nameNode = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
        boolean bl = computed = nameNode != null;
        if (nameNode == null) {
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
        }
        return TypeScriptVariableImpl.getResultNameFromNameNode(nameNode, computed);
    }

    @Override
    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return super.useLocalSearchScope(declarationScope) && !(declarationScope instanceof TypeScriptModule);
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(0);
        }
        return accessType;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember(this) || super.isNamespaceExplicitlyDeclared();
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "calcAccessType"));
    }
}

