/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLazyIndexedPackagesIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"js.lazy.packages");
    public static final Set<String> LAZY_PACKAGES = ContainerUtil.immutableSet((Object[])new String[]{"typescript", "@angular/language-service", "babel-cli", "prettier", "webpack", "webpack-dev-server", "stylelint", "webpack-bundle-analyzer", "coffee-script", "less", "stylus", "eslint", "ts-node", "lerna", "babel-core", "babel-runtime", "eslint-plugin-jest", "eslint-plugin-flowtype", "tslint", "jade"});

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            JSLazyIndexedPackagesIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    public static void index(@NotNull IndexSink sink, @Nullable String unquotedPath) {
        if (sink == null) {
            JSLazyIndexedPackagesIndex.$$$reportNull$$$0(1);
        }
        if (unquotedPath == null) {
            return;
        }
        String packageName = JSLazyIndexedPackagesIndex.extractPackage(unquotedPath);
        if (packageName == null) {
            return;
        }
        if (LAZY_PACKAGES.contains(packageName)) {
            sink.occurrence(KEY, (Object)packageName);
        }
    }

    @Nullable
    private static String extractPackage(@NotNull String path2) {
        if (path2 == null) {
            JSLazyIndexedPackagesIndex.$$$reportNull$$$0(2);
        }
        if (path2.startsWith(".") || path2.startsWith("/")) {
            return null;
        }
        int firstSeparatorIndex = path2.indexOf("/");
        if (firstSeparatorIndex < 0) {
            return path2;
        }
        if (path2.startsWith("@") && firstSeparatorIndex < path2.length()) {
            int next = path2.indexOf("/", firstSeparatorIndex + 1);
            if (next < 0) {
                return path2;
            }
            return path2.substring(0, next);
        }
        return path2.substring(0, firstSeparatorIndex);
    }

    @NotNull
    public static Set<String> getPackagesToIndex(@NotNull Project project) {
        Collection keys;
        if (project == null) {
            JSLazyIndexedPackagesIndex.$$$reportNull$$$0(3);
        }
        if ((keys = StubIndex.getInstance().getAllKeys(KEY, project)).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSLazyIndexedPackagesIndex.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<String> result2 = new HashSet<String>();
        for (String key : keys) {
            if (StubIndex.getElements(KEY, (Object)key, (Project)project, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), JSElement.class).isEmpty()) continue;
            result2.add(key);
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JSLazyIndexedPackagesIndex.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public int getVersion() {
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/JSLazyIndexedPackagesIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/JSLazyIndexedPackagesIndex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesToIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesToIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

