/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementExpressionOwner;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InheritanceBuilder {
    public static final String CALL = "call";
    public static final String APPLY = "apply";
    private String myExtendsTarget;
    private JSFunction myAncestor;
    private JSExpression myExtendsDeclaringExpression;
    private boolean myUsedAsError;
    @NotNull
    private final Set<JSFunction> myDescendants = new HashSet<JSFunction>();
    @NotNull
    private final Set<JSExpression> myInheritanceAssignments = new HashSet<JSExpression>();
    private final Map<JSExpression, JSNamedElementBase> myAllAncestors = new HashMap<JSExpression, JSNamedElementBase>();

    InheritanceBuilder() {
    }

    void extendFromDefaultsIfApplicable() {
        if (this.myExtendsTarget == null && this.myUsedAsError) {
            this.myExtendsTarget = "Error";
        }
    }

    public boolean hasBase() {
        return this.myUsedAsError || this.myExtendsTarget != null;
    }

    @NotNull
    public Set<JSExpression> getInheritanceAssignments() {
        Set<JSExpression> set = this.myInheritanceAssignments;
        if (set == null) {
            InheritanceBuilder.$$$reportNull$$$0(0);
        }
        return set;
    }

    boolean tryToParseProtoAssignment(JSAssignmentExpression assignment) {
        PsiElement child;
        JSExpression initializer = InheritanceBuilder.getInitializer(assignment);
        return initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferenceName()) && (child = initializer.getFirstChild()) instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)child, assignment);
    }

    private static JSExpression getInitializer(JSAssignmentExpression assignment) {
        return assignment.getDefinitionExpression().getInitializer();
    }

    private boolean tryToParseNewBaseInAssignment(@NotNull JSAssignmentExpression assignment) {
        JSExpression expression;
        JSExpression initializer;
        if (assignment == null) {
            InheritanceBuilder.$$$reportNull$$$0(1);
        }
        return (initializer = InheritanceBuilder.getInitializer(assignment)) instanceof JSNewExpression && (expression = ((JSNewExpression)initializer).getMethodExpression()) instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)expression, assignment);
    }

    private boolean parseObjectCreate(@NotNull JSAssignmentExpression assignment, @NotNull PairConsumer<String, JSObjectLiteralExpression> propertyConsumer) {
        JSExpression methodExpression;
        JSExpression initializer;
        if (assignment == null) {
            InheritanceBuilder.$$$reportNull$$$0(2);
        }
        if (propertyConsumer == null) {
            InheritanceBuilder.$$$reportNull$$$0(3);
        }
        if ((initializer = InheritanceBuilder.getInitializer(assignment)) instanceof JSCallExpression && JSConvertToClassProcessor.checkForObjectMethod(methodExpression = ((JSCallExpression)initializer).getMethodExpression(), "create")) {
            JSExpression child;
            JSExpression[] arguments = ((JSCallExpression)initializer).getArguments();
            if (arguments.length > 2) {
                return false;
            }
            ArrayList<Pair> definedProperties = new ArrayList<Pair>();
            if (arguments.length > 1) {
                JSProperty[] properties2;
                if (!(arguments[0] instanceof JSReferenceExpression)) {
                    return false;
                }
                if (!(arguments[1] instanceof JSObjectLiteralExpression)) {
                    return false;
                }
                JSObjectLiteralExpression literal = (JSObjectLiteralExpression)arguments[1];
                for (JSProperty property : properties2 = literal.getProperties()) {
                    if (property.getValue() == null || !(property.getValue() instanceof JSObjectLiteralExpression)) {
                        return false;
                    }
                    definedProperties.add(Pair.create((Object)property.getName(), (Object)((JSObjectLiteralExpression)property.getValue())));
                }
            }
            if (!((child = ((JSReferenceExpression)arguments[0]).getQualifier()) instanceof JSReferenceExpression) || !this.tryResolveBaseClass((JSReferenceExpression)child, assignment)) {
                return false;
            }
            if (!definedProperties.isEmpty()) {
                for (Pair property : definedProperties) {
                    propertyConsumer.consume((Object)((String)property.getFirst()), (Object)((JSObjectLiteralExpression)property.getSecond()));
                }
            }
            return true;
        }
        return false;
    }

    private static boolean functionOrClass(@Nullable PsiElement resolved) {
        return resolved instanceof JSFunction || resolved instanceof ES6Class;
    }

    private boolean tryResolveBaseClass(JSReferenceExpression expression, @NotNull JSExpression assignment) {
        PsiElement resolved;
        if (assignment == null) {
            InheritanceBuilder.$$$reportNull$$$0(4);
        }
        if (InheritanceBuilder.functionOrClass(resolved = JSChangeUtil.deepResolve(expression))) {
            this.myAllAncestors.put(assignment, (JSNamedElementBase)resolved);
            this.myExtendsTarget = expression.getText();
            if (resolved instanceof JSFunction) {
                this.myAncestor = (JSFunction)resolved;
            }
            this.myExtendsDeclaringExpression = assignment;
            this.myInheritanceAssignments.add(expression);
            return true;
        }
        return false;
    }

    public Map<JSExpression, JSNamedElementBase> getAllAncestors() {
        return this.myAllAncestors;
    }

    public String getExtendsTarget() {
        return this.myExtendsTarget;
    }

    public JSFunction getAncestor() {
        return this.myAncestor;
    }

    public JSExpression getExtendsDeclaringExpression() {
        return this.myExtendsDeclaringExpression;
    }

    @NotNull
    public Set<JSFunction> getDescendants() {
        Set<JSFunction> set = this.myDescendants;
        if (set == null) {
            InheritanceBuilder.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean tryToParsePrototypeAssignment(@NotNull JSAssignmentExpression assignment, @NotNull PairConsumer<String, JSObjectLiteralExpression> propertyConsumer) {
        if (assignment == null) {
            InheritanceBuilder.$$$reportNull$$$0(6);
        }
        if (propertyConsumer == null) {
            InheritanceBuilder.$$$reportNull$$$0(7);
        }
        if (this.tryToParseNewBaseInAssignment(assignment)) {
            return true;
        }
        return this.parseObjectCreate(assignment, propertyConsumer);
    }

    public boolean parseSetPrototype(@NotNull PsiReference topReference) {
        if (topReference == null) {
            InheritanceBuilder.$$$reportNull$$$0(8);
        }
        if (!(topReference.getElement().getParent() instanceof JSArgumentList)) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)topReference.getElement().getParent();
        if (!(argumentList.getParent() instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)argumentList.getParent();
        JSExpression methodExpression = call.getMethodExpression();
        if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "setPrototypeOf")) {
            return this.checkPrototypeAssignmentHelperMethodParameters(topReference, call, true, true);
        }
        return false;
    }

    public boolean parseInheritsCall(@NotNull PsiReference topReference) {
        if (topReference == null) {
            InheritanceBuilder.$$$reportNull$$$0(9);
        }
        return this.parseInheritsCall(topReference, true);
    }

    public boolean parseInheritsCall(@NotNull PsiReference topReference, boolean isDescendant) {
        if (topReference == null) {
            InheritanceBuilder.$$$reportNull$$$0(10);
        }
        if (!(topReference.getElement().getParent() instanceof JSArgumentList)) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)topReference.getElement().getParent();
        if (!(argumentList.getParent() instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)argumentList.getParent();
        if (ClassInheritanceNode.isNodeJSInheritsCall(call)) {
            return this.checkPrototypeAssignmentHelperMethodParameters(topReference, call, false, isDescendant);
        }
        return false;
    }

    private boolean checkPrototypeAssignmentHelperMethodParameters(@NotNull PsiReference topReference, @NotNull JSCallExpression call, boolean basePrototype, boolean isDescendant) {
        JSExpression[] arguments;
        if (topReference == null) {
            InheritanceBuilder.$$$reportNull$$$0(11);
        }
        if (call == null) {
            InheritanceBuilder.$$$reportNull$$$0(12);
        }
        if ((arguments = call.getArguments()).length == 2) {
            int otherIdx;
            int ourIdx = isDescendant ? 0 : 1;
            int n = otherIdx = isDescendant ? 1 : 0;
            if (!topReference.equals(arguments[ourIdx])) {
                return false;
            }
            if (!(arguments[otherIdx] instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression secondReference = (JSReferenceExpression)arguments[otherIdx];
            String referenceName = secondReference.getReferenceName();
            if (basePrototype) {
                if (!"prototype".equals(referenceName)) {
                    return false;
                }
                JSExpression qualifier = secondReference.getQualifier();
                return qualifier instanceof JSReferenceExpression && this.tryResolveBaseClass((JSReferenceExpression)qualifier, call);
            }
            return isDescendant ? this.tryResolveBaseClass(secondReference, call) : this.resolveDescendantConstructorReference(secondReference);
        }
        return false;
    }

    public void findAndConvertSuperCalls(@NotNull JSFunction function2, @NotNull Map<String, JSAssignmentExpression> declarations) {
        if (function2 == null) {
            InheritanceBuilder.$$$reportNull$$$0(13);
        }
        if (declarations == null) {
            InheritanceBuilder.$$$reportNull$$$0(14);
        }
        this.extendFromDefaultsIfApplicable();
        if (StringUtil.isEmptyOrSpaces((String)this.myExtendsTarget)) {
            return;
        }
        this.convertSuperCallInConstructor(function2);
        for (JSAssignmentExpression expression : declarations.values()) {
            if (expression.getDefinitionExpression() == null || !(InheritanceBuilder.getInitializer(expression) instanceof JSFunction)) continue;
            this.convertSuperCallsInFunction((JSFunction)((Object)InheritanceBuilder.getInitializer(expression)));
        }
    }

    private void convertSuperCallsInFunction(@NotNull JSFunction function2) {
        if (function2 == null) {
            InheritanceBuilder.$$$reportNull$$$0(15);
        }
        Collection calls = PsiTreeUtil.findChildrenOfType((PsiElement)function2, JSCallExpression.class);
        for (JSCallExpression call : calls) {
            List<String> parts;
            JSExpression methodExpression = call.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression) || (parts = InheritanceBuilder.rollDownReference((JSReferenceExpression)methodExpression)).size() != 4 || !this.myExtendsTarget.equals(parts.get(0)) || !"prototype".equals(parts.get(1))) continue;
            InheritanceBuilder.replaceWithSuperCall(function2, call, parts.get(3), parts.get(2));
        }
    }

    public void usedAsError() {
        this.myUsedAsError = true;
    }

    private static List<String> rollDownReference(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            InheritanceBuilder.$$$reportNull$$$0(16);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        JSReferenceExpression current = reference;
        while (current != null) {
            if (StringUtil.isEmptyOrSpaces((String)current.getReferenceName())) {
                return Collections.emptyList();
            }
            list2.add(current.getReferenceName());
            current = current.getQualifier() instanceof JSReferenceExpression ? (JSReferenceExpression)current.getQualifier() : null;
        }
        Collections.reverse(list2);
        return list2;
    }

    private void convertSuperCallInConstructor(@NotNull JSFunction function2) {
        JSBlockStatement constructorBlock;
        if (function2 == null) {
            InheritanceBuilder.$$$reportNull$$$0(17);
        }
        if ((constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function2, JSBlockStatement.class)) != null) {
            Collection statements = PsiTreeUtil.findChildrenOfType((PsiElement)constructorBlock, JSStatementExpressionOwner.class);
            for (JSStatementExpressionOwner statement : statements) {
                String name;
                JSCallExpression call;
                JSExpression methodExpression;
                if (!(statement.getExpression() instanceof JSCallExpression) || !((methodExpression = (call = (JSCallExpression)statement.getExpression()).getMethodExpression()) instanceof JSReferenceExpression) || ((JSReferenceExpression)methodExpression).getQualifier() == null || !this.myExtendsTarget.equals(((JSReferenceExpression)methodExpression).getQualifier().getText()) || !InheritanceBuilder.replaceWithSuperCall(function2, call, name = ((JSReferenceExpression)methodExpression).getReferenceName(), null)) continue;
                return;
            }
            JSStatement statement = JSPsiElementFactory.createJSStatement("super();", (PsiElement)function2);
            if (statements.isEmpty()) {
                constructorBlock.add((PsiElement)statement);
            } else {
                constructorBlock.addBefore((PsiElement)statement, (PsiElement)statements.iterator().next());
            }
        }
    }

    private static boolean replaceWithSuperCall(@NotNull JSFunction function2, @NotNull JSCallExpression call, @Nullable String callOrApplyName, @Nullable String methodName) {
        Object[] arguments;
        if (function2 == null) {
            InheritanceBuilder.$$$reportNull$$$0(18);
        }
        if (call == null) {
            InheritanceBuilder.$$$reportNull$$$0(19);
        }
        if ((arguments = call.getArguments()).length == 0) {
            return false;
        }
        if (!(arguments[0] instanceof JSThisExpression)) {
            return false;
        }
        String newArguments = null;
        if (CALL.equals(callOrApplyName)) {
            newArguments = StringUtil.join(ContainerUtil.map((Object[])arguments, arg -> arg.getText()).subList(1, arguments.length), (String)", ");
        } else if (APPLY.equals(callOrApplyName)) {
            if (arguments.length == 2 && "arguments".equals(arguments[1].getText())) {
                newArguments = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])function2.getParameterVariables(), parameter -> parameter.getName()), (String)", ");
            } else if (arguments.length == 2 && arguments[1] instanceof JSArrayLiteralExpression) {
                JSArrayLiteralExpression array = (JSArrayLiteralExpression)arguments[1];
                newArguments = StringUtil.join((Collection)ContainerUtil.map((Object[])array.getExpressions(), arg -> arg.getText()), (String)", ");
            } else if (arguments.length == 1) {
                newArguments = "";
            }
        }
        if (newArguments != null) {
            JSExpressionStatement superStatement = JSPsiElementFactory.createJSStatement("super" + (String)(methodName == null ? "" : "." + methodName) + "(" + newArguments + ");", (PsiElement)function2, JSExpressionStatement.class);
            call.replace(superStatement.getExpression());
            return true;
        }
        return false;
    }

    public boolean usedAsBasePrototypeConstructor(@NotNull JSReferenceExpression reference) {
        JSExpression definition;
        JSNewExpression newExpression;
        if (reference == null) {
            InheritanceBuilder.$$$reportNull$$$0(20);
        }
        if ((newExpression = (JSNewExpression)ObjectUtils.tryCast((Object)reference.getParent(), JSNewExpression.class)) == null) {
            return false;
        }
        JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)newExpression.getParent(), JSAssignmentExpression.class);
        return assignment != null && assignment.getDefinitionExpression() != null && newExpression.equals(assignment.getDefinitionExpression().getInitializer()) && this.resolveDescendantPrototypeReference(definition = assignment.getDefinitionExpression().getExpression());
    }

    private boolean resolveDescendantPrototypeReference(@Nullable JSExpression definition) {
        JSReferenceExpression expression;
        return definition instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)definition).getReferenceName()) && ((JSReferenceExpression)definition).getQualifier() instanceof JSReferenceExpression && this.resolveDescendantConstructorReference(expression = (JSReferenceExpression)((JSReferenceExpression)definition).getQualifier());
    }

    private boolean resolveDescendantConstructorReference(JSReferenceExpression expression) {
        PsiElement resolved = JSChangeUtil.deepResolve(expression);
        if (resolved instanceof JSFunction) {
            this.myDescendants.add((JSFunction)resolved);
            this.myInheritanceAssignments.add(expression);
            return true;
        }
        return false;
    }

    public boolean usedAsBaseInInheritsCall(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            InheritanceBuilder.$$$reportNull$$$0(21);
        }
        return this.parseInheritsCall((PsiReference)reference, false);
    }

    public boolean usedAsBaseInPrototypeAssignmentMethods(@NotNull JSReferenceExpression reference) {
        JSExpression expression;
        JSArgumentList argumentList;
        if (reference == null) {
            InheritanceBuilder.$$$reportNull$$$0(22);
        }
        if ((argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)reference.getParent(), JSArgumentList.class)) == null) {
            return false;
        }
        int argLength = argumentList.getArguments().length;
        if (argLength == 0 || argLength > 2) {
            return false;
        }
        boolean isFirstArgument = argumentList.getArguments()[0].equals(reference);
        JSCallExpression call = (JSCallExpression)ObjectUtils.tryCast((Object)argumentList.getParent(), JSCallExpression.class);
        if (call == null) {
            return false;
        }
        JSExpression methodExpression = call.getMethodExpression();
        if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "create") && isFirstArgument) {
            if (argLength == 2 && !(argumentList.getArguments()[1] instanceof JSObjectLiteralExpression)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)call.getParent(), JSAssignmentExpression.class);
            if (assignment == null) {
                return false;
            }
            if (assignment.getDefinitionExpression() == null || !call.equals(assignment.getDefinitionExpression().getInitializer())) {
                return false;
            }
            JSExpression expression2 = assignment.getDefinitionExpression().getExpression();
            if (this.resolveDescendantPrototypeReference(expression2)) {
                return true;
            }
        } else if (JSConvertToClassProcessor.checkForObjectMethod(methodExpression, "setPrototypeOf") && !isFirstArgument && argLength == 2 && this.resolveDescendantPrototypeReference(expression = argumentList.getArguments()[0])) {
            return true;
        }
        return false;
    }

    public boolean usedAsBaseInAssignment(@NotNull JSReferenceExpression reference) {
        JSAssignmentExpression assignment;
        if (reference == null) {
            InheritanceBuilder.$$$reportNull$$$0(23);
        }
        if ((assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)reference.getParent(), JSAssignmentExpression.class)) == null) {
            return false;
        }
        if (assignment.getDefinitionExpression() == null || !reference.equals(assignment.getDefinitionExpression().getInitializer())) {
            return false;
        }
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (expression instanceof JSReferenceExpression && "__proto__".equals(((JSReferenceExpression)expression).getReferenceName())) {
            return this.resolveDescendantPrototypeReference(((JSReferenceExpression)expression).getQualifier());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyConsumer";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topReference";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = CALL;
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceAssignments";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/InheritanceBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryToParseNewBaseInAssignment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseObjectCreate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveBaseClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToParsePrototypeAssignment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSetPrototype";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseInheritsCall";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkPrototypeAssignmentHelperMethodParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAndConvertSuperCalls";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertSuperCallsInFunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rollDownReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertSuperCallInConstructor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithSuperCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "usedAsBasePrototypeConstructor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "usedAsBaseInInheritsCall";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "usedAsBaseInPrototypeAssignmentMethods";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "usedAsBaseInAssignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD})
    private static @interface UsedAsBase {
    }
}

