/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.compdb.CompDBBundle;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBUtilKt;
import com.jetbrains.cidr.cpp.compdb.project.CompDBProjectResolver;
import com.jetbrains.cidr.cpp.compdb.project.CompDBStateData;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBLocalSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CompDBWorkspace")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ \u0010\n\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\r\u0010\u0018\u001a\u00070\f\u00a2\u0006\u0002\b\u0019H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/WorkspaceWithEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "checkInitialState", "", "", "externalModuleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "createEnvironment", "toolchainNameOrNullForDefault", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "getClientKey", "Lorg/jetbrains/annotations/NotNull;", "", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.clion.compdb"})
public final class CompDBWorkspace
extends ExternalWorkspace
implements WorkspaceWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getClientKey() {
        String string = CompDBUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ID.id");
        return string;
    }

    @Nullable
    public CPPEnvironment createEnvironment(@Nullable Project project, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        return CPPToolchains.createCPPEnvironment((Project)project, (File)this.getProjectPath().toFile(), (String)toolchainNameOrNullForDefault, (EnvironmentProblems)problems, (boolean)checkIfFunctional, (Runnable)onMissingToolchain);
    }

    @NotNull
    public final CPPEnvironment getEnvironment() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        CompDBLocalSettings localSettings = CompDBLocalSettings.Companion.getInstance(project);
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.myProject, localSettings.getToolchainName(), environmentProblems, false, null);
        environmentProblems.throwAsExecutionException();
        if (environment == null) {
            throw (Throwable)new ExecutionException(CompDBBundle.message("error.no.environment", new Object[0]));
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkInitialState() {
        ExternalSystemProgressNotificationManager notificationManager;
        ExternalSystemTaskNotificationListenerAdapter listener2 = new ExternalSystemTaskNotificationListenerAdapter(){
            private final Set<String> alreadyRefreshed;

            public final Set<String> getAlreadyRefreshed() {
                return this.alreadyRefreshed;
            }

            public void onStart(@NotNull ExternalSystemTaskId taskId, @Nullable String workingDir) {
                Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
                if (Intrinsics.areEqual((Object)CompDBUtilKt.getID(), (Object)taskId.getProjectSystemId()) && taskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
                    this.alreadyRefreshed.add(workingDir);
                }
            }
            {
                this.alreadyRefreshed = Collections.newSetFromMap((Map)new ConcurrentHashMap<K, V>());
            }
        };
        ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager = notificationManager = (ExternalSystemProgressNotificationManager)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        if (externalSystemProgressNotificationManager != null) {
            externalSystemProgressNotificationManager.addNotificationListener((ExternalSystemTaskNotificationListener)listener2);
        }
        try {
            CPPEnvironment environment = this.getEnvironment();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Collection modules = ExternalWorkspace.Companion.findExternalModuleNodes(project);
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataNode it = (DataNode)element$iv;
                boolean bl = false;
                String pathToRefresh = this.checkInitialState((DataNode<ExternalModule>)it, environment);
                if (pathToRefresh == null || listener2.getAlreadyRefreshed().contains(pathToRefresh)) continue;
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                CompDBUtil.INSTANCE.markProjectDirty(project2, pathToRefresh);
            }
        }
        catch (ExecutionException ex) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: can't create environment");
            CompDBLog.INSTANCE.getLOG().debug((Throwable)ex);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Iterable $this$forEach$iv = CompDBUtil.INSTANCE.linkedProjectSettings(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompDBProjectSettings it = (CompDBProjectSettings)((Object)element$iv);
                boolean bl = false;
                if (listener2.getAlreadyRefreshed().contains(it.getExternalProjectPath())) continue;
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                String string = it.getExternalProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.externalProjectPath");
                CompDBUtil.INSTANCE.markProjectDirty(project3, string);
            }
        }
        finally {
            ExternalSystemProgressNotificationManager externalSystemProgressNotificationManager2 = notificationManager;
            if (externalSystemProgressNotificationManager2 != null) {
                externalSystemProgressNotificationManager2.removeNotificationListener((ExternalSystemTaskNotificationListener)listener2);
            }
        }
    }

    private final String checkInitialState(DataNode<ExternalModule> externalModuleNode, CPPEnvironment environment) {
        DataNode ideaModule = ExternalSystemApiUtil.findParent(externalModuleNode, (Key)ProjectKeys.MODULE);
        CompDBLog.INSTANCE.getLOG().assertTrue(ideaModule != null);
        DataNode compDBStateNode = ExternalSystemApiUtil.find(externalModuleNode, CompDBStateData.Companion.getCOMPDB_STATE_DATA_KEY());
        if (compDBStateNode == null) {
            CompDBLog.INSTANCE.getLOG().debug("Initial state check: no previously created state");
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaModule!!.data");
            return ((ModuleData)object).getLinkedExternalProjectPath();
        }
        DataNode<CompDBStateData> newCompDBStateNode = CompDBProjectResolver.Companion.createStateData(environment);
        if (Intrinsics.areEqual(newCompDBStateNode, (Object)compDBStateNode) ^ true) {
            if (CompDBLog.INSTANCE.getLOG().isDebugEnabled()) {
                CompDBLog.INSTANCE.getLOG().debug(StringsKt.trimMargin$default((String)("\n          |Initial state check: state changed\n          |Old: " + (Object)((Object)((CompDBStateData)((Object)compDBStateNode.getData()))) + "\n          |New: " + (Object)((Object)((CompDBStateData)((Object)newCompDBStateNode.getData())))), null, (int)1, null));
            }
            DataNode dataNode = ideaModule;
            Intrinsics.checkNotNull((Object)dataNode);
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ideaModule!!.data");
            return ((ModuleData)object).getLinkedExternalProjectPath();
        }
        return null;
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        List list;
        try {
            list = CollectionsKt.listOf((Object)this.getEnvironment());
        }
        catch (ExecutionException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public CompDBWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @JvmStatic
    @Nullable
    public static final CompDBWorkspace getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/cpp/compdb/CompDBWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.compdb"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final CompDBWorkspace getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (CompDBWorkspace)((Object)project.getComponent(CompDBWorkspace.class));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

