/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0006\b\u0000\u0010\u001e\u0018\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\bJ(\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/Dbms;)V", "builder", "Lcom/intellij/database/model/SqlObjectBuilder;", "getBuilder", "()Lcom/intellij/database/model/SqlObjectBuilder;", "facade", "Lcom/intellij/sql/psi/SqlPsiFacade;", "Lorg/jetbrains/annotations/NotNull;", "getFacade", "()Lcom/intellij/sql/psi/SqlPsiFacade;", "language", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getLanguage", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createLexer", "Lcom/intellij/lexer/Lexer;", "createROFile", "Lcom/intellij/sql/psi/SqlFile;", "src", "", "statements", "Lcom/intellij/util/containers/JBIterable;", "T", "clazz", "Ljava/lang/Class;", "traverse", "Lcom/intellij/psi/SyntaxTraverser;", "Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.base.core"})
public final class IntrospectorSqlHelper {
    @NotNull
    private final SqlPsiFacade facade;
    @NotNull
    private final SqlLanguageDialect language;
    @NotNull
    private final SqlObjectBuilder builder;
    @NotNull
    private final Project project;

    @NotNull
    public final SqlPsiFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final SqlLanguageDialect getLanguage() {
        return this.language;
    }

    @NotNull
    public final SqlObjectBuilder getBuilder() {
        return this.builder;
    }

    private final SqlFile createROFile(String src2) {
        SqlFile sqlFile = this.facade.createROFile(this.language, (CharSequence)src2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"facade.createROFile(language, src)");
        return sqlFile;
    }

    private final SyntaxTraverser<PsiElement> traverse(String src2) {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.createROFile(src2)));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(createROFile(src))");
        return syntaxTraverser;
    }

    @NotNull
    public final <T> JBIterable<T> statements(@NotNull String src2, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        JBIterable jBIterable = ((SyntaxTraverser)this.traverse(src2).expandAndSkip((Condition)statements.1.INSTANCE)).filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(src).expandAndS\u2026Statement }.filter(clazz)");
        return jBIterable;
    }

    public final /* synthetic */ <T> JBIterable<T> statements(String src2) {
        int $i$f$statements = 0;
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.statements(src2, Object.class);
    }

    @NotNull
    public final Lexer createLexer() {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)this.language)).createLexer(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"LanguageParserDefinition\u2026age).createLexer(project)");
        return lexer;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public IntrospectorSqlHelper(@NotNull Project project, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.project = project;
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
        this.facade = sqlPsiFacade;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((Dbms)dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtilCore.getSqlDialect(dbms)");
        this.language = sqlLanguageDialect;
        Object object = SqlObjectBuilder.EP.forDbms(dbms);
        Intrinsics.checkNotNull((Object)object);
        this.builder = (SqlObjectBuilder)object;
    }
}

