/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSCodeFragment;
import com.intellij.sql.dialects.mongo.js.MongoJSParser;
import com.intellij.sql.dialects.mongo.js.MongoJSParserDefinition;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016JJ\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J4\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J4\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J:\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\b\u0010!\u001a\u00020 H\u0016J8\u0010\"\u001a\u00020#2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J8\u0010$\u001a\u00020#2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J,\u0010%\u001a\u00020&2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/mongo/MongoGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "createFilterCodeFragment", "filterText", "queryText", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "table", "Lcom/intellij/database/model/DasTable;", "createSortingCodeFragment", "sortingText", "getCellLanguage", "Lcom/intellij/lang/Language;", "getFilterLanguage", "isArrayCell", "", "isObjectCell", "setFilterText", "", "caretPosition", "", "intellij.database.dialects.mongo"})
public final class MongoGridHelper
implements GridHelper {
    @NotNull
    private final Dbms dbms;

    @NotNull
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        IElementType iElementType = JSElementTypes.ARGUMENT_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ARGUMENT_LIST");
        MongoJSCodeFragment codeFragment = MongoJSCodeFragment.Companion.create(iElementType, project, "dummy.js", filterText, true);
        codeFragment.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, dataSource);
        DasNamespace nsp = DbImplUtil.getSearchPathObject((DatabaseDialectEx)DbImplUtilCore.getDatabaseDialect((DbElement)((DbElement)dataSource)), (DasObject)((DasObject)table));
        codeFragment.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, ObjectPaths.searchPathOf((DasObject)((DasObject)nsp)));
        return codeFragment;
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return this.isArrayCell(grid, row, column2) || this.isObjectCell(grid, row, column2) ? (Language)MongoJSLanguage.INSTANCE : null;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        PsiCodeFragment psiCodeFragment;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        if (this.isObjectCell(grid, row, column2)) {
            JSElementTypes.JSElType jSElType = JSElementTypes.OBJECT_LITERAL_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSElType), (String)"OBJECT_LITERAL_EXPRESSION");
            psiCodeFragment = MongoJSCodeFragment.Companion.create(jSElType, project, "dummy.js", text, true);
        } else {
            psiCodeFragment = null;
        }
        return psiCodeFragment;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull Domain domain) {
        PsiCodeFragment psiCodeFragment;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        if (Intrinsics.areEqual((Object)domain.simpleName(), (Object)"Object")) {
            JSElementTypes.JSElType jSElType = JSElementTypes.OBJECT_LITERAL_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSElType), (String)"OBJECT_LITERAL_EXPRESSION");
            psiCodeFragment = MongoJSCodeFragment.Companion.create(jSElType, project, "dummy.js", text, true);
        } else {
            psiCodeFragment = null;
        }
        return psiCodeFragment;
    }

    private final boolean isObjectCell(CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2), (CharSequence)"Object");
    }

    private final boolean isArrayCell(CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2), (CharSequence)"Array");
    }

    @NotNull
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.createFilterCodeFragment(project, sortingText, queryText, dataSource, table);
    }

    public void setFilterText(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MongoJSParserDefinition parserDefinition = new MongoJSParserDefinition();
        Project project = grid.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"grid.project");
        Project project2 = project;
        String currentText = grid.getFilterText();
        PsiBuilderImpl builder = new PsiBuilderImpl(project2, null, (ParserDefinition)parserDefinition, parserDefinition.createLexer(project2), null, (CharSequence)currentText, null, null);
        new MongoJSParser((PsiBuilder)builder).parseJS(JSElementTypes.ARGUMENT_LIST);
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.lightTraverser((PsiBuilder)((PsiBuilder)builder));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser.lightTraverser(builder)");
        SyntaxTraverser traverser2 = syntaxTraverser;
        List list = traverser2.children(traverser2.getRoot()).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"traverser.children(traverser.root).toList()");
        List children2 = list;
        SyntaxTraverser.Api api = traverser2.api;
        if (children2.size() == 3 && Intrinsics.areEqual((Object)api.typeOf(children2.get(0)), (Object)((Object)JSElementTypes.OBJECT_LITERAL_EXPRESSION)) && Intrinsics.areEqual((Object)api.typeOf(children2.get(1)), (Object)JSElementTypes.COMMA) && Intrinsics.areEqual((Object)api.typeOf(children2.get(2)), (Object)((Object)JSElementTypes.OBJECT_LITERAL_EXPRESSION))) {
            StringBuilder stringBuilder = new StringBuilder().append(text);
            String string = currentText;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentText");
            String string2 = string;
            TextRange textRange = api.rangeOf(children2.get(0));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"api.rangeOf(children[0])");
            int n = textRange.getEndOffset();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            grid.setFilterText(stringBuilder.append(string4).toString(), caretPosition);
        } else {
            grid.setFilterText(text, caretPosition);
        }
    }

    @NotNull
    public Language getFilterLanguage() {
        return (Language)MongoJSLanguage.INSTANCE;
    }

    @NotNull
    public Dbms getDbms() {
        return this.dbms;
    }

    public MongoGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @Nullable
    public Language getCellLanguage(@NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return GridHelper.DefaultImpls.getCellLanguage((GridHelper)this, (Domain)domain);
    }

    @NotNull
    public Set<DataConsumer.Column.Attribute> getAttributes(@NotNull DasColumn column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        return GridHelper.DefaultImpls.getAttributes((GridHelper)this, (DasColumn)column2);
    }
}

