/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.dialects.mysqlbase.MysqlBaseErrorHandler;
import com.intellij.database.util.AsyncUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlErrorHandler
extends MysqlBaseErrorHandler {
    private static final Pattern UNRECOGNIZED_TIME_ZONE = Pattern.compile("The server time zone value '.*' is unrecognized");
    public static final String SERVER_TIMEZONE = "serverTimezone";
    private static final String TLS_PROTOCOLS = "enabledTLSProtocols";
    private static final String[] ALL_TLS_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};

    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull DatabaseErrorHandlerSink sink) {
        String message2;
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            MysqlErrorHandler.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            MysqlErrorHandler.$$$reportNull$$$0(2);
        }
        if ((message2 = cause.getMessage()) != null) {
            if (UNRECOGNIZED_TIME_ZONE.matcher(message2).find()) {
                sink.addSetDriverPropertyFix(dataSource, DatabaseBundle.message((String)"error.message.mysql.invalid.timezone.fix", (Object[])new Object[0]), SERVER_TIMEZONE, "UTC");
                String string = DatabaseBundle.message((String)"error.message.mysql.invalid.timezone", (Object[])new Object[0]);
                if (string == null) {
                    MysqlErrorHandler.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (dataSource != null && MysqlErrorHandler.isHandshakeTerminated(original) && StringUtil.isNotEmpty((String)((String)dataSource.getDriverProperties().get(TLS_PROTOCOLS)))) {
                sink.addSetDriverPropertyFix(dataSource, DatabaseBundle.message((String)"error.message.mysql.tls.protocol.version.clear", (Object[])new Object[0]), TLS_PROTOCOLS, null);
                String string = DatabaseBundle.message((String)"server.has.terminated.the.handshake.you.have.enabledtlsprotocols.set.that.option.causes.connection.issues.with.some.versions.of.mysql", (Object[])new Object[0]);
                if (string == null) {
                    MysqlErrorHandler.$$$reportNull$$$0(4);
                }
                return string;
            }
            if (MysqlErrorHandler.isNoSslProtocol((String)message2) && dataSource != null) {
                boolean allSet;
                @Nls StringBuilder sb = new StringBuilder(message2);
                MysqlErrorHandler.addEnableDisabledProtocols((LocalDataSource)dataSource, (DatabaseErrorHandlerSink)sink, (StringBuilder)sb);
                String protocols = (String)dataSource.getDriverProperties().get(TLS_PROTOCOLS);
                boolean bl = allSet = protocols != null && ContainerUtil.find((Object[])ALL_TLS_PROTOCOLS, p -> !protocols.contains((CharSequence)p)) == null;
                if (!allSet) {
                    boolean protocolsNotSet = StringUtil.isEmptyOrSpaces((String)protocols);
                    sink.addSetDriverPropertyFix(dataSource, DatabaseBundle.message((String)(protocolsNotSet ? "error.message.mysql.tls.protocol.version.all" : "error.message.mysql.tls.protocol.version.clear"), (Object[])new Object[0]), TLS_PROTOCOLS, protocolsNotSet ? StringUtil.join((String[])ALL_TLS_PROTOCOLS, (String)", ") : null);
                }
                sb.append("\n\n").append(DatabaseBundle.message((String)"error.message.mysql.tls.protocol.version", (Object[])new Object[0]));
                String string = sb.toString();
                if (string == null) {
                    MysqlErrorHandler.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = super.getErrorMessage(dataSource, original, cause, sink);
        if (string == null) {
            MysqlErrorHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isHandshakeTerminated(@NotNull Throwable original) {
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(7);
        }
        return AsyncUtil.traverse((Throwable)original).find(e2 -> {
            String m = e2.getMessage();
            return m != null && m.contains("javax.net.ssl.SSLHandshakeException") && m.contains("Remote host terminated the handshake");
        }) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHandshakeTerminated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

