/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSinkImpl;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlSocketParamEditor
extends TextParamEditor {
    public static final String MYSQL_SOCKET = "mysql.socket";

    MysqlSocketParamEditor(@NotNull DataInterchange interchange, @NlsContexts.Label @NotNull String caption) {
        if (interchange == null) {
            MysqlSocketParamEditor.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            MysqlSocketParamEditor.$$$reportNull$$$0(1);
        }
        super(interchange, caption, FieldSize.LARGE, new AnAction[0]);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle(DatabaseBundle.message((String)"dialog.title.choose.socket.location", (Object[])new Object[0]));
        this.addButton((AnAction)new ParamEditorBase.FMChooseAction(descriptor));
    }

    protected void fireChanged() {
        if (StringUtil.isEmpty((String)this.getInterchange().getProperty("socketFactory"))) {
            this.getInterchange().putProperty("socketFactory", "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactoryCJ");
        }
        super.fireChanged();
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            MysqlSocketParamEditor.$$$reportNull$$$0(2);
        }
        super.setText(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Validator
    extends DatabaseConfigValidator<LocalDataSource> {
        public static final String JUS_ARTIFACT = "junixsocket-mysql";

        Validator() {
        }

        public void collectProblems(final @NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor) {
            if (project == null) {
                Validator.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                Validator.$$$reportNull$$$0(1);
            }
            if (problems == null) {
                Validator.$$$reportNull$$$0(2);
            }
            if (!target2.getDbms().in(Dbms.MYSQL_LIKE)) {
                return;
            }
            if (target2.getUrl() == null || !target2.getUrl().contains("junixsocket.file")) {
                return;
            }
            DatabaseDriver driver = target2.getDatabaseDriver();
            if (driver != null && !Validator.hasJUS(target2)) {
                final DatabaseErrorHandler.Fix setUpFix = Validator.createSetUpFix(driver, false);
                NamedProgressive fix = new NamedProgressive(setUpFix.getName()){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix((Project)project, (DatabaseErrorHandler.Fix)setUpFix, (DatabaseConfigEditor)editor));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Validator$1", "run"));
                    }
                };
                problems.consume((Object)new DataSourceProblem((Object)target2, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(AnalysisBundle.message((String)"notification.title.unix.socket.connection", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required.href.action0.download", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required", (Object[])new Object[0]), new Object[]{fix}), fix));
            }
        }

        @NotNull
        private static DatabaseErrorHandler.Fix createSetUpFix(DatabaseDriver driver, boolean navigate) {
            DatabaseErrorHandler.Fix fix = DatabaseErrorHandlerSinkImpl.createSetUpArtifactFix((DatabaseDriver)driver, (boolean)navigate, () -> {
                DatabaseArtifactList.ArtifactVersion jus = Validator.findJUS();
                if (jus == null) {
                    return null;
                }
                return jus;
            });
            if (fix == null) {
                Validator.$$$reportNull$$$0(3);
            }
            return fix;
        }

        public Class<? extends LocalDataSource> getTargetClass() {
            return LocalDataSource.class;
        }

        private static boolean hasJUS(@NotNull LocalDataSource target2) {
            DatabaseDriver.ArtifactRef jus;
            DatabaseDriver driver;
            if (target2 == null) {
                Validator.$$$reportNull$$$0(4);
            }
            if ((driver = target2.getDatabaseDriver()) != null && (jus = (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)driver.getArtifacts(), a -> a.getId().equals(JUS_ARTIFACT))) != null) {
                return true;
            }
            return JBIterable.from((Iterable)target2.getClasspathElements()).flatten(SimpleClasspathElement::getClassesRootUrls).find(u -> u.contains(JUS_ARTIFACT)) != null;
        }

        @Nullable
        private static DatabaseArtifactList.ArtifactVersion findJUS() {
            return DatabaseArtifactManager.getArtifacts().resolve(JUS_ARTIFACT, null, "stable", null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Validator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Validator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSetUpFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectProblems";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasJUS";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Factory
    implements TypesRegistry.TypeDescriptorFactory {
        Factory() {
        }

        public void createTypeDescriptor(@NotNull Consumer<? super TypesRegistry.TypeDescriptor> consumer) {
            if (consumer == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer.consume((Object)new TypesRegistry.BaseTypeDescriptor(MysqlSocketParamEditor.MYSQL_SOCKET, "(?!//)[^;?&]+?|/", DatabaseBundle.message((String)"TypeDescriptor.param.mysql_socket", (Object[])new Object[0])){

                @NotNull
                protected TypesRegistry.ParamEditor createFieldImpl(@NlsContexts.Label @NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new MysqlSocketParamEditor(interchange, caption);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "caption";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "interchange";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Factory$1";
                    objectArray[2] = "createFieldImpl";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

