/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.testing.utplsql;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlHighlightingPassFactory;
import com.intellij.database.dialects.oracle.testing.utplsql.UtPlSqlRunLineMarkerContributorKt;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/oracle/testing/utplsql/UtPlSqlHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "tagType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl;", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.oracle.ex"})
public final class UtPlSqlHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private HighlightInfoType.HighlightInfoTypeImpl tagType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.DOC_COMMENT);

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                if (!(file instanceof SqlFile)) break block2;
                SqlLanguageDialect sqlLanguageDialect = ((SqlFile)file).getSqlLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"file.sqlLanguage");
                if (!(Intrinsics.areEqual((Object)sqlLanguageDialect.getDbms(), (Object)Dbms.ORACLE) ^ true)) break block3;
            }
            return null;
        }
        return new TextEditorHighlightingPass(this, file, editor, ((SqlFile)file).getProject(), editor.getDocument()){
            private final TIntArrayList tags;
            final /* synthetic */ UtPlSqlHighlightingPassFactory this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;

            public void doCollectInformation(@NotNull ProgressIndicator progress) {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                for (PsiElement pack : SqlImplUtil.sqlChildren((PsiElement)((PsiElement)this.$file)).filter((Condition)createHighlightingPass.doCollectInformation.1.INSTANCE)) {
                    Iterator iterator = SqlImplUtil.sqlChildren((PsiElement)pack).filter(PsiComment.class).iterator();
                    while (iterator.hasNext()) {
                        TextRange rg2;
                        PsiComment comment;
                        PsiComment psiComment = comment = (PsiComment)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"comment");
                        String string = psiComment.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"comment.text");
                        if (!UtPlSqlRunLineMarkerContributorKt.isTagged(string, "")) continue;
                        TextRange textRange = rg2 = comment.getTextRange();
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"rg");
                        this.tags.add(textRange.getStartOffset());
                        this.tags.add(rg2.getEndOffset());
                    }
                }
            }

            public void doApplyInformationToEditor() {
                ArrayList<E> infos = new ArrayList<E>();
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(this.tags.size() / 2));
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    Collection collection = infos;
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)((HighlightInfoType)UtPlSqlHighlightingPassFactory.access$getTagType$p(this.this$0))).range(this.tags.get(i2 * 2), this.tags.get(i2 * 2 + 1)).createUnconditionally();
                    boolean bl2 = false;
                    collection.add(highlightInfo);
                }
                UpdateHighlightersUtil.setHighlightersToSingleEditor((Project)this.myProject, (Editor)this.$editor, (int)0, (int)this.$file.getTextLength(), (Collection)infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
            }
            {
                this.this$0 = this$0;
                this.$file = $captured_local_variable$1;
                this.$editor = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
                this.tags = new TIntArrayList();
            }
        };
    }

    public static final /* synthetic */ HighlightInfoType.HighlightInfoTypeImpl access$getTagType$p(UtPlSqlHighlightingPassFactory $this) {
        return $this.tagType;
    }

    public static final /* synthetic */ void access$setTagType$p(UtPlSqlHighlightingPassFactory $this, HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl) {
        $this.tagType = highlightInfoTypeImpl;
    }
}

