/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import a.d.la;
import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.MutableRemoteCredentialsEx;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshUiData
implements MutableRemoteCredentialsEx,
Cloneable {
    @NotNull
    private SshConfig myConfig;
    @NotNull
    private SshConfig.AuthData myAuthData;
    private static final long a = la.a(2471723488660977852L, -2952423696467181352L, MethodHandles.lookup().lookupClass()).a(19050593266691L);

    public SshUiData(@NotNull SshConfig config) {
        if (config == null) {
            SshUiData.a(0);
        }
        this(config, true);
    }

    public SshUiData(@NotNull SshConfig config, boolean initAuthDataFromPasswordSafe) {
        if (config == null) {
            SshUiData.a(1);
        }
        this(config, initAuthDataFromPasswordSafe ? config.getAuthDataFromForPasswordSafe() : new SshConfig.AuthData());
    }

    public SshUiData(@NotNull SshConfig config, @NotNull SshConfig.AuthData data) {
        if (config == null) {
            SshUiData.a(2);
        }
        if (data == null) {
            SshUiData.a(3);
        }
        this.myConfig = config;
        this.myAuthData = data;
    }

    public String getName() {
        return this.myConfig.getName();
    }

    @NotNull
    public SshConfig getConfig() {
        SshConfig sshConfig = this.myConfig;
        if (sshConfig == null) {
            SshUiData.a(4);
        }
        return sshConfig;
    }

    public SshUiData clone() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.myConfig = this.myConfig.clone();
            sshUiData.myAuthData = this.myAuthData.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public SshUiData copy() {
        try {
            SshUiData sshUiData = (SshUiData)super.clone();
            sshUiData.myConfig = this.myConfig.clone();
            sshUiData.myAuthData = this.myAuthData.clone();
            return sshUiData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public void setHost(@Nullable String host) {
        this.myConfig.setHost(host);
    }

    public void setPort(int port2) {
        this.myConfig.setPort(port2);
    }

    public void setLiteralPort(@Nullable String portText) {
        this.myConfig.setLiteralPort(portText);
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshUiData.a(5);
        }
        this.myConfig.setAuthType(authType);
    }

    @NotNull
    public String getHost() {
        String string = this.myConfig.getHost();
        if (string == null) {
            SshUiData.a(6);
        }
        return string;
    }

    public int getPort() {
        return this.myConfig.getPort();
    }

    @NotNull
    public String getLiteralPort() {
        String string = this.myConfig.getLiteralPort();
        if (string == null) {
            SshUiData.a(7);
        }
        return string;
    }

    public void setLocalPort(int port2) {
        this.myConfig.setLocalPort(port2);
    }

    public void setLiteralLocalPort(@Nullable String portText) {
        this.myConfig.setLiteralLocalPort(portText);
    }

    public int getLocalPort() {
        return this.myConfig.getLocalPort();
    }

    @Nullable
    public String getLiteralLocalPort() {
        return this.myConfig.getLiteralLocalPort();
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myConfig.getAuthType();
        if (authType == null) {
            SshUiData.a(8);
        }
        return authType;
    }

    @Nullable
    public String getPassword() {
        return this.myAuthData.getPassword();
    }

    public void setPassword(@Nullable String password) {
        this.myAuthData.setPassword(password);
    }

    public boolean isStorePassword() {
        return this.myAuthData.isSavePassword();
    }

    public void setStorePassword(boolean savePassword) {
        this.myAuthData.setSavePassword(savePassword);
    }

    @NotNull
    public String getPrivateKeyFile() {
        String string = this.myConfig.getKeyPath();
        if (string == null) {
            SshUiData.a(9);
        }
        return string;
    }

    public void setPrivateKeyFile(@Nullable String keyPath) {
        this.myConfig.setKeyPath(keyPath);
    }

    @Nullable
    public String getPassphrase() {
        return this.myAuthData.getPassphrase();
    }

    public void setPassphrase(@Nullable String passphrase) {
        this.myAuthData.setPassphrase(passphrase);
    }

    public boolean isStorePassphrase() {
        return this.myAuthData.isSavePassphrase();
    }

    public void setStorePassphrase(boolean savePassphrase) {
        this.myAuthData.setSavePassphrase(savePassphrase);
    }

    public void setUserName(@Nullable String userName) {
        this.myConfig.setUsername(userName);
    }

    @Nullable
    public String getUserName() {
        return this.myConfig.getUsername();
    }

    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConfig.getConnectionConfigPatch();
    }

    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConfig.setConnectionConfigPatch(patch);
    }

    public void mergeAndSaveAuthData(SshConfig.AuthData data, boolean retainedExistingKeyPath, boolean retainedRegisteredKeyPath) {
        Pair<String, Boolean> pair = SshUiData.a(this.getPassword(), this.isStorePassword(), data.getPassword(), data.isSavePassword());
        this.setPassword((String)pair.first);
        this.setStorePassword((Boolean)pair.second);
        if (retainedExistingKeyPath && retainedRegisteredKeyPath) {
            Pair<String, Boolean> pair2 = SshUiData.a(this.getPassphrase(), this.isStorePassphrase(), data.getPassphrase(), data.isSavePassphrase());
            this.setPassphrase((String)pair2.first);
            this.setStorePassphrase((Boolean)pair2.second);
        } else if (retainedRegisteredKeyPath) {
            this.setPassphrase(data.getPassphrase());
            this.setStorePassphrase(data.isSavePassphrase());
        }
        this.saveAuthDataToPasswordSafe();
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentialsHolder remoteCredentialsHolder = new RemoteCredentialsHolder();
        remoteCredentialsHolder.copyFrom((RemoteCredentials)this);
        RemoteCredentialsHolder remoteCredentialsHolder2 = remoteCredentialsHolder;
        if (remoteCredentialsHolder2 == null) {
            SshUiData.a(10);
        }
        return remoteCredentialsHolder2;
    }

    @NotNull
    private static @NotNull Pair<String, @NotNull Boolean> a(String string, boolean bl2, String string2, boolean bl3) {
        if (StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)(bl2 || bl3 ? (char)'\u0001' : '\u0000'));
        }
        if (!StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string, (Object)bl2);
        }
        if (StringUtil.isEmpty((String)string) && !StringUtil.isEmpty((String)string2)) {
            return new Pair((Object)string2, (Object)bl3);
        }
        if (bl2) {
            return new Pair((Object)string, (Object)true);
        }
        if (bl3) {
            return new Pair((Object)string2, (Object)true);
        }
        return new Pair((Object)string, (Object)false);
    }

    public boolean hasNoCredentials() {
        return this.myAuthData.hasNoCredentials(this.myConfig.getAuthType(), this.myConfig.getKeyPath());
    }

    public String toString() {
        return "SshUiData{ myConfig='" + this.myConfig.getName() + "', myAuthData=" + this.myAuthData + "}";
    }

    @Nullable
    public static SshUiData findById(List<SshUiData> items, @NotNull String id2) {
        if (id2 == null) {
            SshUiData.a(11);
        }
        return (SshUiData)ContainerUtil.find(items, sshUiData -> id2.equals(sshUiData.getConfig().getId()));
    }

    @Nullable
    public static SshUiData findByName(List<SshUiData> items, @NotNull String name) {
        if (name == null) {
            SshUiData.a(12);
        }
        return (SshUiData)ContainerUtil.find(items, sshUiData -> name.equals(sshUiData.getName()));
    }

    @NotNull
    public @NotNull Pair<@NotNull Credentials, @NotNull Boolean> getCredentialsAndMemoryOnly() {
        switch (this.getAuthType()) {
            case OPEN_SSH: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), (String)null), (Object)true);
                if (pair == null) {
                    SshUiData.a(13);
                }
                return pair;
            }
            case PASSWORD: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), this.getPassword()), (Object)this.isStorePassword());
                if (pair == null) {
                    SshUiData.a(14);
                }
                return pair;
            }
            case KEY_PAIR: {
                Pair pair = Pair.create((Object)new Credentials(this.getUserName(), this.getPassphrase()), (Object)this.isStorePassphrase());
                if (pair == null) {
                    SshUiData.a(15);
                }
                return pair;
            }
        }
        throw new IllegalStateException("Unexpected auth type " + this.getAuthType());
    }

    public void setCredentials(@Nullable Credentials authCredentials, boolean saveCredentialsInPermanentStore, boolean applyToPasswordSafe) {
        this.myConfig.setUsername(authCredentials == null || authCredentials.getUserName() == null ? "" : authCredentials.getUserName());
        this.myAuthData = SshConfig.AuthData.create(this.getAuthType(), authCredentials, saveCredentialsInPermanentStore);
        if (applyToPasswordSafe) {
            this.myConfig.saveAuthDataToPasswordSafe(this.myAuthData);
            ((SshConfigManager.SshConfigAuthListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConfigManager.SSH_CONFIG_AUTH)).sshConfigAuthDataChanged(this.myConfig);
        }
    }

    public void loadFromCredentials(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            SshUiData.a(16);
        }
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)this);
        if (remoteCredentials instanceof MutableRemoteCredentialsEx) {
            this.setLiteralLocalPort(((MutableRemoteCredentialsEx)remoteCredentials).getLiteralLocalPort());
        } else {
            this.setLiteralLocalPort("");
        }
    }

    public void reloadAuthDataFromPasswordSafe() {
        this.myAuthData = this.myConfig.getAuthDataFromForPasswordSafe();
    }

    public void enforceEmptyCredentials() {
        switch (this.getAuthType()) {
            case OPEN_SSH: {
                return;
            }
            case PASSWORD: {
                if (this.getPassword() == null) {
                    this.setPassword("");
                    this.saveAuthDataToPasswordSafe();
                }
                return;
            }
            case KEY_PAIR: {
                if (this.getPassphrase() == null) {
                    this.setPassphrase("");
                    this.saveAuthDataToPasswordSafe();
                }
                return;
            }
        }
        throw new IllegalStateException("Unexpected auth type " + this.getAuthType());
    }

    public void saveAuthDataToPasswordSafe() {
        this.myConfig.saveAuthDataToPasswordSafe(this.myAuthData);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SshUiData sshUiData = (SshUiData)o2;
        return this.myConfig.equals(sshUiData.myConfig) && this.myAuthData.equals(sshUiData.myAuthData);
    }

    public int hashCode() {
        return Objects.hash(this.myConfig, this.myAuthData);
    }

    @NotNull
    public static SshUiData createData(@NotNull String name, @Nullable String id2, @NotNull SshConfigVisibility visibility) {
        if (name == null) {
            SshUiData.a(17);
        }
        if (visibility == null) {
            SshUiData.a(18);
        }
        SshConfig sshConfig = new SshConfig(true);
        if (id2 != null) {
            sshConfig.setId(id2);
        }
        sshConfig.setProjectLevel(visibility == SshConfigVisibility.Project);
        SshConfig.parseContent(name, sshConfig);
        return new SshUiData(sshConfig, false);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6A8D51935D90L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshUiData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAndMemoryOnly";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCredentials";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

