/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.gradle;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.gradle.ClionGradleBundle;
import com.jetbrains.cidr.cpp.gradle.CppProjectDataService;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeBuildTarget;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.build.issue.EnvironmentIssue;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CompilationDetails;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppBinary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppComponent;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppExecutable;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppProject;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppSharedLibrary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppStaticLibrary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppTestSuite;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.LinkageDetails;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.SourceFile;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleNativeWorkspace {
    private static final String CLIENT_KEY = "GradleNative";
    private static final Logger LOG = Logger.getInstance(GradleNativeWorkspace.class);
    @NotNull
    private final AtomicClearableLazyValue<List<GradleNativeBuildTarget>> myTargets;
    private final Project myProject;
    @NotNull
    private final BackgroundTaskQueue myReloadsQueue;

    public GradleNativeWorkspace(final @NotNull Project project) {
        if (project == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myReloadsQueue = new BackgroundTaskQueue(project, ClionGradleBundle.message("loading.gradle.native.project", new Object[0]));
        this.myTargets = new AtomicClearableLazyValue<List<GradleNativeBuildTarget>>(){

            @NotNull
            protected List<GradleNativeBuildTarget> compute() {
                List<GradleNativeBuildTarget> list = GradleNativeWorkspace.loadBuildTargets(project);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/gradle/GradleNativeWorkspace$1", "compute"));
            }
        };
        ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> this.update());
    }

    @TestOnly
    public void setForceAsyncInTests(boolean value, @NotNull Disposable disposable) {
        if (disposable == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(1);
        }
        this.myReloadsQueue.setForceAsyncInTests(value, disposable);
    }

    @NotNull
    public static GradleNativeWorkspace getInstance(@NotNull Project project) {
        if (project == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(2);
        }
        GradleNativeWorkspace gradleNativeWorkspace = (GradleNativeWorkspace)project.getService(GradleNativeWorkspace.class);
        if (gradleNativeWorkspace == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(3);
        }
        return gradleNativeWorkspace;
    }

    public List<GradleNativeBuildTarget> getModelTargets() {
        return (List)this.myTargets.getValue();
    }

    @Nullable
    public OCResolveConfiguration getResolveConfigurationFor(@Nullable GradleNativeConfiguration configuration) {
        return configuration == null ? null : OCWorkspace.getInstance((Project)this.myProject).getConfigurationById(configuration.getId());
    }

    public void update() {
        if (GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
            return;
        }
        this.myReloadsQueue.run(new Task.Backgroundable(this.myProject, ClionGradleBundle.message("loading.gradle.native.project", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleNativeWorkspace.this.myTargets.drop();
                GradleNativeWorkspace.this.myTargets.getValue();
                GradleNativeWorkspace.this.updateOCWorkspace();
                ApplicationManager.getApplication().invokeLater(() -> ExecutionTargetManager.update((Project)this.myProject), this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/gradle/GradleNativeWorkspace$2", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOCWorkspace() {
        OCWorkspace.ModifiableModel workspace = OCWorkspace.getInstance((Project)this.myProject).getModifiableModel(CLIENT_KEY, true);
        CompilerInfoCache.Session compilerInfoSession = new CompilerInfoCache().createSession(ProgressIndicatorProvider.getGlobalProgressIndicator());
        MultiMap messages = new MultiMap();
        try {
            HashSet addedConfigurations = new HashSet();
            CppProjectDataService.forEachCppProject(this.myProject, (cppProject, moduleData, rootProjectPath) -> GradleNativeWorkspace.getCppBinaries(cppProject).forEach(cppBinary -> GradleNativeWorkspace.addConfiguration(this.myProject, addedConfigurations, cppBinary, rootProjectPath, moduleData, workspace, (CompilerInfoCache.Session<String>)compilerInfoSession, (MultiMap<String, CompilerInfoCache.Message>)messages)));
            compilerInfoSession.waitForAll(messages);
            workspace.preCommit();
            WriteAction.runAndWait(() -> {
                if (this.myProject.isDisposed()) {
                    workspace.dispose();
                    return;
                }
                workspace.commit();
            });
        }
        finally {
            compilerInfoSession.dispose();
            workspace.dispose();
        }
        messages.values().forEach(each -> LOG.warn(each.getType() + ": " + each.getText()));
    }

    private static CidrToolEnvironment resolveEnvironment(@NotNull Project project, @NotNull String rootProjectPath, @NotNull CppBinary cppBinary, @NotNull File compilerExecutable) {
        if (project == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(4);
        }
        if (rootProjectPath == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(5);
        }
        if (cppBinary == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(6);
        }
        if (compilerExecutable == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(7);
        }
        CPPToolchains toolchains = CPPToolchains.getInstance();
        CPPToolchains.Toolchain toolchain = toolchains.getToolchains().stream().filter(t -> {
            String toolSetPath = t.getToolSetPath();
            return toolSetPath != null && FileUtil.isAncestor((String)toolSetPath, (String)compilerExecutable.getPath(), (boolean)true);
        }).findFirst().orElse(toolchains.getDefaultToolchain());
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CidrToolEnvironment environment = (CidrToolEnvironment)ReadAction.compute(() -> {
            CPPEnvironment cppEnvironment = CPPToolchains.createCPPEnvironment((Project)project, (CPPToolchains.Toolchain)toolchain, (EnvironmentProblems)environmentProblems, (boolean)false);
            return cppEnvironment == null ? new CidrToolEnvironment() : cppEnvironment;
        });
        if (environmentProblems.hasProblems()) {
            SyncViewManager syncView = (SyncViewManager)project.getService(SyncViewManager.class);
            ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class);
            ExternalSystemTask importTask = processingManager.findTask(ExternalSystemTaskType.RESOLVE_PROJECT, GradleConstants.SYSTEM_ID, rootProjectPath);
            if (importTask != null) {
                ExternalSystemTaskId taskId = importTask.getId();
                GradleNativeWorkspace.reportProblems(environmentProblems, syncView, taskId);
            } else {
                ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
                @NlsSafe String title = cppBinary.getBaseName() + " | " + cppBinary.getVariantName();
                DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, title, "", System.currentTimeMillis());
                syncView.onEvent((Object)taskId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, ClionGradleBundle.message("configure.environment", new Object[0])));
                GradleNativeWorkspace.reportProblems(environmentProblems, syncView, taskId);
                syncView.onEvent((Object)taskId, (BuildEvent)new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), ClionGradleBundle.message("configuration.failed", new Object[0]), (EventResult)new FailureResultImpl()));
            }
        }
        return environment;
    }

    private static void reportProblems(EnvironmentProblems environmentProblems, SyncViewManager syncViewManager, ExternalSystemTaskId taskId) {
        for (EnvironmentProblems.Problem problem : environmentProblems.getProblems()) {
            syncViewManager.onEvent((Object)taskId, (BuildEvent)new BuildIssueEventImpl((Object)taskId, (BuildIssue)new EnvironmentIssue(problem), MessageEvent.Kind.ERROR));
        }
    }

    @NotNull
    private static Set<CppBinary> getCppBinaries(@NotNull CppProject cppProject) {
        CppTestSuite testComponent;
        if (cppProject == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(8);
        }
        LinkedHashSet<CppBinary> cppBinaries = new LinkedHashSet<CppBinary>();
        CppComponent mainComponent = cppProject.getMainComponent();
        if (mainComponent != null) {
            cppBinaries.addAll(mainComponent.getBinaries());
        }
        if ((testComponent = cppProject.getTestComponent()) != null) {
            cppBinaries.addAll(testComponent.getBinaries());
        }
        LinkedHashSet<CppBinary> linkedHashSet = cppBinaries;
        if (linkedHashSet == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<GradleNativeBuildTarget> loadBuildTargets(@NotNull Project project) {
        if (project == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(10);
        }
        SmartList buildTargets = new SmartList();
        CppProjectDataService.forEachCppProject(project, (arg_0, arg_1, arg_2) -> GradleNativeWorkspace.lambda$loadBuildTargets$8((List)buildTargets, arg_0, arg_1, arg_2));
        SmartList smartList = buildTargets;
        if (smartList == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static Map<File, GradleNativeConfiguration.FileSettings> convert(Set<? extends SourceFile> sources) {
        HashMap<File, GradleNativeConfiguration.FileSettings> result = new HashMap<File, GradleNativeConfiguration.FileSettings>(sources.size());
        sources.forEach(file -> result.put(file.getSourceFile(), new GradleNativeConfiguration.FileSettings(file.getObjectFile())));
        return result;
    }

    @NotNull
    private static String getConfigurationId(String moduleId, CppBinary cppBinary) {
        String string = GradleNativeWorkspace.getBuildTargetId(moduleId, cppBinary.getBaseName()) + ":" + cppBinary.getVariantName();
        if (string == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getBuildTargetId(String moduleId, String targetName) {
        String string = moduleId + ":" + targetName;
        if (string == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static GradleNativeConfiguration.TargetType getTargetType(@Nullable CppBinary cppBinary) {
        if (cppBinary == null) {
            return null;
        }
        if (cppBinary instanceof CppExecutable) {
            return GradleNativeConfiguration.TargetType.EXECUTABLE;
        }
        if (cppBinary instanceof CppStaticLibrary) {
            return GradleNativeConfiguration.TargetType.STATIC_LIBRARY;
        }
        if (cppBinary instanceof CppSharedLibrary) {
            return GradleNativeConfiguration.TargetType.SHARED_LIBRARY;
        }
        return null;
    }

    private static void addConfiguration(@NotNull Project project, Set<String> alreadyAddedConfigurations, CppBinary cppBinary, String rootProjectPath, ModuleData moduleData, OCWorkspace.ModifiableModel workspace, CompilerInfoCache.Session<String> compilerInfoSession, MultiMap<String, CompilerInfoCache.Message> messages) {
        String id;
        if (project == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(14);
        }
        if (!alreadyAddedConfigurations.add(id = GradleNativeWorkspace.getConfigurationId(moduleData.getId(), cppBinary))) {
            LOG.warn("Gradle Configuration with ID `" + id + "` has been already added to the OCWorkspace.\nThis is a bug and the case should be handled in the Gradle importer.");
            return;
        }
        @NlsSafe String configName = cppBinary.getBaseName();
        CompilationDetails compilationDetails = cppBinary.getCompilationDetails();
        File compilerExecutable = compilationDetails.getCompilerExecutable();
        if (compilerExecutable == null) {
            messages.putValue((Object)id, (Object)new CompilerInfoCache.Message(CompilerInfoCache.Message.Type.ERROR, ClionGradleBundle.message("compiler.was.not.found.for.configuration", configName)));
            return;
        }
        CidrToolEnvironment environment = GradleNativeWorkspace.resolveEnvironment(project, rootProjectPath, cppBinary, compilerExecutable);
        File buildWorkingDir = environment.getHostMachine().getOSType() == OSType.WIN ? compilerExecutable.getParentFile() : compilationDetails.getCompileWorkingDir();
        if (buildWorkingDir == null) {
            messages.putValue((Object)id, (Object)new CompilerInfoCache.Message(CompilerInfoCache.Message.Type.ERROR, ClionGradleBundle.message("compiler.working.dir.was.not.found.for.configuration", configName)));
            return;
        }
        try {
            FileUtil.ensureExists((File)buildWorkingDir);
        }
        catch (IOException e) {
            messages.putValue((Object)id, (Object)new CompilerInfoCache.Message(CompilerInfoCache.Message.Type.ERROR, e.getMessage()));
            return;
        }
        @NlsSafe String variantName = cppBinary.getVariantName();
        OCResolveConfiguration.ModifiableModel config = workspace.addConfiguration(id, configName, new OCVariant(variantName), environment.getSupportedFileSeparators());
        OCCompilerKind compilerKind = OCCompilerResolver.resolve((Project)project, (Path)environment.getHostMachine().getPath(compilerExecutable.getPath(), new String[0]), (CidrToolEnvironment)environment);
        CidrCompilerSwitches compilerSwitches = GradleNativeWorkspace.getCompilerSwitches(cppBinary, compilerKind);
        OCCompilerSettings.ModifiableModel langSettings = config.getLanguageCompilerSettings((OCLanguageKind)CLanguageKind.CPP);
        langSettings.setCompiler(compilerKind, compilerExecutable, buildWorkingDir);
        langSettings.setCompilerSwitches(compilerSwitches);
        for (SourceFile sourceFile : compilationDetails.getSources()) {
            config.addSource(VfsUtilCore.fileToUrl((File)sourceFile.getSourceFile()), (OCLanguageKind)CLanguageKind.CPP);
        }
        compilerInfoSession.schedule((Object)id, config, environment);
    }

    @NotNull
    private static CidrCompilerSwitches getCompilerSwitches(@NotNull CppBinary cppBinary, @NotNull OCCompilerKind compilerKind) {
        if (cppBinary == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(15);
        }
        if (compilerKind == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(16);
        }
        CompilerSpecificSwitchBuilder switchBuilder = (CompilerSpecificSwitchBuilder)ObjectUtils.notNull((Object)CompilerSpecificSwitchBuilder.getBuilder((OCCompilerKind)compilerKind), () -> new GCCSwitchBuilder());
        CompilationDetails compilationDetails = cppBinary.getCompilationDetails();
        switchBuilder.withSwitches(compilationDetails.getAdditionalArgs());
        StreamEx.of(compilationDetails.getUserHeaderSearchPaths()).append(compilationDetails.getSystemHeaderSearchPaths()).forEach(file -> {
            String path = FileUtil.toSystemIndependentName((String)file.getPath());
            switchBuilder.withIncludePath(path);
        });
        CidrCompilerSwitches cidrCompilerSwitches = switchBuilder.build();
        if (cidrCompilerSwitches == null) {
            GradleNativeWorkspace.$$$reportNull$$$0(17);
        }
        return cidrCompilerSwitches;
    }

    private static /* synthetic */ void lambda$loadBuildTargets$8(List buildTargets, CppProject cppProject, ModuleData moduleData, String rootProjectPath) {
        MultiMap configurationsMap = new MultiMap();
        for (CppBinary cppBinary : GradleNativeWorkspace.getCppBinaries(cppProject)) {
            LinkageDetails linkerDetails = cppBinary.getLinkageDetails();
            String linkTaskName = linkerDetails.getLinkTask().getQName();
            CompilationDetails compilationDetails = cppBinary.getCompilationDetails();
            String compileTaskName = compilationDetails.getCompileTask().getQName();
            String id = GradleNativeWorkspace.getConfigurationId(moduleData.getId(), cppBinary);
            GradleNativeConfiguration configuration = new GradleNativeConfiguration(id, cppBinary.getBaseName(), cppBinary.getVariantName(), linkerDetails.getOutputLocation(), GradleNativeWorkspace.getTargetType(cppBinary), linkTaskName, compileTaskName, rootProjectPath, compilationDetails.getAdditionalArgs(), GradleNativeWorkspace.convert(compilationDetails.getSources()));
            Trinity names = Trinity.create((Object)moduleData.getId(), (Object)moduleData.getExternalName(), (Object)cppBinary.getBaseName());
            configurationsMap.putValue((Object)names, (Object)configuration);
        }
        configurationsMap.entrySet().forEach(entry -> {
            Trinity names = (Trinity)entry.getKey();
            Collection value = (Collection)entry.getValue();
            List configurations = value instanceof List ? (List)value : new ArrayList(value);
            String moduleId = (String)names.first;
            String moduleName = (String)names.second;
            String targetName = (String)names.third;
            String targetId = GradleNativeWorkspace.getBuildTargetId(moduleId, targetName);
            buildTargets.add(new GradleNativeBuildTarget(targetId, targetName, moduleName, configurations));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/gradle/GradleNativeWorkspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cppBinary";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cppProject";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/gradle/GradleNativeWorkspace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCppBinaries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBuildTargets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTargetId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSwitches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setForceAsyncInTests";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCppBinaries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadBuildTargets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSwitches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

