/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class ClazyAnnotator
extends ClangTidyAnnotator {
    private static final Logger LOG = Logger.getInstance(ClazyAnnotator.class);
    public static final Key<Boolean> TAKE_CLAZY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLAZY_CONFIG");
    private final ClazyInspection myPairedInspection;

    public ClazyAnnotator() {
        this(null);
    }

    public ClazyAnnotator(ClazyInspection inspection) {
        this.myPairedInspection = inspection;
    }

    @Override
    public String getPairedBatchInspectionShortName() {
        return ClazyInspection.getInspectionShortName();
    }

    @Override
    ClangTidyInspectionBase getInspection(OCPsiFile ocFile, Project project) {
        return this.myPairedInspection != null ? this.myPairedInspection : ClangTidyUtil.getClazyInspection((PsiFile)ocFile, project);
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project;
        if (info == null) {
            ClazyAnnotator.$$$reportNull$$$0(0);
        }
        if (ClangUtils.isClangdOn((Project)(project = info.getProject())) && ClangUtils.isClangTidyViaClangdOn((Project)project)) {
            if (info.getFile().getVirtualFile() == null) {
                return false;
            }
            if (ClangUtils.isClangTidyViaClangdForced((Project)project)) {
                return true;
            }
            return info.getEditor() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ClangTidyAnnotationHolder executeClazy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        if (info == null) {
            ClazyAnnotator.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            ClazyAnnotator.$$$reportNull$$$0(2);
        }
        if (!(info.getInspection() instanceof ClazyInspection)) {
            return null;
        }
        if (ClazyAnnotator.useLanguageService(info)) {
            ClangUtils.traceClangd((Logger)LOG, (String)"Clangd is used for clazy diagnostics");
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            SensitiveProgressWrapper newIndicator = currentIndicator != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
            Ref result2 = Ref.create();
            ClangTidyAnnotator.MyMasterReparsingPassListener masterListener = ClazyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
            ClangTidyAnnotator.MySlaveReparsingPassListener slaveListener = new ClangTidyAnnotator.MySlaveReparsingPassListener((ProgressIndicator)newIndicator, (PsiFile)info.getFile());
            try {
                masterListener.addListener(slaveListener);
                ProgressManager.getInstance().runProcess(() -> {
                    Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                    if (!isFileValid.booleanValue()) {
                        return;
                    }
                    ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted((Project)info.getProject());
                    result2.set((Object)((ClangTidyAnnotationHolder)languageService.computeWithParsed(info.getFile().getVirtualFile(), response -> {
                        if (response == null) {
                            return null;
                        }
                        try {
                            ArrayList<ClangTidyDiagnostic> diagnostics2 = new ArrayList<ClangTidyDiagnostic>();
                            if (info.getProject().getUserData(TAKE_CLAZY_CONFIG) != Boolean.FALSE) {
                                CompletableFuture clazyDiagsFuture = response.getClazyDiagnostics();
                                Supplier clazySupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware((Future)clazyDiagsFuture, (long)Long.MAX_VALUE, (String)"Clazy diagnostics");
                                if (clazySupplier == null) {
                                    return null;
                                }
                                @NlsSafe CharSequence text = info.getDocument().getCharsSequence();
                                diagnostics2.addAll(ClazyAnnotator.convertClazyDiags((List)clazySupplier.get(), text, info.getInputFileName()));
                            }
                            return ClangTidyAnnotationHolder.success(diagnostics2);
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            return null;
                        }
                    })));
                }, (ProgressIndicator)newIndicator);
            }
            finally {
                masterListener.removeListener(slaveListener);
            }
            return (ClangTidyAnnotationHolder)result2.get();
        }
        ClangUtils.traceClangd((Logger)LOG, (String)"Clazy is used for clazy diagnostics");
        boolean collectDebugInformation = info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
        StringBuilder debugInformation = new StringBuilder();
        File clazyPath = ClazyAnnotator.getBuiltinClazyPath();
        ClangTidyInspectionBase inspection = info.getInspection();
        if (!ClazyAnnotator.isAvailable(clazyPath)) {
            return ClangTidyAnnotationHolder.error(OCInspectionsBundle.message((String)"inspection.clazy.not.found", (Object[])new Object[0]));
        }
        Document document = info.getDocument();
        long modificationStampOnStart = document.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClazyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClazyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory);
        File outputFile = new File(workingDirectory, "output.yaml");
        File compilationDatabase = ClazyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile);
        if (collectDebugInformation) {
            ClazyAnnotator.putDebugInformation(debugInformation, "Compilation Database", FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(clazyPath.getAbsolutePath());
        String checksConfig = ClazyAnnotator.getClazyChecks(inspection);
        commandLine.addParameter("-checks=" + checksConfig);
        commandLine.addParameter("-p=" + workingDirectory);
        commandLine.addParameter("--vfsoverlay=" + vfsOverlay);
        commandLine.addParameter("--export-fixes=" + outputFile);
        commandLine.addParameter("--ignore-included-files");
        commandLine.addParameter(inputFile.getAbsolutePath());
        if (collectDebugInformation) {
            ClazyAnnotator.putDebugInformation(debugInformation, "Command-Line", commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClazyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document.getModificationStamp()) {
            return null;
        }
        if (progressIndicator != null) {
            processHandler.runProcessWithProgressIndicator(progressIndicator);
        } else {
            processHandler.runProcess();
        }
        if (collectDebugInformation) {
            ClazyAnnotator.putDebugInformation(debugInformation, "Output", outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, (Object)debugInformation.toString());
        }
        List diagnostics2 = outputFile.exists() ? ClazyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping) : Collections.emptyList();
        diagnostics2 = ContainerUtil.filter(diagnostics2, diagnostic -> diagnostic.getDiagnosticName().startsWith("clazy-"));
        return ClangTidyAnnotationHolder.success(diagnostics2);
    }

    @NlsSafe
    @NotNull
    private static String getClazyChecks(@NotNull ClangTidyInspectionBase inspection) {
        if (inspection == null) {
            ClazyAnnotator.$$$reportNull$$$0(3);
        }
        if (inspection instanceof ClazyInspection) {
            ClazyInspection clazyInspection = (ClazyInspection)inspection;
            String string = clazyInspection.getClazyChecks();
            if (string == null) {
                ClazyAnnotator.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        if (info == null) {
            return null;
        }
        ClazyAnnotator.tryRegisterDocumentListener(info);
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"clion-clazy", null, (boolean)true);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClazyAnnotator.executeClazy(info, workingDirectory);
            return clangTidyAnnotationHolder;
        }
        catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
            LOG.warn(exc);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotationHolder.error(exc.getMessage());
            return clangTidyAnnotationHolder;
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    private static List<ClangTidyDiagnostic> convertClazyDiags(List<ClangDiagnostic> clangDiagnostics, CharSequence text, String inputFilename) {
        ArrayList<ClangTidyDiagnostic> diagnostics2 = new ArrayList<ClangTidyDiagnostic>();
        for (ClangDiagnostic diag : clangDiagnostics) {
            int endOffset;
            ArrayList<ClangTidyRange> tidyRanges = new ArrayList<ClangTidyRange>();
            ArrayList<ClangTidyReplacement> tidyReplacements = new ArrayList<ClangTidyReplacement>();
            int offset = StringUtil.lineColToOffset((CharSequence)text, (int)diag.getStartLine(), (int)diag.getStartColumn());
            if (offset < 0) {
                offset = text.length() - 1;
            }
            if ((endOffset = StringUtil.lineColToOffset((CharSequence)text, (int)diag.getEndLine(), (int)diag.getEndColumn())) < 0) {
                endOffset = text.length() - 1;
            }
            tidyRanges.add(new ClangTidyRange(inputFilename, offset, endOffset - offset));
            for (CodeAction fixit : diag.getClangdFixits()) {
                Map changes = fixit.getEdit().getChanges();
                for (String url : changes.keySet()) {
                    String path = VfsUtilCore.urlToPath((String)url);
                    List edits = (List)changes.get(url);
                    for (TextEdit edit : edits) {
                        Position start = edit.getRange().getStart();
                        Position end = edit.getRange().getEnd();
                        int fixitStartOffset = StringUtil.lineColToOffset((CharSequence)text, (int)start.getLine(), (int)start.getCharacter());
                        int fixitEndOffset = StringUtil.lineColToOffset((CharSequence)text, (int)end.getLine(), (int)end.getCharacter());
                        if (fixitStartOffset < 0) {
                            fixitStartOffset = text.length() - 1;
                        }
                        if (fixitEndOffset < 0) {
                            fixitEndOffset = text.length() - 1;
                        }
                        ClangTidyReplacement tidyReplacement = new ClangTidyReplacement(path, edit.getNewText(), fixitStartOffset, fixitEndOffset);
                        tidyReplacements.add(tidyReplacement);
                    }
                }
            }
            String clazyMessage = diag.getMessage();
            int clazyDiagNameStart = clazyMessage.indexOf("-Wclazy");
            if (clazyDiagNameStart < 0) continue;
            int clazyDiagNameEnd = clazyMessage.indexOf("]", clazyDiagNameStart);
            ClangTidyDiagnostic tidyDiag = new ClangTidyDiagnostic(clazyMessage.substring(0, clazyDiagNameStart - 1).trim(), clazyMessage.substring(clazyDiagNameStart, clazyDiagNameEnd), inputFilename, offset, tidyRanges, tidyReplacements, null);
            diagnostics2.add(tidyDiag);
        }
        return diagnostics2;
    }

    @NotNull
    public static File getBuiltinClazyPath() {
        File file = ClangUtils.getBuiltinClangToolPath((String)(SystemInfo.isWindows ? "clazy-standalone.exe" : "clazy-standalone"));
        if (file == null) {
            ClazyAnnotator.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClazyAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClazyAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClazyChecks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClazyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useLanguageService";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeClazy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClazyChecks";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

