/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativePackager;
import com.jetbrains.plugins.reactnative.ReactNativePackagerBeforeRunTask;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\nH\u0016J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "()V", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "task", "createTask", "runConfiguration", "executeTask", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getIcon", "Ljavax/swing/Icon;", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "", "isConfigurable", "Companion", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativePackagerBeforeRunTaskProvider
extends BeforeRunTaskProvider<ReactNativePackagerBeforeRunTask> {
    @NotNull
    private static final Key<ReactNativePackagerBeforeRunTask> ID;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<ReactNativePackagerBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @NotNull
    public String getName() {
        String string = JSDebuggerBundle.message((String)"react.native.task.bundler", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSDebuggerBundle.message\u2026act.native.task.bundler\")");
        return string;
    }

    @Nullable
    public ReactNativePackagerBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        return runConfiguration instanceof ReactNativeRunConfiguration ? new ReactNativePackagerBeforeRunTask() : null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull ReactNativePackagerBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        if (!(configuration instanceof ReactNativeRunConfiguration)) {
            JavaScriptDebugProcessKt.getLOG().error("Can't apply ReactNativePackagerBeforeRunTask to " + configuration.getClass().getName());
            return false;
        }
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"env.project");
        PackagerState packagerState = ReactNativePackager.Companion.getInstance(project).startPackager((ReactNativeRunConfiguration)configuration);
        if (packagerState == null) {
            NotificationGroup notificationGroup = JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP();
            String string = JSDebuggerBundle.message((String)"react.native.task.error", (Object[])new Object[]{this.getName(), ((ReactNativeRunConfiguration)configuration).getName()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSDebuggerBundle.message\u2026name, configuration.name)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
            notificationGroup.createNotification(string, messageType).notify(env.getProject());
            return false;
        }
        ProcessHandler packagerProcess = packagerState.getProcess();
        if (!packagerState.getAlreadyStarted()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(packagerProcess, env){
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ExecutionEnvironment $env;

                public final void run() {
                    ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native start", this.$packagerProcess, this.$env);
                    this.$packagerProcess.startNotify();
                }
                {
                    this.$packagerProcess = processHandler;
                    this.$env = executionEnvironment;
                }
            });
        }
        return true;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ReactNativePackagerBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        ReactNativePackagerConfigurationEditor dialog = new ReactNativePackagerConfigurationEditor(project);
        dialog.show();
        return Promises.resolvedPromise((Object)false);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ReactNativePackager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<ReactNativePa\u2026k>(\"ReactNativePackager\")");
        ID = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider$Companion;", "", "()V", "ID", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getID$intellij_javascript_reactNativeDebugger", "()Lcom/intellij/openapi/util/Key;", "intellij.javascript.reactNativeDebugger"})
    public static final class Companion {
        @NotNull
        public final Key<ReactNativePackagerBeforeRunTask> getID$intellij_javascript_reactNativeDebugger() {
            return ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

