/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipGlobalEvaluateContext;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm$WhenMappings;
import org.jetbrains.wip.WipWorkerManager;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.State;
import org.jetbrains.wip.protocol.network.NetworkKt;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;
import org.jetbrains.wip.protocol.page.FrameValue;
import org.jetbrains.wip.protocol.page.PageKt;
import org.jetbrains.wip.protocol.runtime.ExecutionContextDestroyedEventData;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010<\u001a\u00020(2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020(0>J\n\u0010?\u001a\u0004\u0018\u00010@H\u0014J\b\u0010A\u001a\u000204H\u0014J\u0006\u0010B\u001a\u00020(J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020(0DJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020(0DJ\u0006\u0010F\u001a\u00020(J\u0010\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010\u001cJ\b\u0010J\u001a\u00020(H\u0016J\u0006\u0010&\u001a\u00020(J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000bH\u0002J\u0014\u0010N\u001a\u0006\u0012\u0002\b\u00030D2\u0006\u0010M\u001a\u00020\u000bH\u0016J\u0018\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020HH\u0002J\u0014\u0010R\u001a\u00020H2\n\u0010S\u001a\u0006\u0012\u0002\b\u00030TH$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020(0\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020/\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u000f\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010#\"\u0004\b9\u0010%R\u0014\u0010:\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b;\u0010\u000f\u00a8\u0006U"}, d2={"Lorg/jetbrains/wip/WipVm;", "Lorg/jetbrains/debugger/VmBase;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "workerManagerFactory", "Lkotlin/Function1;", "Lorg/jetbrains/wip/WipWorkerManager;", "(Lorg/jetbrains/debugger/DebugEventListener;Lorg/jetbrains/wip/WipCommandProcessor;Lkotlin/jvm/functions/Function1;)V", "breakOnExceptionMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "breakpointManager", "Lorg/jetbrains/wip/WipBreakpointManager;", "getBreakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/wip/WipBreakpointManager;", "getCommandProcessor", "()Lorg/jetbrains/wip/WipCommandProcessor;", "<set-?>", "Lcom/intellij/util/Url;", "currentUrl", "getCurrentUrl", "()Lcom/intellij/util/Url;", "setCurrentUrl", "(Lcom/intellij/util/Url;)V", "frameId", "", "networkManager", "Lorg/jetbrains/wip/WipNetworkManager;", "getNetworkManager", "()Lorg/jetbrains/wip/WipNetworkManager;", "presentableName", "getPresentableName", "()Ljava/lang/String;", "setPresentableName", "(Ljava/lang/String;)V", "ready", "Ljava/util/concurrent/CompletableFuture;", "", "registerVmPrintEvents", "getRegisterVmPrintEvents", "()Lkotlin/jvm/functions/Function1;", "setRegisterVmPrintEvents", "(Lkotlin/jvm/functions/Function1;)V", "scriptManager", "Lorg/jetbrains/wip/WipScriptManager;", "getScriptManager$annotations", "getScriptManager", "()Lorg/jetbrains/wip/WipScriptManager;", "suspendContextManager", "Lorg/jetbrains/wip/WipSuspendContextManager;", "getSuspendContextManager", "()Lorg/jetbrains/wip/WipSuspendContextManager;", "title", "getTitle", "setTitle", "workerManager", "getWorkerManager$annotations", "addReadyListener", "handler", "Lkotlin/Function0;", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "createSuspendManager", "enableDebugger", "enableNetwork", "Lorg/jetbrains/concurrency/Promise;", "enablePage", "enableWorkers", "hasWorker", "", "workerId", "initDomains", "sdkToWipCatchMode", "Lorg/jetbrains/wip/protocol/debugger/State;", "catchMode", "setBreakOnException", "updateUrl", "url", "silent", "write", "message", "Lorg/jetbrains/jsonProtocol/Request;", "intellij.javascript.wip.backend"})
public abstract class WipVm
extends VmBase {
    public Function1<? super WipVm, Unit> registerVmPrintEvents;
    @NotNull
    private final WipScriptManager scriptManager;
    @NotNull
    private final WipCommandProcessor commandProcessor;
    @NotNull
    private String presentableName;
    @NotNull
    private final WipBreakpointManager breakpointManager;
    @NotNull
    private final WipSuspendContextManager suspendContextManager;
    @NotNull
    private final WipNetworkManager networkManager;
    private final WipWorkerManager workerManager;
    private ExceptionCatchMode breakOnExceptionMode;
    @Nullable
    private volatile Url currentUrl;
    private String frameId;
    private final CompletableFuture<Unit> ready;
    @Nullable
    private volatile String title;

    @NotNull
    public final Function1<WipVm, Unit> getRegisterVmPrintEvents() {
        Function1<? super WipVm, Unit> function1 = this.registerVmPrintEvents;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"registerVmPrintEvents");
        }
        return function1;
    }

    public final void setRegisterVmPrintEvents(@NotNull Function1<? super WipVm, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.registerVmPrintEvents = function1;
    }

    public static /* synthetic */ void getScriptManager$annotations() {
    }

    @NotNull
    public final WipScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @NotNull
    public final WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    public void setPresentableName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.presentableName = string;
    }

    public static /* synthetic */ void getBreakpointManager$annotations() {
    }

    @NotNull
    public WipBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @NotNull
    protected WipSuspendContextManager createSuspendManager() {
        return new WipSuspendContextManager(this);
    }

    @NotNull
    public WipSuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    @NotNull
    public final WipNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    private static /* synthetic */ void getWorkerManager$annotations() {
    }

    @Nullable
    public final Url getCurrentUrl() {
        return this.currentUrl;
    }

    protected final void setCurrentUrl(@Nullable Url url) {
        this.currentUrl = url;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    protected abstract boolean write(@NotNull Request<?> var1);

    public void initDomains() {
        Application application;
        this.enableDebugger();
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        if (application2.isUnitTestMode() || application.isHeadlessEnvironment()) {
            this.commandProcessor.send((Request)NetworkKt.SetCacheDisabled(true));
        }
    }

    public final void enableDebugger() {
        this.commandProcessor.send((Request)DebuggerKt.Enable$default(null, 1, null));
    }

    @NotNull
    public final Promise<Unit> enablePage() {
        return this.commandProcessor.send((Request)PageKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enableNetwork() {
        return this.networkManager.enable(this.commandProcessor);
    }

    public final void enableWorkers() {
        this.workerManager.enableWorkers();
    }

    private final void updateUrl(String url, boolean silent) {
        this.currentUrl = Urls.newFromEncoded((String)url);
        if (silent) {
            return;
        }
        this.scriptManager.clear(this.getDebugListener());
        this.getBreakpointManager().clearNonProvisionalBreakpoints();
        this.getDebugListener().navigated(url);
        this.getSuspendContextManager().getEvaluateHack$intellij_javascript_wip_backend().pageReloaded$intellij_javascript_wip_backend();
    }

    @NotNull
    public Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkNotNullParameter((Object)catchMode, (String)"catchMode");
        this.breakOnExceptionMode = catchMode;
        return this.commandProcessor.send((Request)DebuggerKt.SetPauseOnExceptions(this.sdkToWipCatchMode(catchMode)));
    }

    private final State sdkToWipCatchMode(ExceptionCatchMode catchMode) {
        switch (WipVm$WhenMappings.$EnumSwitchMapping$0[catchMode.ordinal()]) {
            case 1: {
                return State.ALL;
            }
            case 2: {
                return State.UNCAUGHT;
            }
            case 3: {
                return State.NONE;
            }
        }
        throw (Throwable)new IllegalArgumentException(catchMode.name());
    }

    @Nullable
    protected EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new WipGlobalEvaluateContext(new WipValueManager(this, "ce"));
    }

    public final void ready() {
        this.ready.complete(Unit.INSTANCE);
        this.commandProcessor.send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void addReadyListener(@NotNull Function0<Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.ready.thenApply(new Function(handler2){
            final /* synthetic */ Function0 $handler;

            public final void apply(Unit it) {
                this.$handler.invoke();
            }
            {
                this.$handler = function0;
            }
        });
    }

    public final boolean hasWorker(@Nullable String workerId) {
        return this.workerManager.hasWorker(workerId);
    }

    public WipVm(@NotNull DebugEventListener tabListener, @Nullable WipCommandProcessor commandProcessor2, @NotNull Function1<? super WipVm, ? extends WipWorkerManager> workerManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)tabListener, (String)"tabListener");
        Intrinsics.checkNotNullParameter(workerManagerFactory, (String)"workerManagerFactory");
        super(tabListener);
        this.scriptManager = new WipScriptManager(this);
        WipCommandProcessor wipCommandProcessor = commandProcessor2;
        if (wipCommandProcessor == null) {
            wipCommandProcessor = new WipCommandProcessor((Function1)new Function1<Request<?>, Boolean>(this){
                final /* synthetic */ WipVm this$0;

                public final boolean invoke(@NotNull Request<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.this$0.write(it);
                }
                {
                    this.this$0 = wipVm;
                    super(1);
                }
            });
        }
        this.commandProcessor = wipCommandProcessor;
        String string = XDebuggerBundle.message((String)"debugger.session.tab.frames.thread.main", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XDebuggerBundle.message(\u2026.tab.frames.thread.main\")");
        this.presentableName = string;
        this.breakpointManager = new WipBreakpointManager(this);
        this.suspendContextManager = this.createSuspendManager();
        this.networkManager = new WipNetworkManager(this.commandProcessor.getEventMap());
        this.workerManager = (WipWorkerManager)workerManagerFactory.invoke((Object)this);
        this.breakOnExceptionMode = ExceptionCatchMode.NONE;
        this.ready = new CompletableFuture();
        EventMap<ProtocolResponseReader> eventMap = this.commandProcessor.getEventMap();
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, (Function1)new Function1<FrameNavigatedEventData, Unit>(){

            public final void invoke(@NotNull FrameNavigatedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FrameValue frame = it.frame();
                if (frame.getParentId() == null) {
                    frameId = frame.id();
                    this.updateUrl(frame.url(), false);
                }
            }
        });
        eventMap.add((EventType)ScriptParsedEventData.TYPE, (Function1)new Function1<ScriptParsedEventData, Unit>(){

            public final void invoke(@NotNull ScriptParsedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getScriptManager().scriptParsed(it);
            }
        });
        eventMap.add((EventType)BreakpointResolvedEventData.TYPE, (Function1)new Function1<BreakpointResolvedEventData, Unit>(){

            public final void invoke(@NotNull BreakpointResolvedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getBreakpointManager().breakpointReportedResolved(it);
            }
        });
        eventMap.add((EventType)ExecutionContextDestroyedEventData.TYPE, (Function1)new Function1<ExecutionContextDestroyedEventData, Unit>(){

            public final void invoke(@NotNull ExecutionContextDestroyedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getScriptManager().executionContextDestroyed(it);
            }
        });
        this.workerManager.registerWorkerEvents(eventMap);
    }

    public /* synthetic */ WipVm(DebugEventListener debugEventListener, WipCommandProcessor wipCommandProcessor, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            wipCommandProcessor = null;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(debugEventListener, wipCommandProcessor, (Function1<? super WipVm, ? extends WipWorkerManager>)function1);
    }

    public static final /* synthetic */ String access$getFrameId$p(WipVm $this) {
        return $this.frameId;
    }
}

